/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import com.carrotsearch.hppc.FloatArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.percolator.PercolateContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.HighlightPhase;

abstract class QueryCollector
extends SimpleCollector {
    final IndexFieldData<?> uidFieldData;
    final IndexSearcher searcher;
    final ConcurrentMap<BytesRef, Query> queries;
    final ESLogger logger;
    boolean isNestedDoc = false;
    BytesRef current;
    SortedBinaryDocValues values;
    final BucketCollector aggregatorCollector;
    LeafCollector aggregatorLeafCollector;

    QueryCollector(ESLogger logger, PercolateContext context, boolean isNestedDoc) throws IOException {
        this.logger = logger;
        this.queries = context.percolateQueries();
        this.searcher = context.docSearcher();
        MappedFieldType uidMapper = context.mapperService().smartNameFieldType("_uid");
        this.uidFieldData = context.fieldData().getForField(uidMapper);
        this.isNestedDoc = isNestedDoc;
        ArrayList<Aggregator> aggregatorCollectors = new ArrayList<Aggregator>();
        if (context.aggregations() != null) {
            AggregationContext aggregationContext = new AggregationContext(context);
            context.aggregations().aggregationContext(aggregationContext);
            Aggregator[] aggregators = context.aggregations().factories().createTopLevelAggregators(aggregationContext);
            for (int i = 0; i < aggregators.length; ++i) {
                if (aggregators[i] instanceof GlobalAggregator) continue;
                Aggregator aggregator = aggregators[i];
                aggregatorCollectors.add(aggregator);
            }
            context.aggregations().aggregators(aggregators);
        }
        this.aggregatorCollector = BucketCollector.wrap(aggregatorCollectors);
        this.aggregatorCollector.preCollection();
    }

    public void postMatch(int doc) throws IOException {
        this.aggregatorLeafCollector.collect(doc);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.aggregatorLeafCollector.setScorer(scorer);
    }

    public boolean needsScores() {
        return this.aggregatorCollector.needsScores();
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.values = this.uidFieldData.load(context).getBytesValues();
        this.aggregatorLeafCollector = this.aggregatorCollector.getLeafCollector(context);
    }

    static Match match(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase, boolean isNestedDoc) throws IOException {
        return new Match(logger, context, highlightPhase, isNestedDoc);
    }

    static Count count(ESLogger logger, PercolateContext context, boolean isNestedDoc) throws IOException {
        return new Count(logger, context, isNestedDoc);
    }

    static MatchAndScore matchAndScore(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase, boolean isNestedDoc) throws IOException {
        return new MatchAndScore(logger, context, highlightPhase, isNestedDoc);
    }

    static MatchAndSort matchAndSort(ESLogger logger, PercolateContext context, boolean isNestedDoc) throws IOException {
        return new MatchAndSort(logger, context, isNestedDoc);
    }

    protected final Query getQuery(int doc) {
        this.values.setDocument(doc);
        int numValues = this.values.count();
        if (numValues == 0) {
            return null;
        }
        assert (numValues == 1);
        this.current = Uid.splitUidIntoTypeAndId(this.values.valueAt(0))[1];
        return (Query)this.queries.get(this.current);
    }

    static final class Count
    extends QueryCollector {
        private long counter = 0L;

        Count(ESLogger logger, PercolateContext context, boolean isNestedDoc) throws IOException {
            super(logger, context, isNestedDoc);
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            Query existsQuery = query;
            if (this.isNestedDoc) {
                existsQuery = new BooleanQuery.Builder().add(existsQuery, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter(), BooleanClause.Occur.FILTER).build();
            }
            try {
                if (Lucene.exists(this.searcher, existsQuery)) {
                    ++this.counter;
                    this.postMatch(doc);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.current.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        long counter() {
            return this.counter;
        }
    }

    static final class MatchAndScore
    extends QueryCollector {
        final PercolateContext context;
        final HighlightPhase highlightPhase;
        final List<BytesRef> matches = new ArrayList<BytesRef>();
        final List<Map<String, HighlightField>> hls = new ArrayList<Map<String, HighlightField>>();
        final FloatArrayList scores = new FloatArrayList();
        final boolean limit;
        final int size;
        long counter = 0L;
        private Scorer scorer;

        MatchAndScore(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase, boolean isNestedDoc) throws IOException {
            super(logger, context, isNestedDoc);
            this.limit = context.limit;
            this.size = context.size();
            this.context = context;
            this.highlightPhase = highlightPhase;
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            Query existsQuery = query;
            if (this.isNestedDoc) {
                existsQuery = new BooleanQuery.Builder().add(existsQuery, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter(), BooleanClause.Occur.FILTER).build();
            }
            try {
                if (this.context.highlight() != null) {
                    this.context.parsedQuery(new ParsedQuery(query));
                    this.context.hitContext().cache().clear();
                }
                if (Lucene.exists(this.searcher, existsQuery)) {
                    if (!this.limit || this.counter < (long)this.size) {
                        this.matches.add(BytesRef.deepCopyOf((BytesRef)this.current));
                        this.scores.add(this.scorer.score());
                        if (this.context.highlight() != null) {
                            this.highlightPhase.hitExecute(this.context, this.context.hitContext());
                            this.hls.add(this.context.hitContext().hit().getHighlightFields());
                        }
                    }
                    ++this.counter;
                    this.postMatch(doc);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.current.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        long counter() {
            return this.counter;
        }

        List<BytesRef> matches() {
            return this.matches;
        }

        FloatArrayList scores() {
            return this.scores;
        }

        List<Map<String, HighlightField>> hls() {
            return this.hls;
        }
    }

    static final class MatchAndSort
    extends QueryCollector {
        private final TopScoreDocCollector topDocsCollector;
        private LeafCollector topDocsLeafCollector;

        MatchAndSort(ESLogger logger, PercolateContext context, boolean isNestedDoc) throws IOException {
            super(logger, context, isNestedDoc);
            this.topDocsCollector = TopScoreDocCollector.create((int)context.size());
        }

        @Override
        public boolean needsScores() {
            return super.needsScores() || this.topDocsCollector.needsScores();
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            Query existsQuery = query;
            if (this.isNestedDoc) {
                existsQuery = new BooleanQuery.Builder().add(existsQuery, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter(), BooleanClause.Occur.FILTER).build();
            }
            try {
                if (Lucene.exists(this.searcher, existsQuery)) {
                    this.topDocsLeafCollector.collect(doc);
                    this.postMatch(doc);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.current.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        @Override
        public void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.topDocsLeafCollector = this.topDocsCollector.getLeafCollector(context);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.topDocsLeafCollector.setScorer(scorer);
        }

        TopDocs topDocs() {
            return this.topDocsCollector.topDocs();
        }
    }

    static final class Match
    extends QueryCollector {
        final PercolateContext context;
        final HighlightPhase highlightPhase;
        final List<BytesRef> matches = new ArrayList<BytesRef>();
        final List<Map<String, HighlightField>> hls = new ArrayList<Map<String, HighlightField>>();
        final boolean limit;
        final int size;
        long counter = 0L;

        Match(ESLogger logger, PercolateContext context, HighlightPhase highlightPhase, boolean isNestedDoc) throws IOException {
            super(logger, context, isNestedDoc);
            this.limit = context.limit;
            this.size = context.size();
            this.context = context;
            this.highlightPhase = highlightPhase;
        }

        public void collect(int doc) throws IOException {
            Query query = this.getQuery(doc);
            if (query == null) {
                return;
            }
            Query existsQuery = query;
            if (this.isNestedDoc) {
                existsQuery = new BooleanQuery.Builder().add(existsQuery, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter(), BooleanClause.Occur.FILTER).build();
            }
            try {
                if (this.context.highlight() != null) {
                    this.context.parsedQuery(new ParsedQuery(query));
                    this.context.hitContext().cache().clear();
                }
                if (Lucene.exists(this.searcher, existsQuery)) {
                    if (!this.limit || this.counter < (long)this.size) {
                        this.matches.add(BytesRef.deepCopyOf((BytesRef)this.current));
                        if (this.context.highlight() != null) {
                            this.highlightPhase.hitExecute(this.context, this.context.hitContext());
                            this.hls.add(this.context.hitContext().hit().getHighlightFields());
                        }
                    }
                    ++this.counter;
                    this.postMatch(doc);
                }
            }
            catch (IOException e) {
                this.logger.warn("[" + this.current.utf8ToString() + "] failed to execute query", e, new Object[0]);
            }
        }

        long counter() {
            return this.counter;
        }

        List<BytesRef> matches() {
            return this.matches;
        }

        List<Map<String, HighlightField>> hls() {
            return this.hls;
        }
    }
}

