/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.RepositoryName;
import org.elasticsearch.repositories.RepositorySettings;
import org.elasticsearch.repositories.RepositoryTypesRegistry;

public class RepositoryModule
extends AbstractModule {
    private RepositoryName repositoryName;
    private final Settings globalSettings;
    private final Settings settings;
    private final RepositoryTypesRegistry typesRegistry;

    public RepositoryModule(RepositoryName repositoryName, Settings settings, Settings globalSettings, RepositoryTypesRegistry typesRegistry) {
        this.repositoryName = repositoryName;
        this.globalSettings = globalSettings;
        this.settings = settings;
        this.typesRegistry = typesRegistry;
    }

    @Override
    protected void configure() {
        this.typesRegistry.bindType(this.binder(), this.repositoryName.type());
        this.bind(RepositorySettings.class).toInstance(new RepositorySettings(this.globalSettings, this.settings));
    }
}

