/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.cardinality;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.metrics.cardinality.CardinalityAggregator;
import org.elasticsearch.search.aggregations.metrics.cardinality.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.cardinality.InternalCardinality;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

final class CardinalityAggregatorFactory
extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource> {
    private final long precisionThreshold;

    CardinalityAggregatorFactory(String name, ValuesSourceConfig config, long precisionThreshold) {
        super(name, InternalCardinality.TYPE.name(), config);
        this.precisionThreshold = precisionThreshold;
    }

    private int precision(Aggregator parent) {
        return this.precisionThreshold < 0L ? CardinalityAggregatorFactory.defaultPrecision(parent) : HyperLogLogPlusPlus.precisionFromThreshold(this.precisionThreshold);
    }

    @Override
    protected Aggregator createUnmapped(AggregationContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new CardinalityAggregator(this.name, null, this.precision(parent), this.config.formatter(), context, parent, pipelineAggregators, metaData);
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource valuesSource, AggregationContext context, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new CardinalityAggregator(this.name, valuesSource, this.precision(parent), this.config.formatter(), context, parent, pipelineAggregators, metaData);
    }

    private static int defaultPrecision(Aggregator parent) {
        int precision = 14;
        while (parent != null) {
            if (!(parent instanceof SingleBucketAggregator)) {
                precision -= 5;
            }
            parent = parent.parent();
        }
        return Math.max(precision, 4);
    }
}

