/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.hdr;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.AbstractHDRPercentilesAggregator;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.InternalHDRPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.InternalHDRPercentiles;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class HDRPercentileRanksAggregator
extends AbstractHDRPercentilesAggregator {
    public HDRPercentileRanksAggregator(String name, ValuesSource.Numeric valuesSource, AggregationContext context, Aggregator parent, double[] percents, int numberOfSignificantValueDigits, boolean keyed, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, valuesSource, context, parent, percents, numberOfSignificantValueDigits, keyed, formatter, pipelineAggregators, metaData);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        DoubleHistogram state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalHDRPercentileRanks(this.name, this.keys, state, this.keyed, this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        DoubleHistogram state = new DoubleHistogram(this.numberOfSignificantValueDigits);
        state.setAutoResize(true);
        return new InternalHDRPercentileRanks(this.name, this.keys, state, this.keyed, this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        DoubleHistogram state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return InternalHDRPercentileRanks.percentileRank(state, Double.valueOf(name));
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        private final double[] values;
        private final int numberOfSignificantValueDigits;
        private final boolean keyed;

        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig, double[] values, int numberOfSignificantValueDigits, boolean keyed) {
            super(name, InternalHDRPercentiles.TYPE.name(), valuesSourceConfig);
            this.values = values;
            this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
            this.keyed = keyed;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new HDRPercentileRanksAggregator(this.name, null, aggregationContext, parent, this.values, this.numberOfSignificantValueDigits, this.keyed, this.config.formatter(), pipelineAggregators, metaData);
        }

        @Override
        protected Aggregator doCreateInternal(ValuesSource.Numeric valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new HDRPercentileRanksAggregator(this.name, valuesSource, aggregationContext, parent, this.values, this.numberOfSignificantValueDigits, this.keyed, this.config.formatter(), pipelineAggregators, metaData);
        }
    }
}

