/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.derivative;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorBuilder;
import org.elasticsearch.search.aggregations.pipeline.derivative.DerivativeParser;
import org.elasticsearch.search.aggregations.pipeline.derivative.DerivativePipelineAggregator;

public class DerivativeBuilder
extends PipelineAggregatorBuilder<DerivativeBuilder> {
    private String format;
    private BucketHelpers.GapPolicy gapPolicy;
    private String unit;

    public DerivativeBuilder(String name) {
        super(name, DerivativePipelineAggregator.TYPE.name());
    }

    public DerivativeBuilder format(String format) {
        this.format = format;
        return this;
    }

    public DerivativeBuilder gapPolicy(BucketHelpers.GapPolicy gapPolicy) {
        this.gapPolicy = gapPolicy;
        return this;
    }

    public DerivativeBuilder unit(String unit) {
        this.unit = unit;
        return this;
    }

    public DerivativeBuilder unit(DateHistogramInterval unit) {
        this.unit = unit.toString();
        return this;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(DerivativeParser.FORMAT.getPreferredName(), this.format);
        }
        if (this.gapPolicy != null) {
            builder.field(DerivativeParser.GAP_POLICY.getPreferredName(), this.gapPolicy.getName());
        }
        if (this.unit != null) {
            builder.field(DerivativeParser.UNIT.getPreferredName(), this.unit);
        }
        return builder;
    }
}

