/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.FromXContentBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;

public class Snapshot
implements Comparable<Snapshot>,
ToXContent,
FromXContentBuilder<Snapshot> {
    private final String name;
    private final Version version;
    private final SnapshotState state;
    private final String reason;
    private final List<String> indices;
    private final long startTime;
    private final long endTime;
    private final int totalShard;
    private final int successfulShards;
    private final List<SnapshotShardFailure> shardFailures;
    private static final List<SnapshotShardFailure> NO_FAILURES = Collections.emptyList();
    public static final Snapshot PROTO = new Snapshot();

    private Snapshot(String name, List<String> indices, SnapshotState state, String reason, Version version, long startTime, long endTime, int totalShard, int successfulShards, List<SnapshotShardFailure> shardFailures) {
        assert (name != null);
        assert (indices != null);
        assert (state != null);
        assert (shardFailures != null);
        this.name = name;
        this.indices = indices;
        this.state = state;
        this.reason = reason;
        this.version = version;
        this.startTime = startTime;
        this.endTime = endTime;
        this.totalShard = totalShard;
        this.successfulShards = successfulShards;
        this.shardFailures = shardFailures;
    }

    public Snapshot(String name, List<String> indices, long startTime) {
        this(name, indices, SnapshotState.IN_PROGRESS, null, Version.CURRENT, startTime, 0L, 0, 0, NO_FAILURES);
    }

    public Snapshot(String name, List<String> indices, long startTime, String reason, long endTime, int totalShard, List<SnapshotShardFailure> shardFailures) {
        this(name, indices, Snapshot.snapshotState(reason, shardFailures), reason, Version.CURRENT, startTime, endTime, totalShard, totalShard - shardFailures.size(), shardFailures);
    }

    private Snapshot() {
        this("", Collections.EMPTY_LIST, 0L);
    }

    private static SnapshotState snapshotState(String reason, List<SnapshotShardFailure> shardFailures) {
        if (reason == null) {
            if (shardFailures.isEmpty()) {
                return SnapshotState.SUCCESS;
            }
            return SnapshotState.PARTIAL;
        }
        return SnapshotState.FAILED;
    }

    public String name() {
        return this.name;
    }

    public SnapshotState state() {
        return this.state;
    }

    public String reason() {
        return this.reason;
    }

    public Version version() {
        return this.version;
    }

    public List<String> indices() {
        return this.indices;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public int totalShard() {
        return this.totalShard;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public List<SnapshotShardFailure> shardFailures() {
        return this.shardFailures;
    }

    @Override
    public int compareTo(Snapshot o) {
        return Long.compare(this.startTime, o.startTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Snapshot that = (Snapshot)o;
        if (this.startTime != that.startTime) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        return result;
    }

    @Override
    public Snapshot fromXContent(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return Snapshot.fromXContent(parser);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.SNAPSHOT);
        builder.field(Fields.NAME, this.name);
        builder.field(Fields.VERSION_ID, this.version.id);
        builder.startArray(Fields.INDICES);
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        builder.field(Fields.STATE, (Object)this.state);
        if (this.reason != null) {
            builder.field(Fields.REASON, this.reason);
        }
        builder.field(Fields.START_TIME, this.startTime);
        builder.field(Fields.END_TIME, this.endTime);
        builder.field(Fields.TOTAL_SHARDS, this.totalShard);
        builder.field(Fields.SUCCESSFUL_SHARDS, this.successfulShards);
        builder.startArray(Fields.FAILURES);
        for (SnapshotShardFailure shardFailure : this.shardFailures) {
            builder.startObject();
            shardFailure.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static Snapshot fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String name = null;
        Version version = Version.CURRENT;
        SnapshotState state = SnapshotState.IN_PROGRESS;
        String reason = null;
        List<String> indices = Collections.emptyList();
        long startTime = 0L;
        long endTime = 0L;
        int totalShard = 0;
        int successfulShards = 0;
        List<SnapshotShardFailure> shardFailures = NO_FAILURES;
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        if ((token = parser.nextToken()) == XContentParser.Token.START_OBJECT) {
            String currentFieldName = parser.currentName();
            if ("snapshot".equals(currentFieldName)) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (token.isValue()) {
                        if ("name".equals(currentFieldName)) {
                            name = parser.text();
                            continue;
                        }
                        if ("state".equals(currentFieldName)) {
                            state = SnapshotState.valueOf(parser.text());
                            continue;
                        }
                        if ("reason".equals(currentFieldName)) {
                            reason = parser.text();
                            continue;
                        }
                        if ("start_time".equals(currentFieldName)) {
                            startTime = parser.longValue();
                            continue;
                        }
                        if ("end_time".equals(currentFieldName)) {
                            endTime = parser.longValue();
                            continue;
                        }
                        if ("total_shards".equals(currentFieldName)) {
                            totalShard = parser.intValue();
                            continue;
                        }
                        if ("successful_shards".equals(currentFieldName)) {
                            successfulShards = parser.intValue();
                            continue;
                        }
                        if (!"version_id".equals(currentFieldName)) continue;
                        version = Version.fromId(parser.intValue());
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if ("indices".equals(currentFieldName)) {
                            ArrayList<String> indicesArray = new ArrayList<String>();
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                indicesArray.add(parser.text());
                            }
                            indices = Collections.unmodifiableList(indicesArray);
                            continue;
                        }
                        if ("failures".equals(currentFieldName)) {
                            ArrayList<SnapshotShardFailure> shardFailureArrayList = new ArrayList<SnapshotShardFailure>();
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                shardFailureArrayList.add(SnapshotShardFailure.fromXContent(parser));
                            }
                            shardFailures = Collections.unmodifiableList(shardFailureArrayList);
                            continue;
                        }
                        parser.skipChildren();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT) continue;
                    parser.skipChildren();
                }
            }
        } else {
            throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]", new Object[0]);
        }
        return new Snapshot(name, indices, state, reason, version, startTime, endTime, totalShard, successfulShards, shardFailures);
    }

    static final class Fields {
        static final XContentBuilderString SNAPSHOT = new XContentBuilderString("snapshot");
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString VERSION_ID = new XContentBuilderString("version_id");
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString STATE = new XContentBuilderString("state");
        static final XContentBuilderString REASON = new XContentBuilderString("reason");
        static final XContentBuilderString START_TIME = new XContentBuilderString("start_time");
        static final XContentBuilderString END_TIME = new XContentBuilderString("end_time");
        static final XContentBuilderString TOTAL_SHARDS = new XContentBuilderString("total_shards");
        static final XContentBuilderString SUCCESSFUL_SHARDS = new XContentBuilderString("successful_shards");
        static final XContentBuilderString FAILURES = new XContentBuilderString("failures");

        Fields() {
        }
    }
}

