/*
 * Decompiled with CFR 0.152.
 */
package com.wjj.datax.es.writer;

import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.wjj.datax.es.common.ElasticsearchErrorCode;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESImport {
    private static Logger logger = LoggerFactory.getLogger(ESImport.class);
    private BulkProcessor bulkProcessor;
    private String index;
    private String type;
    private String idFieldName;
    private Client client = null;
    private int bulkNum = 5000;
    private List<String> failureList = new LinkedList<String>();
    private int flushInterval = 10;
    private int bulkSize = 5;
    private int concurrent = 1;
    private boolean refresh = false;

    public ESImport(Client client, String index, String type) {
        this.client = client;
        this.index = index;
        this.type = type;
    }

    public ESImport(Client client, String index, String type, int bulkNum) {
        this.client = client;
        this.index = index;
        this.type = type;
        this.bulkNum = bulkNum;
    }

    public ESImport(Client client, String index, String type, String idFieldName) {
        this.client = client;
        this.index = index;
        this.type = type;
        this.idFieldName = idFieldName;
    }

    public ESImport(Client client, String index, String type, String idFieldName, int bulkNum) {
        this.client = client;
        this.index = index;
        this.type = type;
        this.idFieldName = idFieldName;
        this.bulkNum = bulkNum;
    }

    public ESImport build() {
        if (StringUtils.isBlank((CharSequence)this.index) || StringUtils.isBlank((CharSequence)this.type)) {
            throw DataXException.asDataXException((ErrorCode)ElasticsearchErrorCode.INDEX_OR_TYPE_EMPTY_ERROR, (String)"");
        }
        BulkProcessor.Builder bulkBuilder = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)new BulkProcessorListenr());
        bulkBuilder.setBulkActions(this.bulkNum).setFlushInterval(TimeValue.timeValueSeconds((long)this.flushInterval)).setBulkSize(new ByteSizeValue((long)this.bulkSize, ByteSizeUnit.MB)).setConcurrentRequests(this.concurrent);
        this.bulkProcessor = bulkBuilder.build();
        return this;
    }

    public ESImport setBulkSize(int bulkSize) {
        this.bulkSize = bulkSize;
        return this;
    }

    public ESImport setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
        return this;
    }

    public ESImport setBulkNum(int bulkNum) {
        this.bulkNum = bulkNum;
        return this;
    }

    public ESImport setConcurrent(int concurrent) {
        this.concurrent = concurrent;
        return this;
    }

    public ESImport setRefresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public void awaitClose(int awaitMinutes) {
        try {
            if (awaitMinutes <= 0) {
                this.bulkProcessor.close();
            } else {
                this.bulkProcessor.awaitClose((long)awaitMinutes, TimeUnit.MINUTES);
            }
        }
        catch (InterruptedException e) {
            logger.error("\u5173\u95edbulkProcessor\u51fa\u9519", (Throwable)e);
        }
    }

    public List<String> getFailureList() {
        return this.failureList;
    }

    public void add(List<Map<String, Object>> dataList) {
        for (Map<String, Object> data : dataList) {
            this.add(data);
        }
    }

    public void add(Map<String, Object> data) {
        if (this.bulkProcessor == null) {
            throw new RuntimeException("\u672a\u6784\u5efa\u6279\u5904\u7406\u5668\uff0c\u8bf7\u8c03\u7528build()\u65b9\u6cd5\u6784\u5efa");
        }
        if (StringUtils.isBlank((CharSequence)this.idFieldName)) {
            IndexRequestBuilder builder = this.client.prepareIndex(this.index, this.type).setSource(data);
            this.bulkProcessor.add((IndexRequest)builder.request());
        } else {
            String esId = (String)data.get(this.idFieldName);
            if (StringUtils.isBlank((CharSequence)esId)) {
                this.failureList.add(esId);
            } else {
                if (StringUtils.equals((CharSequence)"_id", (CharSequence)this.idFieldName)) {
                    data.remove("_id");
                }
                UpdateRequestBuilder builder = this.client.prepareUpdate(this.index, this.type, esId).setDocAsUpsert(true).setDoc(data);
                this.bulkProcessor.add(builder.request());
            }
        }
    }

    private class BulkProcessorListenr
    implements BulkProcessor.Listener {
        private BulkProcessorListenr() {
        }

        public void beforeBulk(long executionId, BulkRequest request) {
            request.refresh(ESImport.this.refresh);
            int importSize = request.numberOfActions();
            logger.debug("\u6279\u6b21\u53f7\uff1a{}\uff0c\u5f00\u59cb\u5bfc\u5165{}\u6761\u6570\u636e", (Object)executionId, (Object)importSize);
        }

        public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            int importSize = request.numberOfActions();
            boolean hasFailure = response.hasFailures();
            int failureCount = 0;
            for (BulkItemResponse res : response.getItems()) {
                if (!res.isFailed()) continue;
                ++failureCount;
                String id = res.getId();
                ESImport.this.failureList.add(id);
                logger.error("\u5bfc\u5165\u5931\u8d25\uff0cid:" + id, res.getFailure().getCause());
            }
            logger.debug("\u6279\u6b21\u53f7\uff1a{}\uff0c\u5bfc\u5165{}\u6761\u6570\u636e\u6210\u529f\uff0c{}\u6761\u6570\u636e\u5931\u8d25\uff0c\u8017\u65f6\uff1a{}ms", new Object[]{executionId, importSize - failureCount, failureCount, response.getTookInMillis()});
        }

        public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
            logger.error("\u6279\u6b21\u53f7\uff1a" + executionId + "\uff0c\u53d1\u751f\u5f02\u5e38\uff0c\u5bfc\u5165\u6570\u636e\u5931\u8d25", failure);
        }
    }
}

