/*
 * Decompiled with CFR 0.152.
 */
package com.wjj.datax.es.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESClient {
    private static Client client;
    private static Logger logger;

    private static Client createClient(List<String> urls) {
        TransportClient transportClient = null;
        Settings settings = Settings.builder().put("client.transport.ignore_cluster_name", true).build();
        try {
            transportClient = TransportClient.builder().settings(settings).build();
            for (String hostAndPort : urls) {
                String host = hostAndPort.split(":")[0];
                String port = hostAndPort.split(":")[1];
                transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(host), Integer.parseInt(port)));
            }
        }
        catch (UnknownHostException e) {
            logger.error("", (Throwable)e);
        }
        return transportClient;
    }

    public static Client getNewClient(List<String> urls) {
        return ESClient.createClient(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Client getSingleClient(List<String> urls) {
        if (client != null) return client;
        Class<ESClient> clazz = ESClient.class;
        synchronized (ESClient.class) {
            Client temp = client = ESClient.createClient(urls);
            if (temp != null) return client;
            Class<ESClient> clazz2 = ESClient.class;
            synchronized (ESClient.class) {
                temp = ESClient.createClient(urls);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                client = temp;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return client;
            }
        }
    }

    static {
        logger = LoggerFactory.getLogger(ESClient.class);
    }
}

