/*
 * Decompiled with CFR 0.152.
 */
package com.wjj.datax.es.writer;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.plugin.RecordReceiver;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.spi.Writer;
import com.alibaba.datax.common.util.Configuration;
import com.wjj.datax.es.common.ESClient;
import com.wjj.datax.es.common.ElasticsearchErrorCode;
import com.wjj.datax.es.writer.ESImport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchWriter
extends Writer {

    public static class Task
    extends Writer.Task {
        private static Logger logger = LoggerFactory.getLogger(Task.class);
        public static volatile ESImport esImport;
        private Configuration configuration = null;
        public String index = "";
        public String type = "";
        public String idField = "";
        public List<String> column = null;
        public List connection = null;
        public int concurrent = 1;
        public int bulkNum = 1000;
        public boolean refresh = false;

        public void init() {
            logger.info("=================elasticsearch writer task init======================");
            this.configuration = super.getPluginJobConf();
            this.index = this.configuration.getString("index");
            this.type = this.configuration.getString("type");
            this.idField = this.configuration.getString("idField", "").trim();
            this.column = this.configuration.getList("column", String.class);
            this.connection = this.configuration.getList("connection");
            this.concurrent = this.configuration.getInt("concurrent", this.concurrent);
            this.bulkNum = this.configuration.getInt("bulkNum", this.bulkNum);
            this.refresh = this.configuration.getBool("refresh", false);
            Task.initESImport(this);
        }

        private static synchronized void initESImport(Task task) {
            if (esImport == null) {
                esImport = new ESImport(ESClient.getNewClient(task.connection), task.index, task.type, task.idField).setBulkNum(task.bulkNum).setConcurrent(task.concurrent).setRefresh(task.refresh).build();
            }
        }

        public void startWrite(RecordReceiver recordReceiver) {
            logger.info("=================elasticsearch writer task start write======================");
            Record record = null;
            while (true) {
                if ((record = recordReceiver.getFromReader()) == null) {
                    logger.info("=================elasticsearch writer task end write======================");
                    recordReceiver.shutdown();
                    return;
                }
                if (this.column.size() > record.getColumnNumber()) {
                    throw DataXException.asDataXException((ErrorCode)ElasticsearchErrorCode.COLUMN_COUNT_ERROR, (String)"");
                }
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (int i = 0; i < this.column.size(); ++i) {
                    Column readColumn = record.getColumn(i);
                    if (readColumn == null) continue;
                    data.put(this.column.get(i), readColumn.getRawData());
                }
                esImport.add(data);
            }
        }

        public void destroy() {
            logger.info("======elasticsearch writer task destroy==============");
        }
    }

    public static class Job
    extends Writer.Job {
        private static Logger logger = LoggerFactory.getLogger(Job.class);
        private Configuration configuration = null;

        public void init() {
            logger.info("=================elasticsearch writer job init======================");
            this.configuration = this.getPluginJobConf();
        }

        public List<Configuration> split(int adviceNumber) {
            ArrayList<Configuration> configs = new ArrayList<Configuration>();
            for (int i = 0; i < adviceNumber; ++i) {
                this.configuration.set("concurrent", (Object)adviceNumber);
                configs.add(this.configuration);
            }
            return configs;
        }

        public void destroy() {
            Task.esImport.awaitClose(5);
            logger.info("============elasticsearch writer job destroy=================");
        }
    }
}

