/*
 * Decompiled with CFR 0.152.
 */
package com.wjj.datax.es.reader;

import com.alibaba.datax.common.element.BoolColumn;
import com.alibaba.datax.common.element.BytesColumn;
import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.element.DateColumn;
import com.alibaba.datax.common.element.DoubleColumn;
import com.alibaba.datax.common.element.LongColumn;
import com.alibaba.datax.common.element.StringColumn;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.plugin.RecordSender;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.spi.Reader;
import com.alibaba.datax.common.util.Configuration;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.wjj.datax.es.common.ESClient;
import com.wjj.datax.es.common.ElasticsearchErrorCode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchReader
extends Reader {

    public static class Task
    extends Reader.Task {
        private static Logger logger = LoggerFactory.getLogger(Task.class);
        private Client client;
        private Configuration configuration = null;
        private String index = "";
        private String type = "";
        private List<String> column = null;
        private String scrollId;
        private TimeValue keepAlive = TimeValue.timeValueMinutes((long)3L);
        private int pageSize = 100;
        private String shards;

        public void init() {
            logger.info("=================elasticsearch reader task init======================");
            this.configuration = super.getPluginJobConf();
            this.index = this.configuration.getString("index");
            this.type = this.configuration.getString("type");
            this.column = this.configuration.getList("column", String.class);
            this.pageSize = this.configuration.getInt("pageSize", this.pageSize);
            List connection = this.configuration.getList("connection");
            this.shards = this.configuration.getString("shards");
            this.client = ESClient.getNewClient(connection);
        }

        /*
         * Exception decompiling
         */
        public void startRead(RecordSender recordSender) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 1[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void destroy() {
            logger.info("======elasticsearch reader task destroy==============");
            if (StringUtils.isNotBlank((CharSequence)this.scrollId)) {
                this.client.prepareClearScroll().addScrollId(this.scrollId).execute().actionGet();
            }
            this.client.close();
        }

        private Column getColumn(String _id, String key, Object value) {
            if (value == null) {
                return null;
            }
            LongColumn col = null;
            if (value instanceof Long) {
                col = new LongColumn((Long)value);
            } else if (value instanceof Integer) {
                col = new LongColumn(Long.valueOf(((Integer)value).longValue()));
            } else if (value instanceof Byte) {
                col = new LongColumn(Long.valueOf(((Byte)value).longValue()));
            } else if (value instanceof Short) {
                col = new LongColumn(Long.valueOf(((Short)value).longValue()));
            } else if (value instanceof String) {
                col = new StringColumn((String)value);
            } else if (value instanceof Double) {
                col = new DoubleColumn((Double)value);
            } else if (value instanceof Float) {
                col = new DoubleColumn(Double.valueOf(((Float)value).doubleValue()));
            } else if (value instanceof Date) {
                col = new DateColumn((Date)value);
            } else if (value instanceof Boolean) {
                col = new BoolColumn((Boolean)value);
            } else if (value instanceof byte[]) {
                col = new BytesColumn((byte[])value);
            } else {
                throw DataXException.asDataXException((ErrorCode)ElasticsearchErrorCode.UNKNOWN_DATA_TYPE, (String)("\u53d1\u751f\u5728_id:" + _id + ",key:" + key));
            }
            return col;
        }
    }

    public static class Job
    extends Reader.Job {
        private static Logger logger = LoggerFactory.getLogger(Job.class);
        private Configuration configuration = null;
        private Client client;
        private String index = "";
        private String type = "";
        private int shardsNumber = 1;

        public void init() {
            logger.info("=================elasticsearch reader job init======================");
            this.configuration = this.getPluginJobConf();
            this.index = this.configuration.getString("index");
            this.type = this.configuration.getString("type");
            List connection = this.configuration.getList("connection");
            this.client = ESClient.getNewClient(connection);
            GetSettingsResponse response = (GetSettingsResponse)this.client.admin().indices().prepareGetSettings(new String[]{this.index}).get();
            for (ObjectObjectCursor cursor : response.getIndexToSettings()) {
                String index = (String)cursor.key;
                Settings settings = (Settings)cursor.value;
                Integer shards = settings.getAsInt("index.number_of_shards", null);
                if (!StringUtils.equals((CharSequence)index, (CharSequence)this.index)) continue;
                this.shardsNumber = shards;
            }
            this.client.close();
        }

        public List<Configuration> split(int adviceNumber) {
            int taskNum = adviceNumber;
            if (this.shardsNumber <= taskNum) {
                taskNum = this.shardsNumber;
            }
            int[] shardsCode = new int[this.shardsNumber];
            for (int i = 0; i < this.shardsNumber; ++i) {
                shardsCode[i] = i;
            }
            int shardNumPerTask = (int)Math.round((double)this.shardsNumber / (double)taskNum);
            ArrayList<Configuration> configs = new ArrayList<Configuration>();
            for (int i = 0; i < taskNum; ++i) {
                int start = i * shardNumPerTask;
                int end = start + shardNumPerTask;
                if (end > shardsCode.length || i == taskNum - 1 && end < shardsCode.length) {
                    end = shardsCode.length;
                }
                int[] shardsArr = ArrayUtils.subarray((int[])shardsCode, (int)start, (int)end);
                Configuration shardConfig = this.configuration.clone();
                shardConfig.set("shards", (Object)StringUtils.join((int[])shardsArr, (char)",".charAt(0)));
                configs.add(shardConfig);
            }
            return configs;
        }

        public void destroy() {
            logger.info("============elasticsearch reader job destroy=================");
        }
    }
}

