/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.element;

import com.alibaba.datax.common.element.Column;
import com.alibaba.datax.common.exception.CommonErrorCode;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

public class BoolColumn
extends Column {
    public BoolColumn(Boolean bool) {
        super(bool, Column.Type.BOOL, 1);
    }

    public BoolColumn(String data) {
        this(true);
        this.validate(data);
        if (null == data) {
            this.setRawData(null);
            this.setByteSize(0);
        } else {
            this.setRawData(Boolean.valueOf(data));
            this.setByteSize(1);
        }
    }

    public BoolColumn() {
        super(null, Column.Type.BOOL, 1);
    }

    @Override
    public Boolean asBoolean() {
        if (null == super.getRawData()) {
            return null;
        }
        return (Boolean)super.getRawData();
    }

    @Override
    public Long asLong() {
        if (null == this.getRawData()) {
            return null;
        }
        return this.asBoolean() != false ? 1L : 0L;
    }

    @Override
    public Double asDouble() {
        if (null == this.getRawData()) {
            return null;
        }
        return this.asBoolean() != false ? 1.0 : 0.0;
    }

    @Override
    public String asString() {
        if (null == super.getRawData()) {
            return null;
        }
        return this.asBoolean() != false ? "true" : "false";
    }

    @Override
    public BigInteger asBigInteger() {
        if (null == this.getRawData()) {
            return null;
        }
        return BigInteger.valueOf(this.asLong());
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (null == this.getRawData()) {
            return null;
        }
        return BigDecimal.valueOf(this.asLong());
    }

    @Override
    public Date asDate() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bool\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aDate .");
    }

    @Override
    public byte[] asBytes() {
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Boolean\u7c7b\u578b\u4e0d\u80fd\u8f6c\u4e3aBytes .");
    }

    private void validate(String data) {
        if (null == data) {
            return;
        }
        if ("true".equalsIgnoreCase(data) || "false".equalsIgnoreCase(data)) {
            return;
        }
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[%s]\u4e0d\u80fd\u8f6c\u4e3aBool .", data));
    }
}

