/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.util;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostUtils {
    public static final String IP;
    public static final String HOSTNAME;
    private static final Logger log;

    static {
        String hostname;
        String ip;
        log = LoggerFactory.getLogger(HostUtils.class);
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ip = addr.getHostAddress();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException e) {
            log.error("Can't find out address: " + e.getMessage());
            ip = "UNKNOWN";
            hostname = "UNKNOWN";
        }
        if (ip.equals("127.0.0.1") || ip.equals("::1") || ip.equals("UNKNOWN")) {
            try {
                Process process = Runtime.getRuntime().exec("hostname -i");
                if (process.waitFor() == 0) {
                    ip = new String(IOUtils.toByteArray((InputStream)process.getInputStream()), "UTF8");
                }
                if ((process = Runtime.getRuntime().exec("hostname")).waitFor() == 0) {
                    hostname = new String(IOUtils.toByteArray((InputStream)process.getInputStream()), "UTF8").trim();
                }
            }
            catch (Exception e) {
                log.warn("get hostname failed {}", (Object)e.getMessage());
            }
        }
        IP = ip;
        HOSTNAME = hostname;
        log.info("IP {} HOSTNAME {}", (Object)IP, (Object)HOSTNAME);
    }
}

