/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.threadpool.ThreadPool;

class SearchCountAsyncAction
extends AbstractSearchAsyncAction<QuerySearchResultProvider> {
    SearchCountAsyncAction(ESLogger logger, SearchServiceTransportAction searchService, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, SearchPhaseController searchPhaseController, ThreadPool threadPool, SearchRequest request, ActionListener<SearchResponse> listener) {
        super(logger, searchService, clusterService, indexNameExpressionResolver, searchPhaseController, threadPool, request, listener);
    }

    @Override
    protected String firstPhaseName() {
        return "query";
    }

    @Override
    protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchTransportRequest request, ActionListener<QuerySearchResultProvider> listener) {
        this.searchService.sendExecuteQuery(node, request, listener);
    }

    @Override
    protected void moveToSecondPhase() throws Exception {
        InternalSearchResponse internalResponse = this.searchPhaseController.merge(SearchPhaseController.EMPTY_DOCS, this.firstResults, (AtomicArray)AtomicArray.empty(), this.request);
        String scrollId = null;
        if (this.request.scroll() != null) {
            scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)this.firstResults, null);
        }
        this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successfulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
    }
}

