/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.net.SocketPermission;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Map;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.bootstrap.Security;
import org.elasticsearch.common.SuppressForbidden;

final class ESPolicy
extends Policy {
    static final String POLICY_RESOURCE = "security.policy";
    static final String UNTRUSTED_RESOURCE = "untrusted.policy";
    final Policy template = Security.readPolicy(this.getClass().getResource("security.policy"), JarHell.parseClassPath());
    final Policy untrusted = Security.readPolicy(this.getClass().getResource("untrusted.policy"), new URL[0]);
    final Policy system;
    final PermissionCollection dynamic;
    final Map<String, Policy> plugins;
    private static Predicate<Permission> SOCKET_LISTEN_PERMISION_PREDICATE = new Predicate<Permission>(){

        public boolean apply(Permission permission) {
            return permission instanceof SocketPermission && permission.getActions().contains("listen");
        }
    };
    private static final Permission BAD_DEFAULT_NUMBER_ONE = new BadDefaultPermission(new RuntimePermission("stopThread"), (Predicate<Permission>)Predicates.alwaysTrue());
    private static final Permission BAD_DEFAULT_NUMBER_TWO = new BadDefaultPermission(new SocketPermission("localhost:0", "listen"), SOCKET_LISTEN_PERMISION_PREDICATE);
    private static final Permission BAD_DEFAULT_NUMBER_THREE = new BadDefaultPermission(new SocketPermission("localhost:1024-", "listen"), SOCKET_LISTEN_PERMISION_PREDICATE);
    private static final Permission BAD_DEFAULT_NUMBER_FOUR = new BadDefaultPermission(new SocketPermission("localhost:1099", "listen"), SOCKET_LISTEN_PERMISION_PREDICATE);

    public ESPolicy(PermissionCollection dynamic, Map<String, Policy> plugins, boolean filterBadDefaults) {
        this.system = filterBadDefaults ? new SystemPolicy(Policy.getPolicy()) : Policy.getPolicy();
        this.dynamic = dynamic;
        this.plugins = plugins;
    }

    @Override
    @SuppressForbidden(reason="fast equals check is desired")
    public boolean implies(ProtectionDomain domain, Permission permission) {
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource == null) {
            return false;
        }
        URL location = codeSource.getLocation();
        if (location != null) {
            if ("/untrusted".equals(location.getFile())) {
                return this.untrusted.implies(domain, permission);
            }
            Policy plugin = this.plugins.get(location.getFile());
            if (plugin != null && plugin.implies(domain, permission)) {
                return true;
            }
        }
        return this.template.implies(domain, permission) || this.dynamic.implies(permission) || this.system.implies(domain, permission);
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!"sun.rmi.server.LoaderHandler".equals(element.getClassName()) || !"loadClass".equals(element.getMethodName())) continue;
            return new Permissions();
        }
        return super.getPermissions(codesource);
    }

    static class SystemPolicy
    extends Policy {
        final Policy delegate;

        SystemPolicy(Policy delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean implies(ProtectionDomain domain, Permission permission) {
            if (BAD_DEFAULT_NUMBER_ONE.implies(permission) || BAD_DEFAULT_NUMBER_TWO.implies(permission) || BAD_DEFAULT_NUMBER_THREE.implies(permission) || BAD_DEFAULT_NUMBER_FOUR.implies(permission)) {
                return false;
            }
            return this.delegate.implies(domain, permission);
        }
    }

    private static class BadDefaultPermission
    extends Permission {
        private final Permission badDefaultPermission;
        private final Predicate<Permission> preImplies;

        public BadDefaultPermission(Permission badDefaultPermission, Predicate<Permission> preImplies) {
            super(badDefaultPermission.getName());
            this.badDefaultPermission = badDefaultPermission;
            this.preImplies = preImplies;
        }

        @Override
        public final boolean implies(Permission permission) {
            return this.preImplies.apply((Object)permission) && this.badDefaultPermission.implies(permission);
        }

        @Override
        public final boolean equals(Object obj) {
            return this.badDefaultPermission.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.badDefaultPermission.hashCode();
        }

        @Override
        public String getActions() {
            return this.badDefaultPermission.getActions();
        }
    }
}

