/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lease;

import java.util.Arrays;
import org.elasticsearch.common.lease.Releasable;

public enum Releasables {


    private static void rethrow(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    private static void close(Iterable<? extends Releasable> releasables, boolean ignoreException) {
        Throwable th = null;
        for (Releasable releasable : releasables) {
            if (releasable == null) continue;
            try {
                releasable.close();
            }
            catch (Throwable t) {
                if (th != null) continue;
                th = t;
            }
        }
        if (th != null && !ignoreException) {
            Releasables.rethrow(th);
        }
    }

    public static void close(Iterable<? extends Releasable> releasables) {
        Releasables.close(releasables, false);
    }

    public static void close(Releasable ... releasables) {
        Releasables.close(Arrays.asList(releasables));
    }

    public static void closeWhileHandlingException(Iterable<Releasable> releasables) {
        Releasables.close(releasables, true);
    }

    public static void closeWhileHandlingException(Releasable ... releasables) {
        Releasables.closeWhileHandlingException(Arrays.asList(releasables));
    }

    public static void close(boolean success, Iterable<Releasable> releasables) {
        if (success) {
            Releasables.close(releasables);
        } else {
            Releasables.closeWhileHandlingException(releasables);
        }
    }

    public static void close(boolean success, Releasable ... releasables) {
        Releasables.close(success, Arrays.asList(releasables));
    }

    public static Releasable wrap(final Iterable<Releasable> releasables) {
        return new Releasable(){

            @Override
            public void close() {
                Releasables.close(releasables);
            }
        };
    }

    public static Releasable wrap(final Releasable ... releasables) {
        return new Releasable(){

            @Override
            public void close() {
                Releasables.close(releasables);
            }
        };
    }
}

