/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.support.QueryInnerHitBuilder;

public class NestedQueryBuilder
extends QueryBuilder
implements BoostableQueryBuilder<NestedQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private final String path;
    private String scoreMode;
    private float boost = 1.0f;
    private String queryName;
    private QueryInnerHitBuilder innerHit;

    public NestedQueryBuilder(String path, QueryBuilder queryBuilder) {
        this.path = path;
        this.queryBuilder = Objects.requireNonNull(queryBuilder);
    }

    public NestedQueryBuilder scoreMode(String scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    @Override
    public NestedQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public NestedQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public NestedQueryBuilder innerHit(QueryInnerHitBuilder innerHit) {
        this.innerHit = innerHit;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nested");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("path", this.path);
        if (this.scoreMode != null) {
            builder.field("score_mode", this.scoreMode);
        }
        if (this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        if (this.innerHit != null) {
            builder.startObject("inner_hits");
            builder.value(this.innerHit);
            builder.endObject();
        }
        builder.endObject();
    }
}

