/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.NXYSignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;
import org.elasticsearch.search.internal.SearchContext;

public class GND
extends NXYSignificanceHeuristic {
    protected static final ParseField NAMES_FIELD = new ParseField("gnd", new String[0]);
    public static final SignificanceHeuristicStreams.Stream STREAM = new SignificanceHeuristicStreams.Stream(){

        @Override
        public SignificanceHeuristic readResult(StreamInput in) throws IOException {
            return new GND(in.readBoolean());
        }

        @Override
        public String getName() {
            return NAMES_FIELD.getPreferredName();
        }
    };

    public GND(boolean backgroundIsSuperset) {
        super(true, backgroundIsSuperset);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GND)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int result = NAMES_FIELD.getPreferredName().hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        NXYSignificanceHeuristic.Frequencies frequencies = this.computeNxys(subsetFreq, subsetSize, supersetFreq, supersetSize, "GND");
        double fx = frequencies.N1_;
        double fy = frequencies.N_1;
        double fxy = frequencies.N11;
        double N = frequencies.N;
        if (fxy == 0.0) {
            return 0.0;
        }
        if (fx == fy && fx == fxy) {
            return 1.0;
        }
        double score = (Math.max(Math.log(fx), Math.log(fy)) - Math.log(fxy)) / (Math.log(N) - Math.min(Math.log(fx), Math.log(fy)));
        score = Math.exp(-1.0 * score);
        return score;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(STREAM.getName());
        out.writeBoolean(this.backgroundIsSuperset);
    }

    public static class GNDBuilder
    extends NXYSignificanceHeuristic.NXYBuilder {
        public GNDBuilder(boolean backgroundIsSuperset) {
            super(true, backgroundIsSuperset);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(STREAM.getName());
            builder.field(NXYSignificanceHeuristic.BACKGROUND_IS_SUPERSET.getPreferredName(), this.backgroundIsSuperset);
            builder.endObject();
            return builder;
        }
    }

    public static class GNDParser
    extends NXYSignificanceHeuristic.NXYParser {
        @Override
        public String[] getNames() {
            return NAMES_FIELD.getAllNamesIncludedDeprecated();
        }

        @Override
        protected SignificanceHeuristic newHeuristic(boolean includeNegatives, boolean backgroundIsSuperset) {
            return new GND(backgroundIsSuperset);
        }

        @Override
        public SignificanceHeuristic parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher, SearchContext context) throws IOException, QueryParsingException {
            String givenName = parser.currentName();
            boolean backgroundIsSuperset = true;
            XContentParser.Token token = parser.nextToken();
            while (!token.equals((Object)XContentParser.Token.END_OBJECT)) {
                if (!parseFieldMatcher.match(parser.currentName(), NXYSignificanceHeuristic.BACKGROUND_IS_SUPERSET)) {
                    throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. unknown field [{}]", givenName, parser.currentName());
                }
                parser.nextToken();
                backgroundIsSuperset = parser.booleanValue();
                token = parser.nextToken();
            }
            return this.newHeuristic(true, backgroundIsSuperset);
        }
    }
}

