/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.statistics;

import com.alibaba.datax.common.statistics.PerfRecord;
import com.alibaba.datax.common.util.Configuration;
import com.alibaba.datax.common.util.HostUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfTrace {
    private static Logger LOG = LoggerFactory.getLogger(PerfTrace.class);
    private static PerfTrace instance;
    private static final Object lock;
    private String perfTraceId;
    private volatile boolean enable;
    private volatile boolean isJob;
    private long instId;
    private long jobId;
    private long jobVersion;
    private int taskGroupId;
    private int channelNumber;
    private int priority;
    private int batchSize = 500;
    private volatile boolean perfReportEnable = true;
    private Map<Integer, String> taskDetails = new ConcurrentHashMap<Integer, String>();
    private ConcurrentHashMap<PerfRecord.PHASE, SumPerfRecord4Print> perfRecordMaps4print = new ConcurrentHashMap();
    private SumPerf4Report sumPerf4Report = new SumPerf4Report();
    private SumPerf4Report sumPerf4Report4NotEnd;
    private Configuration jobInfo;
    private final Set<PerfRecord> needReportPool4NotEnd = new HashSet<PerfRecord>();
    private final List<PerfRecord> totalEndReport = new ArrayList<PerfRecord>();
    private String cluster;
    private String jobDomain;
    private String srcType;
    private String dstType;
    private String srcGuid;
    private String dstGuid;
    private Date windowStart;
    private Date windowEnd;
    private Date jobStartTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerfTrace getInstance(boolean isJob, long jobId, int taskGroupId, int priority, boolean enable) {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new PerfTrace(isJob, jobId, taskGroupId, priority, enable);
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PerfTrace getInstance() {
        if (instance == null) {
            LOG.error("PerfTrace instance not be init! must have some error! ");
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new PerfTrace(false, -1111L, -1111, 0, false);
                }
            }
        }
        return instance;
    }

    private PerfTrace(boolean isJob, long jobId, int taskGroupId, int priority, boolean enable) {
        try {
            this.perfTraceId = isJob ? "job_" + jobId : String.format("taskGroup_%s_%s", jobId, taskGroupId);
            this.enable = enable;
            this.isJob = isJob;
            this.taskGroupId = taskGroupId;
            this.instId = jobId;
            this.priority = priority;
            LOG.info(String.format("PerfTrace traceId=%s, isEnable=%s, priority=%s", this.perfTraceId, this.enable, this.priority));
        }
        catch (Exception e) {
            this.enable = false;
        }
    }

    public void addTaskDetails(int taskId, String detail) {
        if (this.enable) {
            String before = "";
            int index = detail.indexOf("?");
            String current = detail.substring(0, index == -1 ? detail.length() : index);
            if (current.indexOf("[") >= 0) {
                current = current + "]";
            }
            if (this.taskDetails.containsKey(taskId)) {
                before = this.taskDetails.get(taskId).trim();
            }
            before = StringUtils.isEmpty((CharSequence)before) ? "" : before + ",";
            this.taskDetails.put(taskId, before + current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tracePerfRecord(PerfRecord perfRecord) {
        block16: {
            try {
                if (!this.enable) break block16;
                long curNanoTime = System.nanoTime();
                switch (perfRecord.getAction()) {
                    case end: {
                        Collection<PerfRecord> collection = this.totalEndReport;
                        synchronized (collection) {
                            this.totalEndReport.add(perfRecord);
                            if (this.totalEndReport.size() > this.batchSize * 10) {
                                this.sumPerf4EndPrint(this.totalEndReport);
                            }
                        }
                        if (!this.perfReportEnable || !this.needReport(perfRecord)) break;
                        collection = this.needReportPool4NotEnd;
                        synchronized (collection) {
                            this.sumPerf4Report.add(curNanoTime, perfRecord);
                            this.needReportPool4NotEnd.remove(perfRecord);
                            break;
                        }
                    }
                    case start: {
                        if (!this.perfReportEnable || !this.needReport(perfRecord)) break;
                        Set<PerfRecord> set = this.needReportPool4NotEnd;
                        synchronized (set) {
                            this.needReportPool4NotEnd.add(perfRecord);
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean needReport(PerfRecord perfRecord) {
        switch (perfRecord.getPhase()) {
            case TASK_TOTAL: 
            case SQL_QUERY: 
            case RESULT_NEXT_ALL: 
            case ODPS_BLOCK_CLOSE: {
                return true;
            }
        }
        return false;
    }

    public String summarizeNoException() {
        String res;
        try {
            res = this.summarize();
        }
        catch (Exception e) {
            res = "PerfTrace summarize has Exception " + e.getMessage();
        }
        return res;
    }

    private synchronized String summarize() {
        if (!this.enable) {
            return "PerfTrace not enable!";
        }
        if (this.totalEndReport.size() > 0) {
            this.sumPerf4EndPrint(this.totalEndReport);
        }
        StringBuilder info = new StringBuilder();
        info.append("\n === total summarize info === \n");
        info.append("\n   1. all phase average time info and max time task info: \n\n");
        info.append(String.format("%-20s | %18s | %18s | %18s | %18s | %-100s\n", "PHASE", "AVERAGE USED TIME", "ALL TASK NUM", "MAX USED TIME", "MAX TASK ID", "MAX TASK INFO"));
        ArrayList keys = new ArrayList(this.perfRecordMaps4print.keySet());
        Collections.sort(keys, new Comparator<PerfRecord.PHASE>(){

            @Override
            public int compare(PerfRecord.PHASE o1, PerfRecord.PHASE o2) {
                return o1.toInt() - o2.toInt();
            }
        });
        for (PerfRecord.PHASE phase : keys) {
            SumPerfRecord4Print sumPerfRecord = this.perfRecordMaps4print.get((Object)phase);
            if (sumPerfRecord == null) continue;
            long averageTime = sumPerfRecord.getAverageTime();
            long maxTime = sumPerfRecord.getMaxTime();
            int maxTaskId = sumPerfRecord.maxTaskId;
            int maxTaskGroupId = sumPerfRecord.getMaxTaskGroupId();
            info.append(String.format("%-20s | %18s | %18s | %18s | %18s | %-100s\n", new Object[]{phase, PerfTrace.unitTime(averageTime), sumPerfRecord.totalCount, PerfTrace.unitTime(maxTime), this.jobId + "-" + maxTaskGroupId + "-" + maxTaskId, this.taskDetails.get(maxTaskId)}));
        }
        SumPerfRecord4Print countSumPerf = this.perfRecordMaps4print.get((Object)PerfRecord.PHASE.READ_TASK_DATA);
        if (countSumPerf == null) {
            countSumPerf = new SumPerfRecord4Print();
        }
        long averageRecords = countSumPerf.getAverageRecords();
        long averageBytes = countSumPerf.getAverageBytes();
        long maxRecord = countSumPerf.getMaxRecord();
        long maxByte = countSumPerf.getMaxByte();
        int maxTaskId4Records = countSumPerf.getMaxTaskId4Records();
        int maxTGID4Records = countSumPerf.getMaxTGID4Records();
        info.append("\n\n 2. record average count and max count task info :\n\n");
        info.append(String.format("%-20s | %18s | %18s | %18s | %18s | %18s | %-100s\n", "PHASE", "AVERAGE RECORDS", "AVERAGE BYTES", "MAX RECORDS", "MAX RECORD`S BYTES", "MAX TASK ID", "MAX TASK INFO"));
        if (maxTaskId4Records > -1) {
            info.append(String.format("%-20s | %18s | %18s | %18s | %18s | %18s | %-100s\n", new Object[]{PerfRecord.PHASE.READ_TASK_DATA, averageRecords, PerfTrace.unitSize(averageBytes), maxRecord, PerfTrace.unitSize(maxByte), this.jobId + "-" + maxTGID4Records + "-" + maxTaskId4Records, this.taskDetails.get(maxTaskId4Records)}));
        }
        return info.toString();
    }

    public static String unitTime(long time) {
        return PerfTrace.unitTime(time, TimeUnit.NANOSECONDS);
    }

    public static String unitTime(long time, TimeUnit timeUnit) {
        return String.format("%,.3fs", Float.valueOf((float)timeUnit.toNanos(time) / 1.0E9f));
    }

    public static String unitSize(long size) {
        if (size > 1000000000L) {
            return String.format("%,.2fG", Float.valueOf((float)size / 1.0E9f));
        }
        if (size > 1000000L) {
            return String.format("%,.2fM", Float.valueOf((float)size / 1000000.0f));
        }
        if (size > 1000L) {
            return String.format("%,.2fK", Float.valueOf((float)size / 1000.0f));
        }
        return size + "B";
    }

    public synchronized ConcurrentHashMap<PerfRecord.PHASE, SumPerfRecord4Print> getPerfRecordMaps4print() {
        if (this.totalEndReport.size() > 0) {
            this.sumPerf4EndPrint(this.totalEndReport);
        }
        return this.perfRecordMaps4print;
    }

    public SumPerf4Report getSumPerf4Report() {
        return this.sumPerf4Report;
    }

    public Set<PerfRecord> getNeedReportPool4NotEnd() {
        return this.needReportPool4NotEnd;
    }

    public List<PerfRecord> getTotalEndReport() {
        return this.totalEndReport;
    }

    public Map<Integer, String> getTaskDetails() {
        return this.taskDetails;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isJob() {
        return this.isJob;
    }

    public void setJobInfo(Configuration jobInfo, boolean perfReportEnable, int channelNumber) {
        try {
            this.jobInfo = jobInfo;
            if (jobInfo != null && perfReportEnable) {
                this.cluster = jobInfo.getString("cluster");
                String srcDomain = jobInfo.getString("srcDomain", "null");
                String dstDomain = jobInfo.getString("dstDomain", "null");
                this.jobDomain = srcDomain + "|" + dstDomain;
                this.srcType = jobInfo.getString("srcType");
                this.dstType = jobInfo.getString("dstType");
                this.srcGuid = jobInfo.getString("srcGuid");
                this.dstGuid = jobInfo.getString("dstGuid");
                this.windowStart = this.getWindow(jobInfo.getString("windowStart"), true);
                this.windowEnd = this.getWindow(jobInfo.getString("windowEnd"), false);
                String jobIdStr = jobInfo.getString("jobId");
                this.jobId = StringUtils.isEmpty((CharSequence)jobIdStr) ? -5L : Long.parseLong(jobIdStr);
                String jobVersionStr = jobInfo.getString("jobVersion");
                this.jobVersion = StringUtils.isEmpty((CharSequence)jobVersionStr) ? -4L : Long.parseLong(jobVersionStr);
                this.jobStartTime = new Date();
            }
            this.perfReportEnable = perfReportEnable;
            this.channelNumber = channelNumber;
        }
        catch (Exception e) {
            this.perfReportEnable = false;
        }
    }

    private Date getWindow(String windowStr, boolean startWindow) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        if (StringUtils.isNotEmpty((CharSequence)windowStr)) {
            try {
                return sdf1.parse(windowStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (startWindow) {
            try {
                return sdf2.parse(sdf2.format(new Date()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public long getInstId() {
        return this.instId;
    }

    public Configuration getJobInfo() {
        return this.jobInfo;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JobStatisticsDto2 getReports(String mode) {
        try {
            if (!this.enable || !this.perfReportEnable) {
                return null;
            }
            if ("job".equalsIgnoreCase(mode) && !this.isJob || "tg".equalsIgnoreCase(mode) && this.isJob) {
                return null;
            }
            this.sumPerf4Report4NotEnd = new SumPerf4Report();
            HashSet<PerfRecord> needReportPool4NotEndTmp = null;
            Set<PerfRecord> set = this.needReportPool4NotEnd;
            synchronized (set) {
                needReportPool4NotEndTmp = new HashSet<PerfRecord>(this.needReportPool4NotEnd);
            }
            long curNanoTime = System.nanoTime();
            for (PerfRecord perfRecord : needReportPool4NotEndTmp) {
                this.sumPerf4Report4NotEnd.add(curNanoTime, perfRecord);
            }
            JobStatisticsDto2 jdo = new JobStatisticsDto2();
            jdo.setInstId(this.instId);
            if (this.isJob) {
                jdo.setTaskGroupId(-6);
            } else {
                jdo.setTaskGroupId(this.taskGroupId);
            }
            jdo.setJobId(this.jobId);
            jdo.setJobVersion(this.jobVersion);
            jdo.setWindowStart(this.windowStart);
            jdo.setWindowEnd(this.windowEnd);
            jdo.setJobStartTime(this.jobStartTime);
            jdo.setJobRunTimeMs(System.currentTimeMillis() - this.jobStartTime.getTime());
            jdo.setJobPriority(this.priority);
            jdo.setChannelNum(this.channelNumber);
            jdo.setCluster(this.cluster);
            jdo.setJobDomain(this.jobDomain);
            jdo.setSrcType(this.srcType);
            jdo.setDstType(this.dstType);
            jdo.setSrcGuid(this.srcGuid);
            jdo.setDstGuid(this.dstGuid);
            jdo.setHostAddress(HostUtils.IP);
            jdo.setTaskTotalTimeMs(this.sumPerf4Report4NotEnd.totalTaskRunTimeInMs + this.sumPerf4Report.totalTaskRunTimeInMs);
            jdo.setOdpsBlockCloseTimeMs(this.sumPerf4Report4NotEnd.odpsCloseTimeInMs + this.sumPerf4Report.odpsCloseTimeInMs);
            jdo.setSqlQueryTimeMs(this.sumPerf4Report4NotEnd.sqlQueryTimeInMs + this.sumPerf4Report.sqlQueryTimeInMs);
            jdo.setResultNextTimeMs(this.sumPerf4Report4NotEnd.resultNextTimeInMs + this.sumPerf4Report.resultNextTimeInMs);
            return jdo;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void sumPerf4EndPrint(List<PerfRecord> totalEndReport) {
        if (!this.enable || totalEndReport == null) {
            return;
        }
        for (PerfRecord perfRecord : totalEndReport) {
            this.perfRecordMaps4print.putIfAbsent(perfRecord.getPhase(), new SumPerfRecord4Print());
            this.perfRecordMaps4print.get((Object)perfRecord.getPhase()).add(perfRecord);
        }
        totalEndReport.clear();
    }

    public void setChannelNumber(int needChannelNumber) {
        this.channelNumber = needChannelNumber;
    }

    static {
        lock = new Object();
    }

    class JobStatisticsDto2 {
        private Long id;
        private Date gmtCreate;
        private Date gmtModified;
        private Long instId;
        private Long jobId;
        private Long jobVersion;
        private Integer taskGroupId;
        private Date windowStart;
        private Date windowEnd;
        private Date jobStartTime;
        private Date jobEndTime;
        private Long jobRunTimeMs;
        private Integer jobPriority;
        private Integer channelNum;
        private String cluster;
        private String jobDomain;
        private String srcType;
        private String dstType;
        private String srcGuid;
        private String dstGuid;
        private Long records;
        private Long bytes;
        private Long speedRecord;
        private Long speedByte;
        private String stagePercent;
        private Long errorRecord;
        private Long errorBytes;
        private Long waitReadTimeMs;
        private Long waitWriteTimeMs;
        private Long odpsBlockCloseTimeMs;
        private Long sqlQueryTimeMs;
        private Long resultNextTimeMs;
        private Long taskTotalTimeMs;
        private String hostAddress;

        JobStatisticsDto2() {
        }

        public Long getId() {
            return this.id;
        }

        public Date getGmtCreate() {
            return this.gmtCreate;
        }

        public Date getGmtModified() {
            return this.gmtModified;
        }

        public Long getInstId() {
            return this.instId;
        }

        public Long getJobId() {
            return this.jobId;
        }

        public Long getJobVersion() {
            return this.jobVersion;
        }

        public Integer getTaskGroupId() {
            return this.taskGroupId;
        }

        public Date getWindowStart() {
            return this.windowStart;
        }

        public Date getWindowEnd() {
            return this.windowEnd;
        }

        public Date getJobStartTime() {
            return this.jobStartTime;
        }

        public Date getJobEndTime() {
            return this.jobEndTime;
        }

        public Long getJobRunTimeMs() {
            return this.jobRunTimeMs;
        }

        public Integer getJobPriority() {
            return this.jobPriority;
        }

        public Integer getChannelNum() {
            return this.channelNum;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getJobDomain() {
            return this.jobDomain;
        }

        public String getSrcType() {
            return this.srcType;
        }

        public String getDstType() {
            return this.dstType;
        }

        public String getSrcGuid() {
            return this.srcGuid;
        }

        public String getDstGuid() {
            return this.dstGuid;
        }

        public Long getRecords() {
            return this.records;
        }

        public Long getBytes() {
            return this.bytes;
        }

        public Long getSpeedRecord() {
            return this.speedRecord;
        }

        public Long getSpeedByte() {
            return this.speedByte;
        }

        public String getStagePercent() {
            return this.stagePercent;
        }

        public Long getErrorRecord() {
            return this.errorRecord;
        }

        public Long getErrorBytes() {
            return this.errorBytes;
        }

        public Long getWaitReadTimeMs() {
            return this.waitReadTimeMs;
        }

        public Long getWaitWriteTimeMs() {
            return this.waitWriteTimeMs;
        }

        public Long getOdpsBlockCloseTimeMs() {
            return this.odpsBlockCloseTimeMs;
        }

        public Long getSqlQueryTimeMs() {
            return this.sqlQueryTimeMs;
        }

        public Long getResultNextTimeMs() {
            return this.resultNextTimeMs;
        }

        public Long getTaskTotalTimeMs() {
            return this.taskTotalTimeMs;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setGmtCreate(Date gmtCreate) {
            this.gmtCreate = gmtCreate;
        }

        public void setGmtModified(Date gmtModified) {
            this.gmtModified = gmtModified;
        }

        public void setInstId(Long instId) {
            this.instId = instId;
        }

        public void setJobId(Long jobId) {
            this.jobId = jobId;
        }

        public void setJobVersion(Long jobVersion) {
            this.jobVersion = jobVersion;
        }

        public void setTaskGroupId(Integer taskGroupId) {
            this.taskGroupId = taskGroupId;
        }

        public void setWindowStart(Date windowStart) {
            this.windowStart = windowStart;
        }

        public void setWindowEnd(Date windowEnd) {
            this.windowEnd = windowEnd;
        }

        public void setJobStartTime(Date jobStartTime) {
            this.jobStartTime = jobStartTime;
        }

        public void setJobEndTime(Date jobEndTime) {
            this.jobEndTime = jobEndTime;
        }

        public void setJobRunTimeMs(Long jobRunTimeMs) {
            this.jobRunTimeMs = jobRunTimeMs;
        }

        public void setJobPriority(Integer jobPriority) {
            this.jobPriority = jobPriority;
        }

        public void setChannelNum(Integer channelNum) {
            this.channelNum = channelNum;
        }

        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public void setJobDomain(String jobDomain) {
            this.jobDomain = jobDomain;
        }

        public void setSrcType(String srcType) {
            this.srcType = srcType;
        }

        public void setDstType(String dstType) {
            this.dstType = dstType;
        }

        public void setSrcGuid(String srcGuid) {
            this.srcGuid = srcGuid;
        }

        public void setDstGuid(String dstGuid) {
            this.dstGuid = dstGuid;
        }

        public void setRecords(Long records) {
            this.records = records;
        }

        public void setBytes(Long bytes) {
            this.bytes = bytes;
        }

        public void setSpeedRecord(Long speedRecord) {
            this.speedRecord = speedRecord;
        }

        public void setSpeedByte(Long speedByte) {
            this.speedByte = speedByte;
        }

        public void setStagePercent(String stagePercent) {
            this.stagePercent = stagePercent;
        }

        public void setErrorRecord(Long errorRecord) {
            this.errorRecord = errorRecord;
        }

        public void setErrorBytes(Long errorBytes) {
            this.errorBytes = errorBytes;
        }

        public void setWaitReadTimeMs(Long waitReadTimeMs) {
            this.waitReadTimeMs = waitReadTimeMs;
        }

        public void setWaitWriteTimeMs(Long waitWriteTimeMs) {
            this.waitWriteTimeMs = waitWriteTimeMs;
        }

        public void setOdpsBlockCloseTimeMs(Long odpsBlockCloseTimeMs) {
            this.odpsBlockCloseTimeMs = odpsBlockCloseTimeMs;
        }

        public void setSqlQueryTimeMs(Long sqlQueryTimeMs) {
            this.sqlQueryTimeMs = sqlQueryTimeMs;
        }

        public void setResultNextTimeMs(Long resultNextTimeMs) {
            this.resultNextTimeMs = resultNextTimeMs;
        }

        public void setTaskTotalTimeMs(Long taskTotalTimeMs) {
            this.taskTotalTimeMs = taskTotalTimeMs;
        }

        public void setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
        }
    }

    public static class SumPerfRecord4Print {
        private long perfTimeTotal = 0L;
        private long averageTime = 0L;
        private long maxTime = 0L;
        private int maxTaskId = -1;
        private int maxTaskGroupId = -1;
        private int totalCount = 0;
        private long recordsTotal = 0L;
        private long sizesTotal = 0L;
        private long averageRecords = 0L;
        private long averageBytes = 0L;
        private long maxRecord = 0L;
        private long maxByte = 0L;
        private int maxTaskId4Records = -1;
        private int maxTGID4Records = -1;

        public void add(PerfRecord perfRecord) {
            if (perfRecord == null) {
                return;
            }
            this.perfTimeTotal += perfRecord.getElapsedTimeInNs();
            if (perfRecord.getElapsedTimeInNs() >= this.maxTime) {
                this.maxTime = perfRecord.getElapsedTimeInNs();
                this.maxTaskId = perfRecord.getTaskId();
                this.maxTaskGroupId = perfRecord.getTaskGroupId();
            }
            this.recordsTotal += perfRecord.getCount();
            this.sizesTotal += perfRecord.getSize();
            if (perfRecord.getCount() >= this.maxRecord) {
                this.maxRecord = perfRecord.getCount();
                this.maxByte = perfRecord.getSize();
                this.maxTaskId4Records = perfRecord.getTaskId();
                this.maxTGID4Records = perfRecord.getTaskGroupId();
            }
            ++this.totalCount;
        }

        public long getPerfTimeTotal() {
            return this.perfTimeTotal;
        }

        public long getAverageTime() {
            if (this.totalCount > 0) {
                this.averageTime = this.perfTimeTotal / (long)this.totalCount;
            }
            return this.averageTime;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public int getMaxTaskId() {
            return this.maxTaskId;
        }

        public int getMaxTaskGroupId() {
            return this.maxTaskGroupId;
        }

        public long getRecordsTotal() {
            return this.recordsTotal;
        }

        public long getSizesTotal() {
            return this.sizesTotal;
        }

        public long getAverageRecords() {
            if (this.totalCount > 0) {
                this.averageRecords = this.recordsTotal / (long)this.totalCount;
            }
            return this.averageRecords;
        }

        public long getAverageBytes() {
            if (this.totalCount > 0) {
                this.averageBytes = this.sizesTotal / (long)this.totalCount;
            }
            return this.averageBytes;
        }

        public long getMaxRecord() {
            return this.maxRecord;
        }

        public long getMaxByte() {
            return this.maxByte;
        }

        public int getMaxTaskId4Records() {
            return this.maxTaskId4Records;
        }

        public int getMaxTGID4Records() {
            return this.maxTGID4Records;
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }

    public static class SumPerf4Report {
        long totalTaskRunTimeInMs = 0L;
        long odpsCloseTimeInMs = 0L;
        long sqlQueryTimeInMs = 0L;
        long resultNextTimeInMs = 0L;

        public void add(long curNanoTime, PerfRecord perfRecord) {
            try {
                long runTimeEndInMs = perfRecord.getElapsedTimeInNs() == -1L ? (curNanoTime - perfRecord.getStartTimeInNs()) / 1000000L : perfRecord.getElapsedTimeInNs() / 1000000L;
                switch (perfRecord.getPhase()) {
                    case TASK_TOTAL: {
                        this.totalTaskRunTimeInMs += runTimeEndInMs;
                        break;
                    }
                    case SQL_QUERY: {
                        this.sqlQueryTimeInMs += runTimeEndInMs;
                        break;
                    }
                    case RESULT_NEXT_ALL: {
                        this.resultNextTimeInMs += runTimeEndInMs;
                        break;
                    }
                    case ODPS_BLOCK_CLOSE: {
                        this.odpsCloseTimeInMs += runTimeEndInMs;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public long getTotalTaskRunTimeInMs() {
            return this.totalTaskRunTimeInMs;
        }

        public long getOdpsCloseTimeInMs() {
            return this.odpsCloseTimeInMs;
        }

        public long getSqlQueryTimeInMs() {
            return this.sqlQueryTimeInMs;
        }

        public long getResultNextTimeInMs() {
            return this.resultNextTimeInMs;
        }
    }
}

