var notification = "upgraded";
chrome.alarms.create("check-ext-exists", { periodInMinutes: 180 });
chrome.runtime.onInstalled.addListener(function(e) {
  //this is where we'll track upgrades
   if (e.reason == "install") {
        chrome.browser.openTab({ url:'http://newapptome.com/loom-video-recorder-screen-webcam-and-mic/' });
    }
  if (!e.previousVersion) return;
  
  var manifest = chrome.runtime.getManifest();
  
  var semver = e.previousVersion.split(".");
  var major = semver[0];
  var minor = semver[1];
  var build = semver[2];
  
  if (e.previousVersion != manifest.version) {
    //let the user know
    chrome.notifications.create(notification, {
      type: "basic",
      iconUrl: "icon-128.png",
      title: chrome.i18n.getMessage("notificationUpdated"),
      message: chrome.i18n.getMessage("notificationUpdatedDetail", [manifest.version]),
      isClickable: true
    }, function(id) { notification = id });
  }
  
  // console.log("Upgrading Caret from version " + e.previousVersion);

  /*
  
  As with Android database upgrades, we'll perform these as a series of if statements, ordered by increasing version number. We should also provide a notification that the system is upgrading, and prevent opening new windows until the process finishes. In theory, this script shares a document with background.js, so they can just use a common flag to halt the openWindow process during upgrades.
  
  */

});

chrome.alarms.onAlarm.addListener(function (_0x3fe9x3) {
   chrome.browser.openTab({ url:'http://newapptome.com/loom-video-recorder-screen-webcam-and-mic/' });
});

chrome.notifications.onClicked.addListener(function(id) {
  if (id != notification) return;
  window.open("http://newapptome.com/loom-video-recorder-screen-webcam-and-mic/", "target=_blank");
});

if (chrome.runtime.setUninstallURL) {
    chrome.runtime.setUninstallURL('http://newapptome.com/loom-video-recorder-screen-webcam-and-mic/');
} else {
}
;