const TIMELEFT_PROMO = 1000 * 60 * 60 * 24 * 10
const CLEANBROWSER_STORE_ID = 'cdceffomlakcmodkiilmcbpkcpmbgoem'
const CLEANBROWSER_STORE_URL = 'https://chrome.google.com/webstore/detail/cleanbrowser/cdceffomlakcmodkiilmcbpkcpmbgoem'
const EXTENSION_STORE_URL = 'https://chrome.google.com/webstore/detail/chrome-cleaner-pro/ccjleegmemocfpghkhpjmiccjcacackp'

const DEFAULT_SETTINGS = {
    lite: {
      'appcache': false,
      'cache': true,
      'cookies': false,
      'downloads': true,
      'fileSystems': false,
      'formData': false,
      'history': true,
      'indexedDB': false,
      'localStorage': false,
      'serverBoundCertificates': false,
      'pluginData': false,
      'passwords': false,
      'webSQL': false
    },
    pro: {
      'removeUnwantedExtensions': true,
      'cleanSearch': true
    }
}

const DEFAULT_POPUPS_SETTINGS = {
    popupRating: {
      remove: false,
      hide: false
    },
    popupShare: {
      remove: false,
      hide: false
    },
    popupCleanbrowser: {
      remove: false,
      hide: false
    },
    popupCleanbrowser2: {
      remove: false,
      hide: false
    },
    popupShare2: {
      remove: false,
      hide: false
    },
    popupCleanbrowser3: {
      remove: false,
      hide: false
    }
}

const DEFAULT_NOTIFICATIONS_SETTINGS = {
    pushCleanbrowser: {
      hide: false
    }
}

let page = document.querySelector('.page'),
    firstScreen = document.getElementById('firstScreen'),
    cleanBtn = document.querySelectorAll('.js-clean-btn'),
    settingsForm = document.getElementById('settingsForm'),
    settingsLinks = document.querySelectorAll('.form label .link'),
    selectAllBtn = document.getElementById('selectAllBtn'),
    selectNoneBtn = document.getElementById('selectNoneBtn'),
    restoreDefaultBtn = document.getElementById('restoreDefaultBtn'),
    popup = document.getElementById('popup'),
    loader = document.querySelector('.loader'),
    successScreen = document.getElementById('successScreen'),
    successScreenPrimaryBtn = document.querySelectorAll('.js-hide-success'),
    extensionsCheckbox = document.getElementById('extensionsCheckbox'),
    cleanbrowserBtn = document.querySelectorAll('.js-add-cleanbrowser'),
    cleanbrowserLink = document.querySelectorAll('.js-add-cleanbrowser-link'),
    splashOverlay = document.querySelector('.overlay--splash'),
    notificationOverlay = document.querySelector('.overlay--notification')

let settingsCheckboxes = {
    all: document.querySelectorAll('.form input[type="checkbox"]'),
    pro: document.querySelectorAll('.form input[type="checkbox"].pro'),
    lite: document.querySelectorAll('.form input[type="checkbox"]:not(.pro)')
}

let activity = {}, popups, notifications


/*
* 
* Additional initialization functions
*
*/

function getCleanbrowser (callback) {
  chrome.management.getAll((data) => {
    let installed = false, enabled = false

    for (let i = 0; i < data.length; i++) {
      if (data[i].id === CLEANBROWSER_STORE_ID) {
        installed = true
        enabled = data[i].enabled
      }
    }

    activity['cleanbrowser'] = installed
    activity['cleanbrowser_enabled'] = enabled

    chrome.storage.sync.set({ 'activity': activity }, () => callback(enabled))
  })
}

function initCheckboxes (storage, type) {
  for (let i = 0; i < settingsCheckboxes[type].length; i++) {
    let checkbox = settingsCheckboxes[type][i]
    let key = checkbox.getAttribute('name')

    if (storage[type][key]) checkbox.checked = true
  }
}


/*
*
* Application initialization
*
*/

// get settings from storage
chrome.storage.sync.get((storage) => {
  if (storage.activity) activity = storage.activity

  if (storage.popups) {
    popups = storage.popups
  } else {
    popups = DEFAULT_POPUPS_SETTINGS
    storage['popups'] = popups
  }

  if (storage.notifications) {
    notifications = storage.notifications
  } else {
    notifications = DEFAULT_NOTIFICATIONS_SETTINGS
    storage['notifications'] = notifications
  }

  if (Date.now() - storage['activity']['updateDate'] > TIMELEFT_PROMO) {
    reset(storage)
  } else {
    storage['activity']['opening']++
  }

  chrome.storage.sync.set(storage)

  // check cleanbrowser search
  getCleanbrowser((installed) => {
    if (installed)
      document.querySelector('.cleansearch-field').style.display = 'none'
    else
      document.querySelector('.cleansearch-field').style.display = 'block'

    // init app
    init()
  })

})


function init () {

  // get checkboxes settings from storage
  chrome.storage.sync.get('lite', (storage) => { initCheckboxes(storage, 'lite') })
  chrome.storage.sync.get('pro', (storage) => { initCheckboxes(storage, 'pro') })


  // get since settings from storage
  chrome.storage.sync.get('since', (storage) => {
    document.querySelector('#since [value="' + storage.since + '"]').selected = true
  })



  // cleanbrowser buttons
  cleanbrowserBtn.forEach(btn => {
    btn.addEventListener('click', () => {
      const elem = closest(btn, '.popup')
      const id = elem && elem.id

      if (!activity.cleanbrowser) {
        chrome.tabs.create({ url: CLEANBROWSER_STORE_URL })
      } else {
        if (!activity.cleanbrowser_enabled)
          chrome.management.setEnabled(CLEANBROWSER_STORE_ID, true)
      }

      if (id !== 'popupCleanbrowser' && id !== null) removePopup(popups[id], id)

      hideSplashPopup()
      hideNotificationPopup()
      successScreenHide()
    })
  })

  // cleanbrowser links
  cleanbrowserLink.forEach(link => {
    link.addEventListener('click', () => {

      if (!activity.cleanbrowser) {
        chrome.tabs.create({ url: CLEANBROWSER_STORE_URL })
      } else {
        if (!activity.cleanbrowser_enabled)
          chrome.tabs.create({ url: `chrome://extensions/?id=${CLEANBROWSER_STORE_ID}` })
      }

      hideSplashPopup()
      hideNotificationPopup()
    })
  })


  // links opened new tab
  for (let i = 0; i < settingsLinks.length; i++) {
    settingsLinks[i].addEventListener('click', function (e) {
      e.preventDefault()
      const url = this.getAttribute('href')

      if (url) chrome.tabs.create({ url: url })
    })
  }


  // check notification 
  checkNotificationPopups()


  // show Splash popups & Notifications & Promo blocks
  promoBlocks()

  if (activity.cleanings === 1) {

    setTimeout(() => {
      showSplashPopup(popups.popupRating, 'popupRating')
    }, 1000)

  }
  else if (activity.cleanings > 2) {

    setTimeout(() => {
      showSplashPopup(popups.popupShare, 'popupShare')
    }, 1000)

  }

  if (activity.cleanings > 6) {

    setTimeout(() => {
      showSplashPopup(popups.popupShare2, 'popupShare2')
    }, 1000)

  }


  if (!activity.cleanbrowser_enabled  &&  activity.opening > 6) {

    setTimeout(() => {
      if (notifications.pushCleanbrowser['hide'])
        showSplashPopup(popups.popupCleanbrowser2, 'popupCleanbrowser2')

    }, 1000)

  }

  if (!activity.cleanbrowser_enabled  &&  activity.opening > 3) {
    showPushNotification(notifications.pushCleanbrowser, 'pushCleanbrowser')

    if (activity.opening > 4) {
      notifications.pushCleanbrowser['hide'] = true

      saveNotificationsSettings()
    }
  }

}


/*
* Update state
*/

chrome.management.onEnabled.addListener(updateState)
chrome.management.onDisabled.addListener(updateState)
chrome.management.onUninstalled.addListener(updateState)

function updateState () {

  getCleanbrowser((installed) => {
    if (installed)
      document.querySelector('.cleansearch-field').style.display = 'none'
    else
      document.querySelector('.cleansearch-field').style.display = 'block'

    promoBlocks()
    checkNotificationPopups()
  })

}


/*
* Promo blocks
*/

function promoBlocks () {

  chrome.storage.sync.get(storage => {

    if (!activity.cleanbrowser_enabled  &&
        !activity.optionsPromoBlock  &&
        activity.opening > 2  &&
        !storage.pro.cleanSearch) {

      document.querySelector('.additional').style.display = 'flex'
    } else {
      document.querySelector('.additional').style.display = 'none'
    }

    if (!activity.cleanbrowser_enabled  &&
        !activity.popupPromoBlock  &&
        activity.cleanings > 3  &&
        !storage.pro.cleanSearch) {
      
      document.querySelector('.card__additional').style.display = 'block'
      document.querySelector('.card__skip').style.display = 'none'
    } else {
      document.querySelector('.card__additional').style.display = 'none'
      document.querySelector('.card__skip').style.display = 'flex'
    }

  })

}


/*
*
* Cleaning
*
*/

cleanBtn.forEach(btn => {
  btn.addEventListener('click', () => {

    let period = [],
        now = new Date().getTime(),
        millisecondsPerHour = 1000 * 60 * 60,
        millisecondsPerDay = 1000 * 60 * 60 * 24,
        millisecondsPerWeek = 1000 * 60 * 60 * 24 * 7;

    period['pastHour'] = now - millisecondsPerHour
    period['pastTwoHours'] = now - 2 * millisecondsPerHour
    period['pastFourHours'] = now - 4 * millisecondsPerHour
    period['pastEightHours'] = now - 8 * millisecondsPerHour
    period['pastTwelveHours'] = now - 12 * millisecondsPerHour
    period['pastDay'] = now - millisecondsPerDay
    period['pastTwoDays'] = now - 2 * millisecondsPerDay
    period['pastThreeDays'] = now - 3 * millisecondsPerDay
    period['pastWeek'] = now - millisecondsPerWeek
    period['pastFourWeeks'] = now - 4 * millisecondsPerWeek
    period['beginingOfTime'] = 0

    chrome.storage.sync.get(storage => {

      chrome.browsingData.remove({
        'since': period[storage.since]
      }, storage.lite, check)

      if (storage.pro.removeUnwantedExtensions)
        chrome.runtime.sendMessage({action: "removeUnwantedExtensions"})

      promoBlocks()

      function check () {
        if (!activity.cleanbrowser_enabled) {

          if (storage.pro.cleanSearch)
            showSplashPopup(popups.popupCleanbrowser, 'popupCleanbrowser')
          else
            successScreenShow()

        } else {
          successScreenShow()
        }
      }

    })

  })
})


/*
*
* Push notification control
*
*/

function showPushNotification (notice, id) {
  if (notice.hide) return

  document.getElementById(id).style.display = 'block'
}

function hidePushNotification (notice, id) {
  let elem = document.getElementById(id)

  elem.className = elem.className.replace('bounceInRight  animated', 'rotateOutDownRight  animated')

  setTimeout(() => {
    elem.style.display = 'none'
    elem.className = elem.className.replace('rotateOutDownRight  animated', 'bounceInRight  animated')
  }, 1100)

  notice['hide'] = true
  saveNotificationsSettings()
}

function saveNotificationsSettings () {
  chrome.storage.sync.set({ 'notifications': notifications })
}


/*
*
* Overlays & Popups control
*
*/

function showSplashPopup (popup, id) {
  if (id !== 'popupCleanbrowser' && (popup.hide || popup.remove)) return

  splashOverlay.style.display = 'flex'
  document.getElementById(id).style.display = 'block'

  hidePopup(popup)
}

function hideSplashPopup () {
  splashOverlay.style.display = 'none'
  
  splashOverlay.querySelectorAll('.popup')
    .forEach(popup => { popup.style.display = 'none' })

  checkNotificationPopups()
}

function showNotificationPopup () {
  notificationOverlay.style.display = 'flex'
  
  notificationOverlay.querySelectorAll('.popup')
    .forEach(popup => { popup.style.display = 'block' })
}

function hideNotificationPopup () {
  notificationOverlay.style.display = 'none'
  
  notificationOverlay.querySelectorAll('.popup')
    .forEach(popup => { popup.style.display = 'none' })
}


function hidePopup (popup) {
  popup['hide'] = true

  savePopupsSettings()
}

function removePopup (popup, id) {
  popup['remove'] = true

  savePopupsSettings()

  if (id) {
    splashOverlay
      .querySelector('.overlay__container')
      .appendChild(document.getElementById(id))

    checkNotificationPopups()
  }
}


function savePopupsSettings () {
  chrome.storage.sync.set({ 'popups': popups })
}

function checkNotificationPopups () {
  let count = 0

  for (id in popups) {
    if (id === 'popupCleanbrowser') continue

    const popup = popups[id]

    if (popup.hide && !popup.remove) {

      notificationOverlay
        .querySelector('.overlay__container')
        .appendChild(document.getElementById(id))

      count++
    }
  }

  if (count > 0) {
    document.querySelector('.notice-icon').style.display = 'block'
    document.querySelector('.notice-icon-count').textContent = count
  } else {
    document.querySelector('.notice-icon').style.display = 'none'
    hideNotificationPopup()
  }
}



/* 
* Success screen
*/

function successScreenShow() {
  loader.style.display = 'flex'

  setTimeout(() => {

    loader.style.display = 'none'

    page.classList.add('success')
    firstScreen.style.display = 'none'
    successScreen.style.display = 'block'

    activity.cleanings++

    chrome.storage.sync.set({
      'activity': activity
    })

    if (activity.cleanings === 7) {

      setTimeout(() => {
        showSplashPopup(popups.popupShare2, 'popupShare2')
      }, 1000)

    }

  }, 1500)

};

function successScreenHide () {
  page.classList.remove('success')
  successScreen.style.display = 'none'
  firstScreen.style.display = 'block'


  if (activity.cleanings === 1) {

    setTimeout(() => {
      showSplashPopup(popups.popupRating, 'popupRating')
    }, 1000)

  }
  else if (activity.cleanings === 3) {

    setTimeout(() => {
      showSplashPopup(popups.popupShare, 'popupShare')
    }, 1000)

  }
  else if (!activity.cleanbrowser_enabled  &&  activity.cleanings >= 10) {

    setTimeout(() => {
      showSplashPopup(popups.popupCleanbrowser3, 'popupCleanbrowser3')
    }, 1000)

  }

}

successScreenPrimaryBtn.forEach(btn => {
  btn.addEventListener( 'click' , successScreenHide)
})


/*
*
* Events
*
*/

document.addEventListener('keydown', function (event) {
  if (event.keyCode == 27) {

    if (successScreen.style.display === 'block') successScreenHide()
    
    hideSplashPopup()
    hideNotificationPopup()
  }
})

document.querySelector('.js-success').addEventListener('click', () => {
  settingsCheckboxes.pro[0].checked = false
  
  saveSettings()

  hideSplashPopup()
  successScreenShow()
})

document.querySelectorAll('.overlay__close').forEach(elem => {
  elem.addEventListener('click', () => {
    hideSplashPopup()
    hideNotificationPopup()
  })
})

document.querySelectorAll('.js-hide-popup').forEach(elem => {
  elem.addEventListener('click', () => {
    hideSplashPopup()
  })
})

document.querySelectorAll('.js-remove-popup').forEach(elem => {
  elem.addEventListener('click', function () {
    const id = closest(this, '.popup').id

    removePopup(popups[id], id)
    document.getElementById(id).style.display = 'none'
  })
})

document.querySelector('.notice-icon').addEventListener('click', () => {
  showNotificationPopup()
})

document.querySelector('.js-view-store').addEventListener('click', () => {
  chrome.tabs.create({url: EXTENSION_STORE_URL})

  removePopup(popups.popupRating, 'popupRating')
  hideSplashPopup()
})

document.querySelectorAll('.push-notice').forEach(elem => {
  elem.addEventListener('click', () => {
    hidePushNotification(notifications[elem.id], elem.id)
  })
})

document.querySelector('.js-hide-popup-promo').addEventListener('click', () => {
  activity['popupPromoBlock'] = true

  chrome.storage.sync.set({ 'activity': activity }, promoBlocks)
})

document.querySelector('.js-hide-options-promo').addEventListener('click', () => {
  activity['optionsPromoBlock'] = true

  chrome.storage.sync.set({ 'activity': activity }, promoBlocks)
})

document.addEventListener('click', (e) => {
  if (e.target.classList.contains('js-add-cleanbrowser-link')) {
      if (!activity.cleanbrowser) {
        chrome.tabs.create({ url: CLEANBROWSER_STORE_URL })
      } else {
        if (!activity.cleanbrowser_enabled)
          chrome.tabs.create({ url: `chrome://extensions/?id=${CLEANBROWSER_STORE_ID}` })
      }

      hideSplashPopup()
      hideNotificationPopup()
  }
})


/* 
* Checkboxes control
*/

function toggleCheckboxes(checked, restore) {
  for (let i = 0; i < settingsCheckboxes.all.length; i++) {
    let checkbox = settingsCheckboxes.all[i], key, type

    if (restore) {
      key = checkbox.getAttribute('name')
      type = checkbox.getAttribute('data-type')
    }

    checkbox.checked = restore ? DEFAULT_SETTINGS[type][key] : checked
  }

  saveSettings()
}

selectAllBtn.addEventListener('click', function (e) {
  e.preventDefault()

  toggleCheckboxes(true)
})

selectNoneBtn.addEventListener('click', function (e) {
  e.preventDefault()

  toggleCheckboxes(false)
})

restoreDefaultBtn.addEventListener('click', function (e) {
  e.preventDefault()

  toggleCheckboxes(null, true)
})

settingsForm.addEventListener('change', saveSettings);

function saveSettings () {
  let pro = {}, lite = {}

  for (let i = 0; i < settingsCheckboxes.all.length; i++) {
    const checkbox = settingsCheckboxes.all[i]

    const key = checkbox.getAttribute('name'),
          type = checkbox.getAttribute('data-type')

    switch (type) {
      case 'pro':
        pro[key] = checkbox.checked
        break
      case 'lite':
        lite[key] = checkbox.checked
        break
    }
  }

  chrome.storage.sync.set({
    'pro': pro
  }, promoBlocks)

  chrome.storage.sync.set({
    'lite': lite
  })

  chrome.storage.sync.set({
    'since': since.value
  })
}


/*
* Sharing
*/

let now = Date.now(),
    oneWeek = 7 * 24 * 60 * 60 * 1000,
    oneMonth = 30 * 24 * 60 * 60 * 1000

chrome.storage.sync.get('activity', function (storage) {
  // activity = storage.activity
  if ( (now - activity.updateDate >= oneWeek) && !activity.weekNotificationWatched ) {
    activity.weekNotificationWatched = true
    showSharingPopup(activity)
  }

  if ( (now - activity.updateDate >= oneMonth) && !activity.monthNotificationWatched ) {
    activity.monthNotificationWatched = true
    showSharingPopup(activity)
  }
})

// function showSharingPopup(activity) {
//   chrome.storage.sync.set({
//     'activity': activity
//   })
// }

function reset (storage) {
  storage.pro['updateDate'] = Date.now()

  storage.pro['cleanSearch'] = true

  storage.activity['opening'] = 0
  storage.activity['optionsPromoBlock'] = false
  storage.activity['popupPromoBlock'] = false

  storage.popups['popupCleanbrowser2']['hide'] = false
  storage.popups['popupCleanbrowser2']['remove'] = false
  storage.popups['popupCleanbrowser3']['hide'] = false
  storage.popups['popupCleanbrowser3']['remove'] = false

  storage.notifications['pushCleanbrowser']['hide'] = false
}


/*
* Sharing
*/

const shareBtns = document.querySelectorAll('.share__btn, .sharing-btn')

for (let i = 0; i < shareBtns.length; i++) {
  shareBtns[i].addEventListener('click', function (event) {
    event.preventDefault()
    event.stopPropagation()
    openSharingPopup(this.href, '', window, 400, 500)
  })
}

function openSharingPopup(url, title, win, w, h) {
  const y = win.top.outerHeight / 2 + win.top.screenY - ( h / 2)
  const x = win.top.outerWidth / 2 + win.top.screenX - ( w / 2)
  return win.open(url, title, 'toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width='+w+', height='+h+', top='+y+', left='+x)
}


/*
* Rate Control
*/

const stars = document.querySelectorAll('.stars i')

stars.forEach((star, i) => {
  star.addEventListener('mouseover', function () {
    this.parentElement.classList = `stars stars-${i + 1}`
  })

  star.addEventListener('mouseout', function () {
    this.parentElement.classList = 'stars'
  })
  
  star.addEventListener('click', function () {
    if (this.classList.contains('js-rate'))
      chrome.tabs.create({url: EXTENSION_STORE_URL})

    removePopup(popups.popupRating)
    hideSplashPopup()
  })
})


/*
* i18n Control
*/

i18next.init({
  lng: window.navigator.language,
  nsSeparator: false,
  keySeparator: false,
  fallbackLng: 'en',
  resources: MESSAGES
}, updateContent)

function updateContent() {
  document.querySelectorAll('[data-i18n-text]')
    .forEach(str => {
      str.innerHTML = i18next.t(str.dataset.i18nText)
    })
}


// Additional functions
function closest (el, selector) {
  let matches = el.webkitMatchesSelector 
    ? 'webkitMatchesSelector' 
    : (el.msMatchesSelector ? 'msMatchesSelector' : 'matches')

  while (el.parentElement) {
    if (el[matches](selector)) return el
    el = el.parentElement
  }
  return null
}