/**
 * Feedbro default locale that must be available in all cases. If selected locale is missing a key, translation will fallback to this default map.
 */
Locale.locales["en_US"] =
{	
	"meta": {
		"manifest_version": 1,
		"locale_version": "1.0",
		"locale_name": "English",
		"locale_type": "en_US",
		"locale_last_updated": "2019-10-18 12:00:00 UTC",
		"locale_author_name": "Nodetics",
		"locale_author_email": "nodetics@gmail.com",
		"locale_source_url": "https://nodetics.com/feedbro/"
	},
	"addfeed_url_body": "Feed URL",
	"addfeed_load_body": "Load",
	"addfeed_title_body": "Title",
	"addfeed_latestentry_body": "Latest entry posted",
	"addfeed_status_body": "Status",
	"addfeed_maxitems_body": "Maximum entries to save",
	"addfeed_maxitems_select_title": "Maximum number of entries (articles) that are saved from a single feed. Oldest entries are automatically removed.",
	"addfeed_maxitems_default_body": "default",
	"addfeed_entrycontent_body": "Feed entry content",
	"addfeed_entrycontent_select_title": "Define how to process the feed entry content",
	"addfeed_entrycontent_select_asis_body": "As is - defined by the feed",
	"addfeed_entrycontent_select_asis_title": "",
	"addfeed_entrycontent_select_fulltextimage_body": "Get full article body with article main image",
	"addfeed_entrycontent_select_fulltextimage_title": "This is a slow and imprecise way to parse the full article content. Like Readability. Each feed article causes a separate HTTP GET request. It does not work with all sites. Main image is taken from og:image meta data.",
	"addfeed_entrycontent_select_fulltext_body": "Get full article body",
	"addfeed_entrycontent_select_fulltext_title": "This is a slow and imprecise way to parse the full article content. Like Readability. Each feed article causes a separate HTTP GET request. It does not work with all sites.",
	"addfeed_scaninterval_body": "Scan interval",
	"addfeed_scaninterval_default_body": "default",
	"addfeed_scaninterval_select_title": "Number of minutes to wait until the next scan for unread items takes place",
	"addfeed_scaninterval_minutes_body": "minutes",
	"addfeed_folder_body": "Folder",
	"addfeed_proxy_body": "Proxy",
	"addfeed_proxy_none_body": "None",
	"addfeed_proxy_none_title": "No proxy - load the feed directly from the source URL",
	"addfeed_proxy_feedly_title": "Use the Feedly API to load the feed. The benefit of this is that Feedly stores the complete feed history so you won't miss any items even when your computer is turned off. Note however that Feedly can have significant delays in updating the feed.",
	"addfeed_username_body": "Username",
	"addfeed_username_input_title": "Username for authentication - only needed if the feed is protected with HTTP Basic authentication",
	"addfeed_password_body": "Password",
	"addfeed_password_input_title": "Password for authentication - only needed if the feed is protected with HTTP Basic authentication",
	"addfeed_cancel_body": "Cancel",
	"addfeed_preview_body": "Preview",
	"addfeed_save_body": "Save",
	"addfeed_load_error_nourl": "Please enter a valid URL first!",
	"addfeed_load_error_invalidurl": "URL {1} is not a valid feed and contains no feed links.",
	"addfeed_load_error_loadfailed": "Unable to load feed {1}:\n{2}: {3}",
	"addfeed_alternatives_clicktip": "Click to select this feed",

	"article_links_addstar": "Add a star - Shortcut: s",
	"article_links_sendto_title": "Click to send link via email or save/share in social media sites like Facebook, Twitter etc",
	"article_links_sendto_body": "Send To",
	"article_action_pocket_success": "Saved to Pocket: '{1}'",
	"article_action_keepunread_body": "Keep unread",
	"article_action_keepunread_title": "Keep this entry as unread - Shortcut: m",
	"article_action_tags_title": "Manage tags - Shortcut: t",
	"article_action_delete_title": "Delete this entry permanently - Shortcut: d",
	"article_action_delete_body": "Delete",
	"article_fromline_from": "from",
	"article_fromline_by": "by",
	"article_fromline_clicktoload": "Click to load articles from this feed",
	"article_header_clicktip": "Open original article in a new tab. Click elsewhere in the article area to expand it.",
	"article_header_pointstip": "Total points given by your custom Rules to this article",
	"article_header_markread_title": "Mark this entry read/unread - Shortcut: m",
	"article_header_clickopen": "Click to Open",
	"article_action_delete_tag": "Delete Tag",
	"article_action_add_tag": "Add Tag",
	"article_action_enclosure_view": "View",
	"article_action_enclosure_view_enclosure": "enclosure:",
	"article_action_enclosure_label": "Enclosure:",

	"bookmarks_header_body": "Import Firefox Bookmarks",
	"bookmarks_savebookmarksguide_body": "Save your Firefox bookmarks as HTML:\nIn Firefox: Menu | Library | Bookmarks | Show all bookmarks, choose 'Import and Backup' menu and then 'Export Bookmarks to HTML...'",
	"bookmarks_salectfile_body": "Select the Firefox bookmarks HTML file you just saved:",
	"bookmarks_selectbookmarks_body": "Select the feed bookmarks (that point to valid RSS/ATOM/RDF URLs) you want to import/save using the checkboxes below",
	"bookmarks_import_body": "Import to Feedbro",
	"bookmarks_saveopml_body": "Save as OPML file",
	"bookmarks_or": "or",

	"bottomlink_feedback_body": "Feedback",
	"bottomlink_bugreports_body": "Bug Reports",
	"bottomlink_knownissues_body": "Known Issues",
	"bottomlink_changelog_body": "Change Log",
	"bottomlink_credits_body": "Credits",
	
	"common_root": "Root",
	
	"datetag_future_tag": "Future",
	"datetag_today_tag": "Today",
	"datetag_yesterday_tag": "Yesterday",
	"datetag_thisweek_tag": "This week",
	"datetag_lastweek_tag": "Last week",
	"datetag_thismonth_tag": "This month",
	"datetag_lastmonth_tag": "Last month",
	"datetag_month_January_tag": "January",
	"datetag_month_February_tag": "February",
	"datetag_month_March_tag": "March",
	"datetag_month_April_tag": "April",
	"datetag_month_May_tag": "May",
	"datetag_month_June_tag": "June",
	"datetag_month_July_tag": "July",
	"datetag_month_August_tag": "August",
	"datetag_month_September_tag": "September",
	"datetag_month_October_tag": "October",
	"datetag_month_November_tag": "November",
	"datetag_month_December_tag": "December",
	
	"dialog_ok": "OK",
	"dialog_cancel": "Cancel",
	
	"eventform_event_body": "Event",
	"eventform_trigger_arrives_body": "New article arrives in feed",
	"eventform_trigger_viewed_body": "Article is viewed in feed",
	"eventform_article_title_body": "Article Title",
	"eventform_article_url_body": "Article URL",
	"eventform_article_author_body": "Article Author",
	"eventform_article_content_body": "Article Content",
	"eventform_matchedrules_body": "Matched Rules",
	"eventform_close_body": "Close",
	"eventform_test_body": "Test Rules",

	"feedfinder_close_title": "Close Panel",
	"feedfinder_searchfield_placeholder": "Search by string, website or hashtag",
	"feedfinder_search_value": "Search",
	"feedfinder_lang_title": "Choose preferred feed language",
	"feedfinder_maxage_title": "Maximum age of the latest post",
	"feedfinder_maxage_all_body": "All",
	"feedfinder_maxage_24h_body": "Last Updated 24h ago",
	"feedfinder_maxage_3d_body": "Last Updated 3d ago",
	"feedfinder_maxage_7d_body": "Last Updated 7d ago",
	"feedfinder_maxage_14d_body": "Last Updated 14d ago",
	"feedfinder_maxage_30d_body": "Last Updated 30d ago",
	"feedfinder_maxage_45d_body": "Last Updated 45d ago",
	"feedfinder_maxage_60d_body": "Last Updated 60d ago",
	"feedfinder_maxage_90d_body": "Last Updated 90d ago",
	"feedfinder_maxage_180d_body": "Last Updated 180d ago",
	"feedfinder_maxage_365d_body": "Last Updated 365d ago",
	"feedfinder_alreadysubscribed_title": "Already subscribed to this feed",
	"feedfinder_action_preview": "Preview",
	"feedfinder_error_noresults": "No matching results.",
	
	"frontpage_link_addfolder_body": "Add a\nnew Folder",
	"frontpage_link_addfeed_title": "Faster way: open the feed/web page, click Feedbro icon and select 'Find Feeds in Current Tab'",
	"frontpage_link_addfeed_icon_title": "Faster way: open the feed/web page, click the Feedbro icon and select 'Find Feeds in Current Tab'",
	"frontpage_link_addfeed_body": "Add a\nnew Feed",
	"frontpage_link_import_body": "Import Feed\nSubscriptions\nas OPML",
	"frontpage_link_settings_body": "Settings",
	"frontpage_link_help_body": "Help",
	"frontpage_description_body": "Read news &amp; blogs or any other RSS/Atom/RDF source.",
	"frontpage_description_title": "Open the page you want to follow, click Feedbro icon and choose 'Find Feeds in Current Tab'",

	"itemage_title": "Feed items older than this will not be loaded",
	"itemage_1h_body": "Article max age 1 hour",
	"itemage_2h_body": "Article max age 2 hours",
	"itemage_4h_body": "Article max age 4 hours",
	"itemage_8h_body": "Article max age 8 hours",
	"itemage_24h_body": "Article max age 24 hours",
	"itemage_48h_body": "Article max age 48 hours",
	"itemage_3d_body": "Article max age 3 days",
	"itemage_1w_body": "Article max age 1 week",
	"itemage_2w_body": "Article max age 2 weeks",
	"itemage_1m_body": "Article max age 1 month",
	"itemage_2m_body": "Article max age 2 months",
	"itemage_6m_body": "Article max age 6 months",
	"itemage_1y_body": "Article max age 1 year",
	"itemage_unlimited_body": "Article max age unlimited",
	
	"loadstatus_0": "Not scanned yet",
	"loadstatus_200": "OK",
	"loadstatus_398": "No network",
	"loadstatus_399": "Connection timeout",
	"loadstatus_401": "Authorization required",
	"loadstatus_403": "Access denied",
	"loadstatus_404": "Not found",
	"loadstatus_500": "Internal server error",
	"loadstatus_503": "Service unavailable",
	"loadstatus_601": "Invalid XML",
	"loadstatus_602": "Invalid Content-Type",
	"loadstatus_603": "Invalid XML - Missing entry date values",
	"loadstatus_broken": "Broken",
	
	"mainmenu_addtofolder": "Add to folder",
	"mainmenu_input_title": "Click to select this feed",
	"mainmenu_newtab_title": "Click to open the original source in a new tab.",
	"mainmenu_preview_title": "Click to preview the feed contents in Feedbro",
	"mainmenu_edit_title": "Click to edit the name",
	"mainmenu_selectfolder_title": "Click to select a folder where to save the feed - Root is the top level folder",
	"mainmenu_button_subscribe": "Subscribe",
	"mainmenu_button_close": "Close",
	"mainmenu_error_duplicate_folder": "You have already subscribed to '{1}' in folder '{2}' with the title '{3}'",
	"mainmenu_error_duplicate": "You have already subscribed to '{1}' with the title '{2}'",
	"mainmenu_error_nothing_selected": "No feeds selected!",
	"mainmenu_error_nothing_found": "No feeds found!",
	"mainmenu_success_addedmultiple": "{1} feeds added!",
	"mainmenu_success_addedsingle": "Feed added!",
	"mainmenu_rootfolder": "Root",
	"mainmenu_openreader_body": "Open Feed Reader",
	"mainmenu_findfeeds_body": "Find Feeds in Current Tab",
	"mainmenu_options_body": "Options",
	"mainmenu_openexplorer_body": "Open Explorer",
	"mainmenu_openexplorer_title": "Browse unread articles in feeds",
	"mainmenu_open_originalarticle": "Open original article",
	"mainmenu_mark_read": "Mark article as read",
	"mainmenu_favorite": "Mark as favorite (star)",
	"mainmenu_delete": "Delete article",
	"mainmenu_liveclick_nounread": "No Unread Entries",
	"mainmenu_liveclick_authorprefix": "by",

	"mainmenu_allitems_body": "All Items", 
	"mainmenu_starreditems_body": "Starred Items", 
	"mainmenu_rules_body": "Rules", 
	"mainmenu_tags_body": "Tags", 
	"mainmenu_statistics_body": "Statistics",
	
	"navigator_action_deletefeed_confirm": "Are you sure you want to delete feed '{1}'?",
	"navigator_action_deletefolder_confirm": "Are you sure you want to delete folder '{1}'?",
	"navigator_action_rename_prompt": "Enter a new name for the item",
	"navigator_action_rename_toolong": "Name must be between 1 and 50 characters long! Given length: {1}",
	"navigator_action_markread_confirm": "Do you really want to mark all items in '{1}' as read?",
	"navigator_action_markread_noselection": "No feed or folder selected!",
	"navigator_action_markread_all_confirm": "Do you really want to mark all items in all feeds as read?",
	"navigator_action_deleteall_success": "All articles loaded in the current view deleted.",
	"navigator_action_addfolder_prompt": "Folder name",
	"navigator_action_addfolder_toolong": "Name must be between 1 and 35 characters long!",
	"navigator_action_reload": "Started scanning all feeds for new articles. This can take a long time. Normally you should not need to do this at all. Please wait...",

	"navigator_ctxmenu_markread": "Mark All Items as Read",
	"navigator_ctxmenu_rename": "Rename",
	"navigator_ctxmenu_sortfeeds": "Sort Feeds in Folder",
	"navigator_ctxmenu_delete": "Delete",
	"navigator_ctxmenu_updatefeed": "Update Feed",
	"navigator_ctxmenu_properties": "Properties",
	"navigator_ctxmenu_updatefolder": "Update Feeds in Folder",
	"navigator_ctxmenu_updatefeed_success": "Loading feed entries from the feed source",
	"navigator_ctxmenu_updatefolder_success": "Loading feeds in the folder from feed sources",
	
	"navigator_tree_error_underfeed": "Can't move items under feeds.",
	"navigator_tree_error_underfolder": "Can't move folders under other folders.",
	"navigator_tree_unread": "unread",
	"navigator_tree_rightclickoptions": "Right-click for options",
	
	"options_subscriptionsandrules_body": "Feed Subscriptions &amp; Rules",
	"options_feeds_body": "Feeds",
	"options_rules_body": "Rules",
	"options_importfeeds_body": "Import Feed Subscriptions (as OPML)",
	"options_exportfeeds_body": "Export Feed Subscriptions (as OPML)",
	"options_deletefeeds_body": "Delete Feeds and Folders",
	"options_importrules_body": "Import Rules (as JSON)",
	"options_exportrules_body": "Export Rules (as JSON)",
	"options_deleterules_body": "Delete Rules",
	"options_bookmarks_body": "Bookmarks",
	"options_importbookmarks_body": "Import Firefox Bookmarks (as HTML)",
	"options_settings_body": "Settings",
	"options_theme_body": "Theme",
	"options_theme_select_title": "Color theme for the Feedbro user interface",
	
	"options_locale_body": "User interface language",
	"options_action_import_locale_body": "Import Locale",
	"options_locale_url": "URL address of the Feedbro Locale (JSON-file)",
	"options_action_locale_failed": "Locale import failed! Error: {1}",
	"options_action_locale_success": "Locale import successful!",
	"options_action_update_locale_body": "Update Locale",
	"options_action_locale_update_failed": "Locale update failed! Error: {1}",
	"options_action_locale_update_success": "Locale update successful!",
	"options_action_template_locale_body": "Get Locale Template",
	"options_action_template_locale_title": "Use this template to translate Feedbro to another language.",
	
	"options_extensionclick_body": "Feedbro extension icon click",
	"options_extensionclick_select_title": "Defines what happens when the Feedbro extension icon is clicked",
	"options_extensionclick_popup_body": "Opens the popup menu (to open the feed reader or scan the tab for feeds)",
	"options_extensionclick_reader_body": "Opens the feed reader",
	"options_loadingtimeout_body": "Feed loading timeout",
	"options_loadingtimeout_select_title": "Maximum time to wait for a single feed to load before timeout expires and connection is aborted",
	"options_loadingtimeout_unit_body": "seconds",
	"options_scaninterval_body": "Scan interval (default)",
	"options_scaninterval_select_title": "Number of minutes to wait until the next scan for unread items across all feeds takes place",
	"options_scaninterval_unit_body": "minutes",
	"options_threads_body": "Feed update threads",
	"options_threads_select_title": "Number of feeds to load concurrently. Higher number = faster updates but heavier network load. Use a smaller number if you have low network bandwidth.",
	"options_maxentries_body": "Maximum entries to save (default)",
	"options_maxentries_select_title": "Maximum number of entries (articles) that are loaded from a single feed (aggregated feed can contain any number of entries)",
	"options_inactivelimit_body": "Inactive feed limit",
	"options_inactivelimit_select_title": "If the latest post in the feed was more than X days ago, feed is considered to be inactive and is automatically selected for removal in Feed Statistics view.",
	"options_inactivelimit_unit_body": "days",
	"options_dateformat_body": "Date format",
	"options_article_titlefontsize_body": "Article title font size",
	"options_article_titlefontsize_select_title": "Relative size of the article title text compared to the default setting",
	"options_article_bodyfontsize_body": "Article body font size",
	"options_article_bodyfontsize_select_title": "Relative size of the article body text compared to the default setting",
	"options_article_bodylineheight_body": "Article body line height",
	"options_article_bodylineheight_select_title": "Line height in the text compared to the font size",
	"options_article_font_body": "Article font family",
	"options_article_width_body": "Article width",
	"options_article_width_default_body": "default",
	"options_article_width_view1_body": "View 1:",
	"options_article_width_view2_body": "View 2:",
	"options_article_width_view3_body": "View 3:",
	"options_article_width_view4_body": "View 4:",
	"options_article_width_view5_body": "View 5:",
	"options_article_width_view6_body": "View 6:",
	"options_article_height_body": "Article card height",
	"options_article_height_select_title": "Article card height for view mode 4",
	"options_article_height_unlimited_body": "Unlimited",
	"options_article_translationtarget_body": "Article translation target language",
	"options_article_translationtarget_select_title": "When using Google Translate under Send To menu, use this language as the translation target language",
	"options_markread_body": "Mark article as read",
	"options_markread_title_body": "Automatically when the article is shown as a title or as a full article",
	"options_markread_bottom_body": "Automatically when the bottom of the article body is displayed",
	"options_markread_manually_body": "Manually",
	"options_markread_confirm_body": "Confirm dialog for 'Mark Read' function",
	"options_markread_confirm_never_body": "Never",
	"options_markread_confirm_never_title": "DANGER! You may accidentally mark all your unread articles as read with this setting on! There's no undo!",
	"options_markread_confirm_allitems_body": "Only when marking 'All Items' view as read",
	"options_markread_confirm_always_body": "Always",
	"options_notificationclick_body": "Article desktop notification click",
	"options_notificationclick_select_title": "Defines what happens when user clicks the Desktop notification popup of an article",
	"options_notificationclick_feedbro_body": "Opens the article in Feedbro",
	"options_notificationclick_tab_body": "Opens the article in a new tab on the original website",
	"options_popupclick_body": "Popup window article list article link",
	"options_popupclick_feedbro_body": "Opens the article in Feedbro",
	"options_popupclick_tab_body": "Opens the article in a new tab on the original website",
	"options_notification_timeout_body": "Notification timeout",
	"options_notification_timeout_select_title": "Maximum time a notification is shown before it is automatically cleared",
	"options_notification_timeout_none_body": "No timeout",
	"options_notification_timeout_1s_body": "1 second",
	"options_notification_timeout_2s_body": "2 seconds",
	"options_notification_timeout_3s_body": "3 seconds",
	"options_notification_timeout_4s_body": "4 seconds",
	"options_notification_timeout_5s_body": "5 seconds",
	"options_notification_timeout_6s_body": "6 seconds",
	"options_notification_timeout_7s_body": "7 seconds",
	"options_notification_timeout_8s_body": "8 seconds",
	"options_notification_timeout_9s_body": "9 seconds",
	"options_notification_timeout_10s_body": "10 seconds",
	"options_notification_timeout_11s_body": "11 seconds",
	"options_notification_timeout_12s_body": "12 seconds",
	"options_notification_timeout_15s_body": "15 seconds",
	"options_notification_timeout_20s_body": "20 seconds",
	"options_notification_timeout_30s_body": "30 seconds",
	"options_notification_timeout_60s_body": "60 seconds",
	"options_faviconprovider_body": "Favicon provider",
	"options_tagshortcuts_body": "Tag shortcuts",
	"options_tagshortcuts_title": "By pressing the key combination you can quickly add the specified tag to the active feed article (with blue border)",
	"options_removetags_body": "Remove tags from feed entries",
	"options_disableautoscan_body": "Disable automatic feed scanning",
	"options_disableautoscan_title": "If this is true, feeds are not automatically scanned for new articles. Only manual updates are possible",
	"options_disableautoselect_body": "Do not open first article in view mode 3 or 6",
	"options_disableautoselect_title": "If this is true, the first feed article isn't automatically selected in view mode 3 or 6",
	"options_refreshlist_body": "Refresh article list when opening Reader view",
	"options_refreshlist_input_title": "If checked, Feedbro will automatically reload the list of articles when Feedbro reading view is opened",
	"options_allitems_body": "Open 'All Items' view at start",
	"options_allitems_input_title": "If checked, Feedbro will automatically open 'All Items' upon startup",
	"options_sound_body": "Sound",
	"options_sound_input_title": "If checked, sound effects are enabled.",
	"options_sound_hint_body": "Note! You need to create a Rule (under Rules menu) to define when sound effects are triggered!",
	"options_notifications_body": "Notifications",
	"options_notifications_input_title": "If checked, desktop popup notifications are enabled",
	"options_notifications_hint_body": "Note! You need to create a Rule (under Rules menu) to define when notifications are displayed!",
	"options_favicons_navigator_body": "Use favicons for feeds in the feed navigator",
	"options_favicons_navigator_input_title": "If checked, Feedbro will use favicons based on html url of the feed in the feed tree navigator",
	"options_favicons_view3_body": "Use favicons in 3-panel view titles list",
	"options_favicons_view3_input_title": "If checked, Feedbro will show favicons in the middle titles-panel in three panel view",
	"options_favicons_fromline_body": "Use favicons in article 'from line'",
	"options_popup_latest_body": "Show a list of latest articles in the popup",
	"options_popup_latest_input_title": "If checked, Feedbro will show headlines of latest 10 unread articles in the popup when Feedbro icon is clicked",
	"options_mathjax_body": "MathJax enabled",
	"options_mathjax_input_title": "If checked, Feedbro will automatically render mathematical formulas in LaTeX and TeX in feed entries using MathJax. Note that this significantly affects performance. Feedbro only tries to render entries that contain certain $-based markup. This feature is only available on Chrome!",
	"options_justifytext_body": "Justify text in articles",
	"options_justifytext_input_title": "If checked, Feedbro will justify text in articles.",
	"options_skipopmldupes_body": "Skip existing OPML entries",
	"options_skipopmldupes_input_title": "If checked, Feedbro will skip feeds and folders that already exist when importing OPML",
	"options_truncatetitles_body": "Truncate long titles (view mode 2)",
	"options_truncatetitles_input_title": "If checked, Feedbro will truncate long titles in view mode 2",
	"options_disableheaderlistener_body": "Disable HTTP Header listener",
	"options_disableheaderlistener_input_title": "If checked, Feedbro may not be able to show websites in view mode 6 and received HTTP Link headers may create memory leaks. You need to restart the browser after changing this.",
	"options_goback_title": "Click to go back to Reader view",

	"options_error_bookmarks_noselection": "You must select at least one bookmark!",
	"options_error_bookmarks_invalidfile": "{1} is not a Firefox HTML bookmarks file!",
	"options_error_invalidopml": "Import failed! File {1} is not a valid OPML file.",
	"options_action_opmlimport_failed": "OPML import failed! Error: {1}",
	"options_action_opmlimport_success": "Done! Imported {1} feeds and {2} folders. Skipped {3} feeds and {4} folders.",
	"options_action_rulesimport_success": "Rules successfully imported!",
	"options_action_rulesimport_failed": "Rules import failed! Error: {1}",
	"options_action_delete_feedsandfolders": "Are you sure you want to remove all subscriptions and saved feed entries?",
	"options_action_delete_feedsandfolders_success": "All feed subscriptions and saved entries removed.",
	"options_action_delete_rules": "Are you sure you want to delete all Rules?",
	"options_action_delete_rules_success": "All Rules deleted.",

	"preview_error": "Unable to load feed preview",
	"preview_header": "Preview of the feed titled",
	"preview_loading": "Loading feed preview...",
	"preview_subscribe": "Subscribe",
	
	"ruleform_name_body": "Name",
	"ruleform_enabled_body": "Enabled",
	"ruleform_enabled_input_title": "If not checked, this rule is inactive",
	"ruleform_fallthrough_body": "Fallthrough",
	"ruleform_fallthrough_input_title": "If checked, other rules will be evaluated as well even if this rule matches (= slower performance). If not checked and this rule matches, no other rules will be evaluated (= better performance)",
	"ruleform_when_body": "When",
	"ruleform_trigger_new_body": "New article arrives",
	"ruleform_trigger_view_body": "Article is viewed",
	"ruleform_trigger_in_body": "in",
	"ruleform_trigger_any_body": "any feed",
	"ruleform_trigger_folder_body": "folder",
	"ruleform_trigger_feed_body": "feed",
	"ruleform_match_body": "Match",
	"ruleform_match_all_body": "All conditions",
	"ruleform_match_any_body": "Any condition",
	"ruleform_match_none_body": "None of the conditions",
	"ruleform_condition_name_body": "Condition",
	"ruleform_condition_remove_title": "Remove condition",
	"ruleform_condition_content_body": "Content",
	"ruleform_condition_author_body": "Author",
	"ruleform_condition_title_body": "Title",
	"ruleform_condition_url_body": "URL",
	"ruleform_condition_using_body": "using",
	"ruleform_condition_ignorecase_body": "case-insensitive",
	"ruleform_condition_ignorecase_title": "Ignore lowercase and uppercase differences in matching (less efficient)",
	"ruleform_condition_casesensitive_body": "case-sensitive",
	"ruleform_condition_casesensitive_title": "Match lowercase and uppercase letters (more efficient)",
	"ruleform_condition_matching_body": "matching",
	"ruleform_condition_add_body": "Add Condition",
	"ruleform_action_name_body": "Action",
	"ruleform_action_remove_title": "Remove action",
	"ruleform_action_notification_body": "Desktop notification",
	"ruleform_action_hide_body": "Hide article",
	"ruleform_action_delete_body": "Delete article",
	"ruleform_action_favorite_body": "Mark as favorite (star)",
	"ruleform_action_markread_body": "Mark as read",
	"ruleform_action_playsound_body": "Play sound",
	"ruleform_action_playsoundurl_body": "Play sound URL",
	"ruleform_action_highlightborder_body": "Highlight article border",
	"ruleform_action_highlighttext_body": "Highlight text in article with regexp",
	"ruleform_action_addtag_body": "Add a tag",
	"ruleform_action_ifttt_body": "IFTTT Maker Channel HTTP POST URL",
	"ruleform_action_ifttt_title": "Enter the full URL to your custom IFTTT Maker channel POST URL as a parameter.",
	"ruleform_action_points_body": "Add points",
	"ruleform_action_points_title": "Add or Subtract points from matching feed item. Total points are considered when using 'Sort by points' sorting.",
	"ruleform_action_discord_body": "Discord HTTP POST URL",
	"ruleform_action_discord_title": "Send article title and link to Discord channel",
	"ruleform_action_slack_body": "Slack HTTP POST URL",
	"ruleform_action_slack_title": "Send article title and link to Slack channel",
	"ruleform_action_add_body": "Add Action",
	"ruleform_delete_body": "Delete",
	"ruleform_delete_title": "Delete the rule permanently",
	"ruleform_cancel_body": "Cancel",
	"ruleform_cancel_title": "Close this window and exit without saving",
	"ruleform_save_body": "Save",
	"ruleform_save_title": "Save these settings as a rule",
	"ruleform_condition_contains_body": "contains text",
	"ruleform_condition_doesnotcontain_body": "doesn't contain text",
	"ruleform_condition_containswords_body": "contains all words",
	"ruleform_condition_containswords_title": "Separate words with a comma without spaces - example: foo,bar,xyz",
	"ruleform_condition_doesnotcontainwords_body": "doesn't contain words",
	"ruleform_condition_doesnotcontainwords_title": "Separate words with a comma without spaces - example: foo,bar,xyz",
	"ruleform_condition_containsanywords_body": "contains any of the words",
	"ruleform_condition_containsanywords_title": "Separate words with a comma without spaces - example: foo,bar,xyz",
	"ruleform_condition_containsanywordsthatstartwith_body": "contains any words that start with",
	"ruleform_condition_containsanywordsthatstartwith_title": "Separate prefixes with a comma without spaces - example: foo,bar,xyz",
	"ruleform_condition_matchesregexp_body": "matches regexp",
	"ruleform_condition_is_body": " = ",
	"ruleform_condition_isnot_body": " != ",
	"ruleform_condition_begins_body": "begins with text",
	"ruleform_condition_ends_body": "ends with text",

	"ruleview_name_body": "Rule",
	"ruleview_type_body": "Type",
	"ruleview_enabled_body": "Enabled",
	"ruleview_fallthrough_body": "Fallthrough",
	"ruleview_delete_confirm": "Do you really want to delete this rule?",
	"ruleview_error_name_missing": "Rule must have a name!",
	"ruleview_error_name_toolong": "Rule maximum length is 80 characters!",
	"ruleview_error_folder_missing": "At least one folder must be selected!",
	"ruleview_error_feed_missing": "At least one feed must be selected!",
	"ruleview_action_addrule_body": "Add Rule",
	"ruleview_action_testrules_body": "Test Rules",
	"ruleview_no_rules_yet_body": "No defined rules yet",
	"ruleview_table_row_title": "Drag and drop the row to change rule evaluation order",
	"ruleview_no_matches": "No rules matched",
	"ruleview_table_clickedit_title": "Click to edit Rule",
	"ruleview_table_arrive_title": "Evaluated when article arrives",
	"ruleview_table_view_title": "Evaluated when article is viewed",
	"ruleview_table_inactive_title": "If false, this rule is inactive and thus not in use",
	"ruleview_table_fallthrough_title": "If true, other rules will be also evaluated even if this rule matches. Less fallthrough rules = better performance",
	"ruleview_error_loading": "Rules failed to load. Please restart your browser.",
	"ruleview_error_hidearticle": "Error: 'Hide article' action is only valid when trigger is 'Article is viewed'",
	"ruleview_error_highlightborder": "Error: 'Highlight article border' action is only valid when trigger is 'Article is viewed'",
	"ruleview_error_highlightregexp": "Error: 'Highlight text in article with regexp' action is only valid when trigger is 'Article is viewed'",
	"ruleview_error_notification": "Error: 'Desktop notification' action is only valid when trigger is 'New article arrives'",
	"ruleview_error_addtag": "Error: 'Add a tag' action is only valid when trigger is 'New article arrives'",
	"ruleview_error_ifttt": "Error: 'IFTTT Maker Channel HTTP POST' action is only valid when trigger is 'New article arrives'",
	"ruleview_error_hidearticle_condition": "Error: 'Hide article' requires at least one condition (otherwise all articles are hidden)",
	"ruleview_error_delete_condition": "Error: 'Delete article' requires at least one condition (otherwise all articles are deleted)",
	"ruleview_error_addpoints": "Error: 'Add points' action is only valid when trigger is 'New article arrives'",
	"ruleview_error_emptyregexp": "Regexp cannot be empty!",
	"ruleview_error_emptytag": "Tag cannot be empty!",
	"ruleview_error_invalidpoints": "Argument to 'Add Points' must be a number (integer)!",
	"ruleview_error_ifttt_emptyurl": "IFTTT Maker Channel HTTP POST URL cannot be empty!",
	"ruleview_error_ifttt_invalidurl": "Invalid IFTTT Maker Channel URL! The URL must start with https://maker.ifttt.com",
	"ruleview_error_noaction": "Rule must have at least one action!",
	"ruleview_error_emptyplayurl": "Error: 'Play sound URL' requires a proper URL as parameter!",

	"savefeed_error_url": "You must enter a valid URL for the feed!",
	"savefeed_error_title": "You must enter a title for the feed. Either enter it manually or press 'Get' button to get the real feed title.",
	"savefeed_error_duplicate_infolder": "You have already subscribed that feed in folder '{1}' with the title '{2}'",
	"savefeed_error_duplicate": "You have already subscribed that feed with the title '{1}'",

	"sortorder_title": "Defines the order for showing feed items",
	"sortorder_points_body": "Sort by points",
	"sortorder_points_title": "Shows the items with the most points first. When points are equal, the newer item is shown first. Create a Rule under Rules menu to assign points to articles.",
	"sortorder_newest_body": "Sort by newest", 
	"sortorder_newest_title": "Shows the items in descending order by publish date",
	"sortorder_oldest_body": "Sort by oldest", 
	"sortorder_oldest_title": "Shows the items in ascending order by publish date",

	"startup_error_background": "Feedbro Background process failed to initialize. Please restart your browser. If that doesn't help, your Firefox profile may be corrupted and needs to be recreated in about:support. Note! Don't put Feedbro as one of the starting pages. This isn't supported.",
	"startup_error_indexeddb": "Failed to open IndexedDB database. Your browser profile is most likely broken. On Firefox open about:support and click 'Refresh Firefox' to fix it. Then restart your browser.",
	
	"statsview_no_feeds": "No subscribed feeds",
	"statsview_table_feedtitle": "Feed Title",
	"statsview_table_properties": "Properties",
	"statsview_table_latestupdate": "Latest Update",
	"statsview_table_status": "Status",
	"statsview_table_scandelay": "Scan Delay",
	"statsview_table_scandelay_title": "In minutes",
	"statsview_table_selected": "Selected",
	"statsview_table_rowclick_title": "Click to read entries",
	"statsview_table_days": "days",
	"statsview_table_default": "default",
	"statsview_button_deleteselected": "Delete Selected",
	"statsview_button_unselectall": "Unselect All",
	"statsview_confirm_delete": "Are you sure you want to remove selected {1} feeds?",

	"showarticles_nomatches": "No items that match current filter settings",
	"showarticles_noentries": "No entries to display",

	"tagview_articles_body": "Articles",
	"tagview_tag_body": "Tag",
	"tagview_notags_body": "No tags yet in any feed entries",
	"tagview_table_row_title": "Click to search with this keyword",

	"timeago_now": "now",
	"timeago_second": "second",
	"timeago_second_shortName": "s",
	"timeago_minute": "minute",
	"timeago_minute_shortName": "min",
	"timeago_hour": "hour",
	"timeago_hour_shortName": "h",
	"timeago_day": "day",
	"timeago_day_shortName": "d",
	"timeago_week": "week",
	"timeago_week_shortName": "w",
	"timeago_month": "month",
	"timeago_month_shortName": "m",
	"timeago_year": "year",
	"timeago_year_shortName": "y",
	"timeago_second_plural": "seconds",
	"timeago_minute_plural": "minutes",
	"timeago_hour_plural": "hours",
	"timeago_day_plural": "days",
	"timeago_week_plural": "weeks",
	"timeago_month_plural": "months",
	"timeago_year_plural": "years",
	
	"toolbar_hidetree_title": "Hide/show feed tree - Shortcut 'w'", 
	"toolbar_refresh_title": "Refresh all feeds by polling the feed sources (XML) - Note that you don't have to do this. Feedbro scans feeds automatically in the background all the time based on the intervals you have defined.", 
	"toolbar_support_title": "Please Support Feedbro Development", 
	"toolbar_findfeed_title": "Find a new feed", 
	"toolbar_addfeed_title": "Add a new feed", 
	"toolbar_addfolder_title": "Add a new folder", 
	"toolbar_markread_title": "Mark all feed entries in currently selected feed or folder as read - Shortcut 'Shift + a'",
	"toolbar_unread_title": "Show only unread articles (when highlighted) - Shortcut 'u'",
	"toolbar_viewmode1_title": "View mode 1: List of full articles - Shortcut '1'",
	"toolbar_viewmode2_title": "View mode 2: List of article headlines (click to open) - Shortcut '2'",
	"toolbar_viewmode3_title": "View mode 3: List of article titles + selected article (like Opera RSS reader) - Shortcut '3'",
	"toolbar_viewmode4_title": "View mode 4: Newspaper mode: title + summary + picture (click to open) - Shortcut '4'",
	"toolbar_viewmode5_title": "View mode 5: Magazine mode: title + picture + summary (click to open) - Shortcut '5'",
	"toolbar_viewmode6_title": "View mode 6: List of article titles + selected article embedded in iframe from the original site (note! some sites prevent embedding!) - Shortcut '6'",
	"toolbar_help_title": "Feedbro Help page",
	"toolbar_options_title": "Open Feedbro Options/Settings page",
	"toolbar_reload_title": "Reload currently selected feed or folder from the local database (not feed source) - Shortcut 'r'",
	"toolbar_prev_title": "Previous item - Shortcut 'k' or 'p'",
	"toolbar_next_title": "Next item - Shortcut 'j' or 'n'"
};