/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.i2p.I2PAppContext;
import net.i2p.crypto.HMACGenerator;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import org.bouncycastle.oldcrypto.macs.I2PHMac;

public final class HMAC256Generator
extends HMACGenerator {
    public HMAC256Generator(I2PAppContext context) {
        super(context);
    }

    @Override
    protected I2PHMac acquire() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Hash calculate(SessionKey key, byte[] data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void calculate(SessionKey key, byte[] data, int offset, int length, byte[] target, int targetOffset) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec keyObj = new SecretKeySpec(key.getData(), "HmacSHA256");
            mac.init(keyObj);
            mac.update(data, offset, length);
            mac.doFinal(target, targetOffset);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("HmacSHA256", e);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("HmacSHA256", e);
        }
    }

    @Override
    public boolean verify(SessionKey key, byte[] curData, int curOffset, int curLength, byte[] origMAC, int origMACOffset, int origMACLength) {
        byte[] calc = this.acquireTmp();
        this.calculate(key, curData, curOffset, curLength, calc, 0);
        boolean eq = DataHelper.eq(calc, 0, origMAC, origMACOffset, origMACLength);
        this.releaseTmp(calc);
        return eq;
    }
}

