/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.RandomSource;
import net.i2p.util.SimpleByteCache;
import net.i2p.util.SipHash;

public class SessionTag
extends SimpleDataStructure {
    public static final int BYTE_LENGTH = 32;
    private int _cachedHashCode;

    public SessionTag() {
    }

    public SessionTag(boolean create) {
        if (create) {
            this._data = SimpleByteCache.acquire(32);
            RandomSource.getInstance().nextBytes(this._data);
            this._cachedHashCode = SipHash.hashCode(this._data);
        }
    }

    public SessionTag(byte[] val) {
        super(val);
    }

    @Override
    public int length() {
        return 32;
    }

    @Override
    public void setData(byte[] data) {
        super.setData(data);
        this._cachedHashCode = SipHash.hashCode(data);
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        super.readBytes(in);
        this._cachedHashCode = SipHash.hashCode(this._data);
    }

    @Override
    public int hashCode() {
        return this._cachedHashCode;
    }
}

