/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;

public class SessionId
extends DataStructureImpl {
    private int _sessionId;

    public SessionId() {
        this._sessionId = -1;
    }

    public SessionId(int id) {
        if (id < 0 || id > 65535) {
            throw new IllegalArgumentException();
        }
        this._sessionId = id;
    }

    public int getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(int id) {
        if (id < 0 || id > 65535) {
            throw new IllegalArgumentException();
        }
        if (this._sessionId >= 0) {
            throw new IllegalStateException();
        }
        this._sessionId = id;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._sessionId >= 0) {
            throw new IllegalStateException();
        }
        this._sessionId = (int)DataHelper.readLong(in, 2);
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._sessionId < 0) {
            throw new DataFormatException("Invalid session ID: " + this._sessionId);
        }
        DataHelper.writeLong(out, 2, this._sessionId);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SessionId)) {
            return false;
        }
        return this._sessionId == ((SessionId)obj)._sessionId;
    }

    public int hashCode() {
        return 777 * this._sessionId;
    }

    public String toString() {
        return "[SessionId: " + this._sessionId + "]";
    }
}

