/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class LookaheadInputStream
extends FilterInputStream {
    private boolean _eofReached;
    private final byte[] _footerLookahead;
    private static final InputStream _fakeInputStream = new ByteArrayInputStream(new byte[0]);

    public LookaheadInputStream(int lookaheadSize) {
        super(_fakeInputStream);
        this._footerLookahead = new byte[lookaheadSize];
    }

    public boolean getEOFReached() {
        return this._eofReached;
    }

    public void initialize(InputStream src) throws IOException {
        int read;
        this.in = src;
        this._eofReached = false;
        Arrays.fill(this._footerLookahead, (byte)0);
        for (int footerRead = 0; footerRead < this._footerLookahead.length; footerRead += read) {
            read = this.in.read(this._footerLookahead, footerRead, this._footerLookahead.length - footerRead);
            if (read != -1) continue;
            throw new IOException("EOF reading the footer lookahead");
        }
    }

    @Override
    public int read() throws IOException {
        if (this._eofReached) {
            return -1;
        }
        int c = this.in.read();
        if (c == -1) {
            this._eofReached = true;
            return -1;
        }
        int rv = this._footerLookahead[0];
        System.arraycopy(this._footerLookahead, 1, this._footerLookahead, 0, this._footerLookahead.length - 1);
        this._footerLookahead[this._footerLookahead.length - 1] = (byte)c;
        if (rv < 0) {
            rv += 256;
        }
        return rv;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this._eofReached) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            buf[off + i] = (byte)c;
        }
        return len;
    }

    public byte[] getFooter() {
        return this._footerLookahead;
    }
}

