/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public final class SimpleByteCache {
    private static final ConcurrentHashMap<Integer, SimpleByteCache> _caches = new ConcurrentHashMap(8);
    private static final int DEFAULT_SIZE = 64;
    private static final int MAX_FOR_ABQ = 64;
    private Queue<byte[]> _available;
    private int _maxCached;
    private final int _entrySize;

    public static SimpleByteCache getInstance(int size) {
        return SimpleByteCache.getInstance(64, size);
    }

    public static SimpleByteCache getInstance(int cacheSize, int size) {
        SimpleByteCache old;
        Integer sz = size;
        SimpleByteCache cache = _caches.get(sz);
        if (cache == null && (old = _caches.putIfAbsent(sz, cache = new SimpleByteCache(cacheSize, size))) != null) {
            cache = old;
        }
        cache.resize(cacheSize);
        return cache;
    }

    public static void clearAll() {
        for (SimpleByteCache bc : _caches.values()) {
            bc.clear();
        }
    }

    private SimpleByteCache(int maxCachedEntries, int entrySize) {
        this._maxCached = maxCachedEntries;
        this._available = this.createQueue();
        this._entrySize = entrySize;
    }

    private void resize(int maxCachedEntries) {
        byte[] ba;
        if (this._maxCached >= maxCachedEntries) {
            return;
        }
        this._maxCached = maxCachedEntries;
        Queue<byte[]> newLBQ = this.createQueue();
        while ((ba = this._available.poll()) != null) {
            newLBQ.offer(ba);
        }
        this._available = newLBQ;
    }

    private Queue<byte[]> createQueue() {
        if (this._entrySize <= 64) {
            return new ArrayBlockingQueue<byte[]>(this._maxCached);
        }
        return new LinkedBlockingQueue<byte[]>(this._maxCached);
    }

    public static byte[] acquire(int size) {
        return SimpleByteCache.getInstance(size).acquire();
    }

    private byte[] acquire() {
        byte[] rv = this._available.poll();
        if (rv == null) {
            rv = new byte[this._entrySize];
        }
        return rv;
    }

    public static void release(byte[] entry) {
        SimpleByteCache cache = _caches.get(entry.length);
        if (cache != null) {
            cache.releaseIt(entry);
        }
    }

    private void releaseIt(byte[] entry) {
        if (entry == null || entry.length != this._entrySize) {
            return;
        }
        this._available.offer(entry);
    }

    private void clear() {
        this._available.clear();
    }
}

