/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client;

import com.peersafe.base.client.Account;
import com.peersafe.base.client.enums.Command;
import com.peersafe.base.client.enums.Message;
import com.peersafe.base.client.enums.RPCErr;
import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.client.requests.Request;
import com.peersafe.base.client.responses.Response;
import com.peersafe.base.client.subscriptions.ServerInfo;
import com.peersafe.base.client.subscriptions.SubscriptionManager;
import com.peersafe.base.client.subscriptions.TrackedAccountRoot;
import com.peersafe.base.client.subscriptions.TransactionSubscriptionManager;
import com.peersafe.base.client.transactions.AccountTxPager;
import com.peersafe.base.client.transactions.TransactionManager;
import com.peersafe.base.client.transport.TransportEventHandler;
import com.peersafe.base.client.transport.WebSocketTransport;
import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Issue;
import com.peersafe.base.core.coretypes.STObject;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.types.known.sle.LedgerEntry;
import com.peersafe.base.core.types.known.sle.entries.Offer;
import com.peersafe.base.core.types.known.tx.result.TransactionResult;
import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.crypto.ecdsa.Seed;
import com.peersafe.chainsql.util.Util;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Client
extends Publisher<events>
implements TransportEventHandler {
    public static final Logger logger = Logger.getLogger(Client.class.getName());
    WebSocketTransport ws;
    public double randomBugsFrequency = 0.0;
    Random randomBugs = new Random();
    TransactionSubscriptionManager transactionSubscriptionManager;
    protected ScheduledExecutorService service;
    protected Thread clientThread;
    protected TreeMap<Integer, Request> requests = new TreeMap();
    private int cmdIDs;
    String previousUri;
    public long maintenanceSchedule = 10000L;
    public int SEQUENCE;
    public String NAMEINDB = "";
    public boolean connected = false;
    private long reconnectDormantAfter = 300000L;
    private long lastConnection = -1L;
    private boolean manuallyDisconnected = false;
    public ServerInfo serverInfo = new ServerInfo();
    private HashMap<AccountID, Account> accounts = new HashMap();
    public SubscriptionManager subscriptions = new SubscriptionManager();
    private static final int MAX_REQUEST_COUNT = 10;
    private ScheduledFuture reconnect_future = null;
    private boolean reconnecting = false;

    public Client onValidatedTransaction(OnValidatedTransaction cb) {
        this.on(OnValidatedTransaction.class, cb);
        return this;
    }

    public Client onLedgerClosed(OnLedgerClosed cb) {
        this.on(OnLedgerClosed.class, cb);
        return this;
    }

    public Client OnTBMessage(OnTBMessage cb) {
        this.on(OnTBMessage.class, cb);
        return this;
    }

    public Client OnSubChainsqlRet(OnChainsqlSubRet cb) {
        this.on(OnChainsqlSubRet.class, cb);
        return this;
    }

    public Client OnTXMessage(OnTXMessage cb) {
        this.on(OnTXMessage.class, cb);
        return this;
    }

    public Client OnMessage(OnMessage cb) {
        this.on(OnMessage.class, cb);
        return this;
    }

    public Client onReconnecting(OnReconnecting cb) {
        this.on(OnReconnecting.class, cb);
        return this;
    }

    public Client onReconnected(OnReconnected cb) {
        this.on(OnReconnected.class, cb);
        return this;
    }

    public Client onConnected(OnConnected onConnected) {
        this.on(OnConnected.class, onConnected);
        return this;
    }

    public Client onDisconnected(OnDisconnected cb) {
        this.on(OnDisconnected.class, cb);
        return this;
    }

    public Client onContractEvent(OnContractEvent cb) {
        this.on(OnContractEvent.class, cb);
        return this;
    }

    public Client(WebSocketTransport ws) {
        this.ws = ws;
        ws.setHandler(this);
        this.prepareExecutor();
        this.scheduleMaintenance();
        this.subscriptions.on(SubscriptionManager.OnSubscribed.class, new SubscriptionManager.OnSubscribed(){

            @Override
            public void called(JSONObject subscription) {
                if (!Client.this.connected) {
                    return;
                }
                Client.this.subscribe(subscription);
            }
        });
    }

    private int reconnectDelay() {
        return 2000;
    }

    public Client transactionSubscriptionManager(TransactionSubscriptionManager transactionSubscriptionManager) {
        this.transactionSubscriptionManager = transactionSubscriptionManager;
        return this;
    }

    public static void log(Level level, String fmt, Object ... args) {
        if (logger.isLoggable(level)) {
            logger.log(level, fmt, args);
        }
    }

    public static String prettyJSON(JSONObject object) {
        return object.toString(4);
    }

    public static JSONObject parseJSON(String s) {
        return new JSONObject(s);
    }

    public Client connect(final String uri) {
        this.manuallyDisconnected = false;
        this.schedule(50L, new Runnable(){

            @Override
            public void run() {
                Client.this.doConnect(uri);
            }
        });
        return this;
    }

    public Client connect(final String uri, final String serverCertPath, final String storePass) {
        this.manuallyDisconnected = false;
        this.schedule(50L, new Runnable(){

            @Override
            public void run() {
                try {
                    Client.this.doConnect(uri, serverCertPath, storePass);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return this;
    }

    public void doConnect(String uri) {
        Client.log(Level.INFO, "Connecting to " + uri, new Object[0]);
        this.previousUri = uri;
        this.ws.connect(URI.create(uri));
    }

    public void doConnect(String uri, String serverCertPath, String storePass) throws Exception {
        Client.log(Level.INFO, "Connecting to " + uri, new Object[0]);
        this.previousUri = uri;
        this.ws.connectSSL(URI.create(uri), serverCertPath, storePass);
    }

    public void disconnect() {
        this.manuallyDisconnected = true;
        this.disconnectInner();
        this.service.shutdownNow();
    }

    private void disconnectInner() {
        this.ws.disconnect();
    }

    private void emitOnDisconnected() {
        this.emit(OnDisconnected.class, this);
    }

    private void scheduleMaintenance() {
        this.schedule(this.maintenanceSchedule, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long time;
                    long msSince;
                    Client.this.manageTimedOutRequests();
                    int defaultValue = -1;
                    if (!Client.this.manuallyDisconnected && Client.this.connected && Client.this.lastConnection != (long)defaultValue && (msSince = (time = new Date().getTime()) - Client.this.lastConnection) > Client.this.reconnectDormantAfter) {
                        Client.this.lastConnection = defaultValue;
                        Client.this.reconnect();
                    }
                }
                finally {
                    Client.this.scheduleMaintenance();
                }
            }
        });
    }

    public void reconnect() {
        if (this.reconnecting) {
            return;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.emit(OnReconnecting.class, null);
        Client.log(Level.INFO, "reconnecting", new Object[0]);
        this.reconnecting = true;
        this.reconnect_future = this.service.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Client.this.disconnectInner();
                Client.this.doConnect(Client.this.previousUri);
            }
        }, 0L, 2000L, TimeUnit.MILLISECONDS);
    }

    void manageTimedOutRequests() {
        long now = System.currentTimeMillis();
        ArrayList<Request> timedOut = new ArrayList<Request>();
        for (Request request : this.requests.values()) {
            long since;
            if (request.sendTime == 0L || (since = now - request.sendTime) < 120000L) continue;
            timedOut.add(request);
        }
        for (Request request : timedOut) {
            request.emit(Request.OnTimeout.class, request.response);
            this.requests.remove(request.id);
        }
    }

    public void connect(final String s, final OnConnected onConnected) {
        this.run(new Runnable(){

            @Override
            public void run() {
                Client.this.connect(s);
                Client.this.once(OnConnected.class, onConnected);
            }
        });
    }

    public void disconnect(final OnDisconnected onDisconnected) {
        this.run(new Runnable(){

            @Override
            public void run() {
                Client.this.once(OnDisconnected.class, onDisconnected);
                Client.this.disconnect();
            }
        });
    }

    public void whenConnected(boolean nextTick, final OnConnected onConnected) {
        if (this.connected) {
            if (nextTick) {
                this.schedule(0L, new Runnable(){

                    @Override
                    public void run() {
                        onConnected.called(Client.this);
                    }
                });
            } else {
                onConnected.called(this);
            }
        } else {
            this.once(OnConnected.class, onConnected);
        }
    }

    public void nowOrWhenConnected(OnConnected onConnected) {
        this.whenConnected(false, onConnected);
    }

    public void nextTickOrWhenConnected(OnConnected onConnected) {
        this.whenConnected(true, onConnected);
    }

    public void dispose() {
        this.ws = null;
    }

    public void run(Runnable runnable) {
        if (this.runningOnClientThread()) {
            runnable.run();
        } else {
            this.service.submit(this.errorHandling(runnable));
        }
    }

    public void schedule(long ms, Runnable runnable) {
        this.service.schedule(this.errorHandling(runnable), ms, TimeUnit.MILLISECONDS);
    }

    private boolean runningOnClientThread() {
        return this.clientThread != null && Thread.currentThread().getId() == this.clientThread.getId();
    }

    protected void prepareExecutor() {
        this.service = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Client.this.clientThread = new Thread(r);
                return Client.this.clientThread;
            }
        });
    }

    private Runnable errorHandling(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    Client.this.onException(e);
                }
            }
        };
    }

    protected void onException(Exception e) {
        e.printStackTrace(System.out);
        if (logger.isLoggable(Level.WARNING)) {
            Client.log(Level.WARNING, "Exception {0}", e);
        }
    }

    private void resetReconnectStatus() {
        this.lastConnection = new Date().getTime();
    }

    private void updateServerInfo(JSONObject msg) {
        this.serverInfo.update(msg);
    }

    @Override
    public void onMessage(final JSONObject msg) {
        this.resetReconnectStatus();
        this.run(new Runnable(){

            @Override
            public void run() {
                Client.this.onMessageInClientThread(msg);
            }
        });
    }

    @Override
    public void onConnecting(int attempt) {
    }

    @Override
    public void onError(Exception error) {
        this.onException(error);
    }

    @Override
    public void onDisconnected(boolean willReconnect) {
        this.run(new Runnable(){

            @Override
            public void run() {
                Client.this.doOnDisconnected();
            }
        });
    }

    @Override
    public void onConnected() {
        this.run(new Runnable(){

            @Override
            public void run() {
                Client.this.doOnConnected();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessageInClientThread(JSONObject msg) {
        String str = msg.optString("type", null);
        Message type = Message.valueOf(str);
        try {
            this.emit(OnMessage.class, msg);
            if (logger.isLoggable(Level.FINER)) {
                Client.log(Level.FINER, "Receive `{0}`: {1}", new Object[]{type, Client.prettyJSON(msg)});
            }
            switch (type) {
                case serverStatus: {
                    this.updateServerInfo(msg);
                    return;
                }
                case ledgerClosed: {
                    this.updateServerInfo(msg);
                    this.emit(OnLedgerClosed.class, this.serverInfo);
                    return;
                }
                case response: {
                    this.onResponse(msg);
                    return;
                }
                case transaction: {
                    this.onTransaction(msg);
                    return;
                }
                case path_find: {
                    this.emit(OnPathFind.class, msg);
                    return;
                }
                case singleTransaction: {
                    this.emit(OnTXMessage.class, msg);
                    return;
                }
                case table: {
                    this.emit(OnTBMessage.class, msg);
                    return;
                }
                case contract_event: {
                    this.emit(OnContractEvent.class, msg);
                    return;
                }
                default: {
                    this.unhandledMessage(msg);
                    return;
                }
            }
        }
        catch (Exception exception) {
            return;
        }
        finally {
            this.emit(OnStateChange.class, this);
        }
    }

    private void doOnDisconnected() {
        Client.log(Level.INFO, this.getClass().getName() + ": doOnDisconnected", new Object[0]);
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.emitOnDisconnected();
        if (!this.manuallyDisconnected) {
            this.reconnect();
        } else {
            Client.log(Level.INFO, "Currently disconnecting, so will not reconnect", new Object[0]);
        }
    }

    private void doOnConnected() {
        this.resetReconnectStatus();
        logger.entering(this.getClass().getName(), "doOnConnected");
        this.connected = true;
        this.emit(OnConnected.class, this);
        if (this.reconnecting) {
            Client.log(Level.INFO, "reconnected", new Object[0]);
            this.reconnecting = false;
            this.emit(OnReconnected.class, null);
            this.reconnect_future.cancel(true);
            this.reconnect_future = null;
        }
        this.subscribe(this.prepareSubscription());
        logger.exiting(this.getClass().getName(), "doOnConnected");
    }

    void unhandledMessage(JSONObject msg) {
        Client.log(Level.WARNING, "Unhandled message: " + msg, new Object[0]);
    }

    synchronized void onResponse(JSONObject msg) {
        Request request = this.requests.remove(msg.optInt("id", -1));
        if (request == null) {
            Client.log(Level.WARNING, "Response without a request: {0}", msg);
            return;
        }
        request.handleResponse(msg);
    }

    void onTransaction(JSONObject msg) {
        TransactionResult tr = new TransactionResult(msg, TransactionResult.Source.transaction_subscription_notification);
        if (tr.validated) {
            if (this.transactionSubscriptionManager != null) {
                this.transactionSubscriptionManager.notifyTransactionResult(tr);
            } else {
                this.onTransactionResult(tr);
            }
        }
    }

    public void onTransactionResult(TransactionResult tr) {
        Account initator;
        Client.log(Level.INFO, "Transaction {0} is validated", tr.hash);
        Map<AccountID, STObject> affected = tr.modifiedRoots();
        if (affected != null) {
            Hash256 transactionHash = tr.hash;
            UInt32 transactionLedgerIndex = tr.ledgerIndex;
            for (Map.Entry<AccountID, STObject> entry : affected.entrySet()) {
                Account account = this.accounts.get(entry.getKey());
                if (account == null) continue;
                STObject rootUpdates = entry.getValue();
                account.getAccountRoot().updateFromTransaction(transactionHash, transactionLedgerIndex, rootUpdates);
            }
        }
        if ((initator = this.accounts.get(tr.initiatingAccount())) != null) {
            Client.log(Level.INFO, "Found initiator {0}, notifying transactionManager", initator);
            initator.transactionManager().notifyTransactionResult(tr);
        } else {
            Client.log(Level.INFO, "Can't find initiating account!", new Object[0]);
        }
        this.emit(OnValidatedTransaction.class, tr);
    }

    private void sendMessage(JSONObject object) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Send: {0}", Client.prettyJSON(object));
        }
        this.emit(OnSendMessage.class, object);
        this.ws.sendMessage(object);
        if (this.randomBugsFrequency != 0.0 && this.randomBugs.nextDouble() > 1.0 - this.randomBugsFrequency) {
            this.disconnect();
            this.connect(this.previousUri);
            String msg = "I disconnected you, now I'm gonna throw, deal with it suckah! ;)";
            logger.warning(msg);
            throw new RuntimeException(msg);
        }
    }

    public Account accountFromSeed(String masterSeed) {
        IKeyPair kp = Seed.fromBase58(masterSeed).keyPair();
        return this.account(AccountID.fromKeyPair(kp), kp);
    }

    private Account account(AccountID id, IKeyPair keyPair) {
        if (this.accounts.containsKey(id)) {
            return this.accounts.get(id);
        }
        TrackedAccountRoot accountRoot = this.accountRoot(id);
        Account account = new Account(id, keyPair, accountRoot, new TransactionManager(this, accountRoot, id, keyPair));
        this.accounts.put(id, account);
        this.subscriptions.addAccount(id);
        return account;
    }

    private TrackedAccountRoot accountRoot(AccountID id) {
        TrackedAccountRoot accountRoot = new TrackedAccountRoot();
        this.requestAccountRoot(id, accountRoot);
        return accountRoot;
    }

    private void requestAccountRoot(final AccountID id, final TrackedAccountRoot accountRoot) {
        this.makeManagedRequest(Command.ledger_entry, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return r == null || r.rpcerr == null || r.rpcerr != RPCErr.entryNotFound;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    accountRoot.setFromJSON(jsonObject);
                } else {
                    Client.log(Level.INFO, "Unfunded account: {0}", response.message);
                    accountRoot.setUnfundedAccount(id);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("account_root", id);
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                return response.result.getJSONObject("node");
            }
        });
    }

    private void subscribe(JSONObject subscription) {
        Request request = this.newRequest(Command.subscribe);
        request.json(subscription);
        request.on(Request.OnSuccess.class, new Request.OnSuccess(){

            @Override
            public void called(Response response) {
                JSONObject req = response.request.json();
                if (req.has("streams")) {
                    Client.this.serverInfo.update(response.result);
                    Client.this.emit(OnSubscribed.class, Client.this.serverInfo);
                }
            }
        });
        request.on(Request.OnResponse.class, new Request.OnResponse(){

            @Override
            public void called(Response response) {
                JSONObject req = response.request.json();
                if (req.has("transaction") || req.has("owner") && req.has("tablename")) {
                    JSONObject obj = new JSONObject();
                    if (req.has("transaction")) {
                        obj.put("transaction", (Object)req.getString("transaction"));
                    }
                    if (req.has("owner")) {
                        obj.put("owner", (Object)req.getString("owner"));
                    }
                    if (req.has("tablename")) {
                        obj.put("tablename", (Object)req.getString("tablename"));
                    }
                    obj.put("result", (Object)response.message);
                    Client.this.emit(OnChainsqlSubRet.class, obj);
                }
            }
        });
        request.request();
    }

    private JSONObject prepareSubscription() {
        this.subscriptions.pauseEventEmissions();
        this.subscriptions.addStream(SubscriptionManager.Stream.ledger);
        this.subscriptions.addStream(SubscriptionManager.Stream.server);
        this.subscriptions.unpauseEventEmissions();
        return this.subscriptions.allSubscribed();
    }

    public synchronized Request newRequest(Command cmd) {
        return new Request(cmd, this.cmdIDs++, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(final Request request) {
        Logger reqLog = Request.logger;
        try {
            TreeMap<Integer, Request> treeMap = this.requests;
            synchronized (treeMap) {
                this.requests.put(request.id, request);
            }
            request.bumpSendTime();
            this.sendMessage(request.toJSON());
        }
        catch (Exception e) {
            if (reqLog.isLoggable(Level.WARNING)) {
                reqLog.log(Level.WARNING, "Exception when trying to request: {0}", e);
            }
            this.nextTickOrWhenConnected(new OnConnected(){

                @Override
                public void called(Client args) {
                    Client.this.sendRequest(request);
                }
            });
        }
    }

    public <T> Request makeManagedRequest(Command cmd, Request.Manager<T> manager, Request.Builder<T> builder) {
        return this.makeManagedRequest(cmd, manager, builder, 0);
    }

    private <T> Request makeManagedRequest(final Command cmd, final Request.Manager<T> manager, final Request.Builder<T> builder, final int depth) {
        if (depth > 10) {
            return null;
        }
        final Request request = this.newRequest(cmd);
        final boolean[] responded = new boolean[]{false};
        request.once(Request.OnTimeout.class, new Request.OnTimeout(){

            @Override
            public void called(Response args) {
                System.out.println("timeout");
                if (!responded[0] && manager.retryOnUnsuccessful(null)) {
                    Client.this.logRetry(request, "Request timed out");
                    request.clearAllListeners();
                    Client.this.queueRetry(50, cmd, manager, builder, depth);
                } else {
                    JSONObject msg = new JSONObject();
                    msg.put("status", (Object)"error");
                    msg.put("error", (Object)"timeOutError");
                    msg.put("error_message", (Object)("Request for command:" + cmd.toString() + " time out!"));
                    Response response = new Response(request, msg);
                    manager.cb(response, null);
                }
            }
        });
        final OnDisconnected cb = new OnDisconnected(){

            @Override
            public void called(Client c) {
                if (!responded[0] && manager.retryOnUnsuccessful(null)) {
                    Client.this.logRetry(request, "Client disconnected");
                    request.clearAllListeners();
                    Client.this.queueRetry(50, cmd, manager, builder, depth);
                }
            }
        };
        this.once(OnDisconnected.class, cb);
        request.once(Request.OnResponse.class, new Request.OnResponse(){

            @Override
            public void called(Response response) {
                responded[0] = true;
                Client.this.removeListener(OnDisconnected.class, cb);
                if (response.succeeded) {
                    Object t = builder.buildTypedResponse(response);
                    manager.cb(response, t);
                } else if (manager.retryOnUnsuccessful(response)) {
                    Client.this.queueRetry(50, cmd, manager, builder, depth);
                } else {
                    manager.cb(response, null);
                }
            }
        });
        builder.beforeRequest(request);
        manager.beforeRequest(request);
        request.request();
        return request;
    }

    private <T> void queueRetry(int ms, final Command cmd, final Request.Manager<T> manager, final Request.Builder<T> builder, final int depth) {
        this.schedule(ms, new Runnable(){

            @Override
            public void run() {
                Client.this.makeManagedRequest(cmd, manager, builder, depth + 1);
            }
        });
    }

    private void logRetry(Request request, String reason) {
        if (logger.isLoggable(Level.WARNING)) {
            Client.log(Level.WARNING, this.previousUri + ": " + reason + ", muting listeners for " + request.json() + "and trying again", new Object[0]);
        }
    }

    public AccountTxPager accountTxPager(AccountID accountID) {
        return new AccountTxPager(this, accountID, null);
    }

    public void requestLedgerEntry(final Hash256 index, final Number ledger_index, Request.Manager<LedgerEntry> cb) {
        this.makeManagedRequest(Command.ledger_entry, cb, new Request.Builder<LedgerEntry>(){

            @Override
            public void beforeRequest(Request request) {
                if (ledger_index != null) {
                    request.json("ledger_index", Client.this.ledgerIndex(ledger_index));
                }
                request.json("index", index.toJSON());
            }

            @Override
            public LedgerEntry buildTypedResponse(Response response) {
                String node_binary = response.result.optString("node_binary");
                STObject node = (STObject)STObject.translate.fromHex(node_binary);
                node.put(Hash256.index, index);
                return (LedgerEntry)node;
            }
        });
    }

    private Object ledgerIndex(Number ledger_index) {
        long l = ledger_index.longValue();
        if (l == -3L) {
            return "validated";
        }
        return l;
    }

    public void requestBookOffers(final Number ledger_index, final Issue get, final Issue pay, Request.Manager<ArrayList<Offer>> cb) {
        this.makeManagedRequest(Command.book_offers, cb, new Request.Builder<ArrayList<Offer>>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("taker_gets", get.toJSON());
                request.json("taker_pays", pay.toJSON());
                if (ledger_index != null) {
                    request.json("ledger_index", ledger_index);
                }
            }

            @Override
            public ArrayList<Offer> buildTypedResponse(Response response) {
                ArrayList<Offer> offers = new ArrayList<Offer>();
                JSONArray offersJson = response.result.getJSONArray("offers");
                for (int i = 0; i < offersJson.length(); ++i) {
                    JSONObject jsonObject = offersJson.getJSONObject(i);
                    STObject object = STObject.fromJSONObject(jsonObject);
                    offers.add((Offer)object);
                }
                return offers;
            }
        });
    }

    public Request submit(String tx_blob, boolean fail_hard) {
        Request req = this.newRequest(Command.submit);
        req.json("tx_blob", tx_blob);
        req.json("fail_hard", fail_hard);
        return req;
    }

    public JSONObject accountInfo(AccountID account) {
        Request request = this.newRequest(Command.account_info);
        request.json("account", account.address);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public JSONObject select(final String secret, AccountID account, AccountID owner, String name, String raw, final Publisher.Callback<JSONObject> cb) {
        String tablestr = "{\"Table\":{\"TableName\":\"" + name + "\"}}";
        JSONArray tableArray = Util.strToJSONArray(tablestr);
        final JSONObject txjson = new JSONObject();
        txjson.put("Account", (Object)account);
        txjson.put("Owner", (Object)owner);
        txjson.put("Tables", (Object)tableArray);
        txjson.put("Raw", (Object)raw);
        if (cb != null) {
            this.getLedgerVersion(new Publisher.Callback<JSONObject>(){

                @Override
                public void called(JSONObject args) {
                    if (args.has("ledger_current_index")) {
                        txjson.put("LedgerIndex", args.getInt("ledger_current_index") - 1);
                    }
                    Client.this.selectASync(Command.r_get, secret, txjson, cb);
                }
            });
            JSONObject obj = new JSONObject();
            obj.put("final_result", true);
            return obj;
        }
        return this.selectSync(secret, txjson);
    }

    private void prepareRequestForSelect(Request request, String secret, JSONObject txjson) {
        String signData = txjson.toString();
        byte[] signature = Util.sign(signData.getBytes(), secret);
        request.json("tx_json", txjson);
        request.json("publicKey", Util.getPublicHexFromSecret(secret));
        request.json("signature", Util.bytesToHex(signature));
        request.json("signingData", signData);
    }

    private JSONObject selectSync(String secret, JSONObject txjson) {
        JSONObject ledger = this.getLedgerVersion();
        if (!ledger.has("ledger_current_index")) {
            return ledger;
        }
        txjson.put("LedgerIndex", ledger.getInt("ledger_current_index") - 1);
        Request request = this.newRequest(Command.r_get);
        this.prepareRequestForSelect(request, secret, txjson);
        request.request();
        this.waiting(request);
        JSONObject res = this.getResult(request);
        return this.getSelectRes(res);
    }

    private void selectASync(Command command, final String secret, final JSONObject txjson, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(command, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                Client.this.prepareRequestForSelect(request, secret, txjson);
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                return Client.this.getSelectRes(response.result);
            }
        });
    }

    private JSONObject getSelectRes(JSONObject result) {
        JSONObject obj = new JSONObject();
        if (!result.has("error")) {
            if (result.has("diff")) {
                obj.put("diff", result.getInt("diff"));
            }
            if (obj.has("lines")) {
                obj.put("lines", result.get("lines"));
            } else {
                obj = result;
            }
        } else {
            obj = result;
        }
        obj.put("final_result", true);
        return obj;
    }

    public JSONObject getBySqlUser(String secret, String accountID, String sql) {
        JSONObject tx_json = new JSONObject();
        tx_json.put("Account", (Object)accountID);
        tx_json.put("Sql", (Object)sql);
        JSONObject ledger = this.getLedgerVersion();
        if (!ledger.has("ledger_current_index")) {
            return ledger;
        }
        tx_json.put("LedgerIndex", ledger.getInt("ledger_current_index") - 1);
        Request request = this.newRequest(Command.r_get_sql_user);
        this.prepareRequestForSelect(request, secret, tx_json);
        request.request();
        this.waiting(request);
        JSONObject res = this.getResult(request);
        return this.getSelectRes(res);
    }

    public void getBySqlUser(final String secret, final String accountID, final String sql, final Publisher.Callback<JSONObject> cb) {
        this.getLedgerVersion(new Publisher.Callback<JSONObject>(){

            @Override
            public void called(JSONObject args) {
                JSONObject tx_json = new JSONObject();
                tx_json.put("Account", (Object)accountID);
                tx_json.put("Sql", (Object)sql);
                if (args.has("ledger_current_index")) {
                    tx_json.put("LedgerIndex", args.getInt("ledger_current_index") - 1);
                }
                Client.this.selectASync(Command.r_get_sql_user, secret, tx_json, cb);
            }
        });
    }

    public JSONObject getBySqlAdmin(String sql) {
        Request request = this.newRequest(Command.r_get_sql_admin);
        request.json("sql", sql);
        request.request();
        this.waiting(request);
        JSONObject res = this.getResult(request);
        return this.getSelectRes(res);
    }

    public void getBySqlAdmin(final String sql, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.r_get_sql_admin, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("sql", sql);
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                JSONObject res = Client.this.getResult(response.request);
                return Client.this.getSelectRes(res);
            }
        });
    }

    public JSONObject getNameInDB(String owner, String tableName) {
        Request request = this.newRequest(Command.g_dbname);
        request.json("account", owner);
        request.json("tablename", tableName);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public void getNameInDB(final String owner, final String tableName, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.g_dbname, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("account", owner);
                request.json("tablename", tableName);
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                return Client.this.getResult(response.request);
            }
        });
    }

    public JSONObject getLedger(JSONObject option) {
        Request request = this.newRequest(Command.ledger);
        request.json("ledger_index", option.get("ledger_index"));
        request.json("expand", false);
        request.json("transactions", true);
        request.json("accounts", false);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public void getLedger(final JSONObject option, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.ledger, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("ledger_index", option.get("ledger_index"));
                request.json("expand", false);
                request.json("transactions", true);
                request.json("accounts", false);
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                return Client.this.getResult(response.request);
            }
        });
    }

    private void UnhexResult(Response response) {
        if (response != null && response.result != null && response.result.has("transactions")) {
            JSONArray txs = (JSONArray)response.result.get("transactions");
            for (int i = 0; i < txs.length(); ++i) {
                JSONObject tx = (JSONObject)txs.get(i);
                Util.unHexData(tx.getJSONObject("tx"));
                if (!tx.has("meta")) continue;
                tx.remove("meta");
            }
        }
    }

    public JSONObject getTransactions(String address, int limit) {
        Request request = this.newRequest(Command.account_tx);
        request.json("account", address);
        request.json("ledger_index_min", -1);
        request.json("ledger_index_max", -1);
        request.json("limit", limit);
        request.request();
        this.waiting(request);
        this.UnhexResult(request.response);
        return this.getResult(request);
    }

    public void getTransactions(String address, int limit, Publisher.Callback<JSONObject> cb) {
        this.getTransactions(address, limit, null, cb);
    }

    public void getTransactions(final String address, final int limit, final JSONObject marker, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.account_tx, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("account", address);
                if (marker != null) {
                    request.json("marker", marker);
                }
                request.json("ledger_index_min", -1);
                request.json("ledger_index_max", -1);
                request.json("limit", limit);
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                Client.this.UnhexResult(response);
                return Client.this.getResult(response.request);
            }
        });
    }

    public void getCrossChainTxs(final String hash, final int limit, final boolean include, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.tx_crossget, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("transaction_hash", hash);
                request.json("limit", limit);
                request.json("inclusive", include);
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                Client.this.UnhexResult(response);
                return response.result;
            }
        });
    }

    private void waiting(Request request) {
        int count = 100;
        while (request.response == null) {
            Util.waiting();
            if (--count != 0) continue;
            break;
        }
    }

    private JSONObject getResult(Request request) {
        Response response = request.response;
        if (response != null) {
            if (response.result != null) {
                return response.result;
            }
            if (response.message != null) {
                return response.message;
            }
            return new JSONObject();
        }
        JSONObject ret = new JSONObject();
        ret.put("error", (Object)"timeOutError");
        ret.put("error_message", (Object)("request for command:" + request.cmd.toString() + " timeout"));
        return ret;
    }

    public JSONObject getLedgerVersion() {
        Request request = this.newRequest(Command.ledger_current);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public void getLedgerVersion(final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.ledger_current, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                return Client.this.getResult(response.request);
            }
        });
    }

    public JSONObject getTransactionCount() {
        Request request = this.newRequest(Command.tx_count);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public JSONObject getServerInfo() {
        Request request = this.newRequest(Command.server_info);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public JSONObject getUnlList() {
        Request request = this.newRequest(Command.unl_list);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public JSONObject getUserToken(String owner, String user, String name) {
        Request request = this.newRequest(Command.g_userToken);
        JSONObject txjson = new JSONObject();
        txjson.put("Owner", (Object)owner);
        txjson.put("User", (Object)user);
        txjson.put("TableName", (Object)name);
        request.json("tx_json", txjson);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public void getUserToken(final String owner, final String user, final String name, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.g_userToken, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                JSONObject txjson = new JSONObject();
                txjson.put("Owner", (Object)owner);
                txjson.put("User", (Object)user);
                txjson.put("TableName", (Object)name);
                request.json("tx_json", txjson);
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                return Client.this.getResult(response.request);
            }
        });
    }

    public JSONObject tablePrepare(JSONObject txjson) {
        Request request = this.newRequest(Command.t_prepare);
        request.json("tx_json", txjson);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public JSONObject contractCall(JSONObject obj) {
        Request request = this.newRequest(Command.contract_call);
        Iterator it = obj.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = obj.getString(key);
            request.json(key, value);
        }
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public JSONObject GetAccountLines(String address) {
        Request request = this.newRequest(Command.account_lines);
        request.json("account", address);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public void GetAccountLines(final AccountID addy, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.account_lines, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("account", addy);
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                return response.result;
            }
        });
    }

    public JSONObject getTableAuth(String owner, String tableName, List<String> accounts) {
        Request request = this.newRequest(Command.table_auth);
        request.json("owner", owner);
        request.json("tablename", tableName);
        if (accounts != null && accounts.size() != 0) {
            request.json("accounts", Util.listToJSONArray(accounts));
        }
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public void getTableAuth(final String owner, final String tableName, final List<String> accounts, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.table_auth, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("owner", owner);
                request.json("tablename", tableName);
                if (accounts != null && accounts.size() != 0) {
                    request.json("accounts", Util.listToJSONArray(accounts));
                }
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                return Client.this.getResult(response.request);
            }
        });
    }

    public JSONObject getAccountTables(String address, boolean bGetDetail) {
        Request request = this.newRequest(Command.g_accountTables);
        request.json("account", address);
        if (bGetDetail) {
            request.json("detail", true);
        }
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public void getAccountTables(final String address, final boolean bGetDetail, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.g_accountTables, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("account", address);
                if (bGetDetail) {
                    request.json("detail", true);
                }
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                return Client.this.getResult(response.request);
            }
        });
    }

    public void contractCall(final JSONObject obj, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.contract_call, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                Iterator it = obj.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = obj.getString(key);
                    request.json(key, value);
                }
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                return Client.this.getResult(response.request);
            }
        });
    }

    public JSONObject getTransaction(String hash) {
        Request request = this.newRequest(Command.tx);
        request.json("transaction", hash);
        request.request();
        this.waiting(request);
        return this.getResult(request);
    }

    public void getTransaction(final String hash, final Publisher.Callback<JSONObject> cb) {
        this.makeManagedRequest(Command.tx, new Request.Manager<JSONObject>(){

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return false;
            }

            @Override
            public void cb(Response response, JSONObject jsonObject) throws JSONException {
                if (response.succeeded) {
                    cb.called(jsonObject);
                } else {
                    JSONObject res = Client.this.getResult(response.request);
                    cb.called(res);
                }
            }
        }, new Request.Builder<JSONObject>(){

            @Override
            public void beforeRequest(Request request) {
                request.json("transaction", hash);
            }

            @Override
            public JSONObject buildTypedResponse(Response response) {
                Util.unHexData(response.result);
                return Client.this.getResult(response.request);
            }
        });
    }

    public Request ping() {
        return this.newRequest(Command.ping);
    }

    public Request subscribeAccount(AccountID ... accounts) {
        Request request = this.newRequest(Command.subscribe);
        JSONArray accounts_arr = new JSONArray();
        for (AccountID acc : accounts) {
            accounts_arr.put((Object)acc);
        }
        request.json("accounts", accounts_arr);
        return request;
    }

    public Request subscribeBookOffers(Issue get, Issue pay) {
        Request request = this.newRequest(Command.subscribe);
        JSONObject book = new JSONObject();
        JSONArray books = new JSONArray((Object)new Object[]{book});
        book.put("snapshot", true);
        book.put("taker_gets", (Object)get.toJSON());
        book.put("taker_pays", (Object)pay.toJSON());
        request.json("books", books);
        return request;
    }

    public Request requestBookOffers(Issue get, Issue pay) {
        Request request = this.newRequest(Command.book_offers);
        request.json("taker_gets", get.toJSON());
        request.json("taker_pays", pay.toJSON());
        return request;
    }

    public static abstract class ThrowingRunnable
    implements Runnable {
        public abstract void throwingRun() throws Exception;

        @Override
        public void run() {
            try {
                this.throwingRun();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface OnContractEvent
    extends events<JSONObject> {
    }

    public static interface OnReconnected
    extends events<JSONObject> {
    }

    public static interface OnReconnecting
    extends events<JSONObject> {
    }

    public static interface OnValidatedTransaction
    extends events<TransactionResult> {
    }

    public static interface OnPathFind
    extends events<JSONObject> {
    }

    public static interface OnStateChange
    extends events<Client> {
    }

    public static interface OnSendMessage
    extends events<JSONObject> {
    }

    public static interface OnTXMessage
    extends events<JSONObject> {
    }

    public static interface OnChainsqlSubRet
    extends events<JSONObject> {
    }

    public static interface OnTBMessage
    extends events<JSONObject> {
    }

    public static interface OnMessage
    extends events<JSONObject> {
    }

    public static interface OnSubscribed
    extends events<ServerInfo> {
    }

    public static interface OnDisconnected
    extends events<Client> {
    }

    public static interface OnConnected
    extends events<Client> {
    }

    public static interface OnLedgerClosed
    extends events<ServerInfo> {
    }

    public static interface events<T>
    extends Publisher.Callback<T> {
    }
}

