/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.payments;

import com.peersafe.base.client.payments.Alternative;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.PathSet;
import com.peersafe.base.core.coretypes.hash.Hash256;
import java.util.ArrayList;
import java.util.TreeMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class Alternatives
extends ArrayList<Alternative> {
    TreeMap<Hash256, Alternative> altMap = new TreeMap();

    public Alternatives(JSONArray array, Alternatives prior) {
        for (int i = 0; i < array.length(); ++i) {
            JSONObject alternativeJson = array.getJSONObject(i);
            Amount sourceAmount = (Amount)Amount.translate.fromValue(alternativeJson.get("source_amount"));
            PathSet paths = PathSet.translate.fromJSONArray(alternativeJson.getJSONArray("paths_computed"));
            this.addRecyclingPrior(new Alternative(paths, sourceAmount), prior);
        }
    }

    public Alternatives() {
    }

    public void addRecyclingPrior(Integer index, Alternative object, Alternatives prior) {
        Alternative priorAlternative;
        if (prior != null && (priorAlternative = this.altMap.get(object.hash)) != null) {
            object = priorAlternative;
        }
        if (index != null) {
            super.add(index, object);
        } else {
            super.add(object);
        }
        this.altMap.put(object.hash, object);
    }

    public boolean hasNativeSource() {
        for (Alternative alt : this) {
            if (!alt.sourceAmount.isNative()) continue;
            return true;
        }
        return false;
    }

    public void addRecyclingPrior(Alternative alt, Alternatives prior) {
        this.addRecyclingPrior(null, alt, prior);
    }
}

