/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.pubsub;

import com.peersafe.base.client.pubsub.CallbackContext;
import com.peersafe.chainsql.manager.CallbackManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Publisher<CompatHack extends Callback> {
    static final Logger logger = Logger.getLogger(Publisher.class.getName());
    private final DefaultCallbackListMap cbs = new DefaultCallbackListMap();

    private void log(Level level, String message, Object ... params) {
        logger.log(level, message, params);
    }

    public <A, T extends Callback<A>> void on(Class<T> key, T cb) {
        this.add(key, cb);
    }

    public <A, T extends Callback<A>> void on(Class<T> key, CallbackContext executor, T cb) {
        this.add(key, executor, cb);
    }

    public <A, T extends Callback<A>> void once(Class<T> key, T cb) {
        this.once(key, null, cb);
    }

    public <A, T extends Callback<A>> void once(Class<T> key, CallbackContext executor, T cb) {
        this.add(key, executor, cb, true);
    }

    public <A, T extends Callback<A>> int emit(Class<T> key, A args) {
        if (logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "Emitting {0} from thread: {1}", key.getSimpleName(), Thread.currentThread());
        }
        int executed = 0;
        CallbackList callbacks = (CallbackList)this.cbs.get(key);
        if (callbacks != null) {
            CallbackList copy = new CallbackList(callbacks);
            for (ContextedCallback pair : copy) {
                boolean removed = false;
                CallbackContext context = pair.context;
                if (context == null) {
                    Publisher.execute(args, pair);
                    ++executed;
                } else if (context.shouldExecute()) {
                    context.execute(pair.runnableWrappedCallback(args));
                    ++executed;
                } else if (context.shouldRemove()) {
                    callbacks.remove(pair);
                    removed = true;
                }
                if (!pair.oneShot || removed) continue;
                callbacks.remove(pair);
            }
        }
        return executed;
    }

    public static void execute(final Object args, final ContextedCallback pair) {
        CallbackManager.instance().runRunnable(new Runnable(){

            @Override
            public void run() {
                pair.callback.called(args);
            }
        });
    }

    private CallbackList listFor(Class<? extends Callback> key) {
        return this.cbs.getDefault(key);
    }

    private <A, T extends Callback<A>> void add(Class<T> key, Callback<A> cb) {
        this.add(key, null, cb, false);
    }

    private <A, T extends Callback<A>> void add(Class<T> key, CallbackContext executor, Callback<A> cb) {
        this.add(key, executor, cb, false);
    }

    private <A, T extends Callback<A>> void add(Class<T> key, CallbackContext executor, Callback<A> cb, boolean b) {
        this.listFor(key).add(executor, cb, b);
    }

    public <A, T extends Callback<A>> boolean removeListener(Class<T> key, Callback<A> cb) {
        return this.listFor(key).remove(cb);
    }

    public void clearAllListeners() {
        this.cbs.clear();
    }

    private class DefaultCallbackListMap
    extends HashMap<Class<? extends Callback>, CallbackList> {
        private DefaultCallbackListMap() {
        }

        public CallbackList getDefault(Class<? extends Callback> key) {
            CallbackList list = (CallbackList)super.get(key);
            if (list == null) {
                CallbackList newList = new CallbackList();
                this.put(key, newList);
                return newList;
            }
            return list;
        }
    }

    private static class CallbackList
    extends ArrayList<ContextedCallback> {
        public CallbackList() {
        }

        public CallbackList(CallbackList callbacks) {
            super(callbacks);
        }

        @Override
        public ContextedCallback get(int index) {
            return (ContextedCallback)super.get(index);
        }

        public boolean remove(Callback t) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                ContextedCallback next = (ContextedCallback)iter.next();
                if (next.callback != t) continue;
                iter.remove();
                return true;
            }
            return false;
        }

        public void add(CallbackContext exec, Callback cb, boolean oneShot) {
            this.add(new ContextedCallback(cb, exec, oneShot));
        }
    }

    private static class ContextedCallback {
        CallbackContext context;
        Callback callback;
        boolean oneShot;

        public ContextedCallback(Callback callback, CallbackContext context, boolean oneShot) {
            this.context = context;
            this.callback = callback;
            this.oneShot = oneShot;
        }

        public Runnable runnableWrappedCallback(final Object args) {
            return new Runnable(){

                @Override
                public void run() {
                    Publisher.execute(args, this);
                }
            };
        }
    }

    public static interface ErrBack<T>
    extends Callback<T> {
        public void erred(RuntimeException var1);
    }

    public static interface Callback<T> {
        public void called(T var1);
    }
}

