/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.requests;

import com.peersafe.base.client.Client;
import com.peersafe.base.client.enums.Command;
import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.client.responses.Response;
import java.util.Iterator;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Request
extends Publisher<events> {
    public static final Logger logger = Logger.getLogger(Request.class.getName());
    public static final long TIME_OUT = 120000L;
    public static final int VALIDATED_LEDGER = -3;
    public static final int CLOSED_LEDGER = -2;
    public static final int OPEN_LEDGER = -1;
    Client client;
    public Command cmd;
    public Response response;
    private JSONObject json;
    public int id;
    public long sendTime;

    public void json(JSONObject jsonObject) {
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String next = (String)keys.next();
            this.json(next, jsonObject.opt(next));
        }
    }

    public Request(Command command, int assignedId, Client client) {
        this.client = client;
        this.cmd = command;
        this.id = assignedId;
        this.json = new JSONObject();
        this.json("command", this.cmd.toString());
        this.json("id", assignedId);
    }

    public JSONObject json() {
        return this.json;
    }

    public void json(String key, Object value) {
        this.json.put(key, value);
    }

    public void request() {
        this.client.nowOrWhenConnected(new Client.OnConnected(){

            @Override
            public void called(Client client_) {
                Request.this.client.sendRequest(Request.this);
            }
        });
    }

    public void bumpSendTime() {
        this.sendTime = System.currentTimeMillis();
    }

    public JSONObject toJSON() {
        return this.json();
    }

    public JSONObject jsonRepr() {
        JSONObject repr = new JSONObject();
        if (this.response != null) {
            repr.put("response", (Object)this.response.message);
        }
        repr.put("request", (Object)new JSONObject(this.json.toString()));
        return repr;
    }

    public void handleResponse(JSONObject msg) {
        this.response = new Response(this, msg);
        if (this.response.succeeded) {
            this.emit(OnSuccess.class, this.response);
        } else {
            this.emit(OnError.class, this.response);
        }
        this.emit(OnResponse.class, this.response);
    }

    public static abstract class Manager<T> {
        public abstract void cb(Response var1, T var2) throws JSONException;

        public boolean retryOnUnsuccessful(Response r) {
            return false;
        }

        public void beforeRequest(Request r) {
        }
    }

    public static interface OnTimeout
    extends events<Response> {
    }

    public static interface OnResponse
    extends events<Response> {
    }

    public static interface OnError
    extends events<Response> {
    }

    public static interface OnSuccess
    extends events<Response> {
    }

    public static interface events<T>
    extends Publisher.Callback<T> {
    }

    public static interface Builder<T> {
        public void beforeRequest(Request var1);

        public T buildTypedResponse(Response var1);
    }
}

