/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.subscriptions.ledger;

import com.peersafe.base.client.Client;
import com.peersafe.base.client.subscriptions.ServerInfo;
import com.peersafe.base.client.subscriptions.SubscriptionManager;
import com.peersafe.base.client.subscriptions.TransactionSubscriptionManager;
import com.peersafe.base.client.subscriptions.ledger.PendingLedger;
import com.peersafe.base.client.subscriptions.ledger.PendingLedgers;
import com.peersafe.base.core.types.known.tx.result.TransactionResult;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LedgerSubscriber
implements TransactionSubscriptionManager {
    public static final Logger logger = Logger.getLogger(LedgerSubscriber.class.getName());
    Client client;
    PendingLedgers ledgers;

    public static void log(String fmt, Object ... args) {
        logger.log(Level.FINE, fmt, args);
    }

    @Override
    public void notifyTransactionResult(TransactionResult tr) {
        this.ledgers.notifyTransactionResult(tr);
    }

    public LedgerSubscriber(Client client) {
        this.client = client;
        this.ledgers = new PendingLedgers(client);
        this.subscribeToTransactions();
        this.bindLedgerCloseHandler();
    }

    private void subscribeToTransactions() {
        this.client.subscriptions.addStream(SubscriptionManager.Stream.transactions);
    }

    private void bindLedgerCloseHandler() {
        this.client.on(Client.OnLedgerClosed.class, new Client.OnLedgerClosed(){

            @Override
            public void called(ServerInfo serverInfo) {
                long ledger_index = serverInfo.ledger_index;
                LedgerSubscriber.this.ledgers.trackMissingLedgersInClearedLedgerHistory();
                LedgerSubscriber.this.ledgers.logPendingLedgers();
                PendingLedger ledger = LedgerSubscriber.this.ledgers.getOrAddLedger(ledger_index);
                ledger.expectedTxns = serverInfo.txn_count;
                if (ledger.status == PendingLedger.Status.pending) {
                    LedgerSubscriber.this.ledgers.checkHeader(ledger);
                }
                for (Long stalledOrGapLedger : LedgerSubscriber.this.ledgers.pendingLedgerIndexes()) {
                    PendingLedger stalled = LedgerSubscriber.this.ledgers.getOrAddLedger(stalledOrGapLedger);
                    if (stalled.status != PendingLedger.Status.pending) continue;
                    LedgerSubscriber.this.ledgers.checkHeader(stalled);
                    break;
                }
            }
        });
    }
}

