/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.transactions;

import com.peersafe.base.client.Client;
import com.peersafe.base.client.enums.Command;
import com.peersafe.base.client.requests.Request;
import com.peersafe.base.client.responses.Response;
import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.types.known.tx.result.TransactionResult;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccountTxPager {
    Client client;
    AccountID account;
    private Request.OnError onError;
    OnPage onPage;
    private long ledgerMax;
    private long ledgerMin;
    private boolean aborted = false;
    private boolean forward = false;
    private int limit = 2000;
    private int maxRetries;

    public AccountTxPager(Client client, AccountID account, OnPage onPage) {
        this(client, account, onPage, -1L, -1L);
    }

    public AccountTxPager(Client client, AccountID account, OnPage onPage, long ledgerMin) {
        this(client, account, onPage, ledgerMin, -1L);
    }

    public AccountTxPager(Client client, AccountID account, OnPage onPage, long ledgerMin, long ledgerMax) {
        this.ledgerMax = ledgerMax;
        this.ledgerMin = ledgerMin;
        this.account = account;
        this.client = client;
        if (onPage == null) {
            onPage = new OnPage(){

                @Override
                public void onPage(Page page) {
                }
            };
        }
        this.onPage = onPage;
        this.onError = null;
        this.maxRetries = 10;
    }

    public void request() {
        if (this.onPage == null) {
            throw new IllegalStateException("Forgot to set OnPage!");
        }
        this.walkAccountTx(null);
    }

    public AccountTxPager maxRetriesPerPage(int retries) {
        this.maxRetries = retries;
        return this;
    }

    public AccountTxPager onPage(OnPage page) {
        this.onPage = page;
        return this;
    }

    public AccountTxPager onError(Request.OnError onError) {
        this.onError = onError;
        return this;
    }

    public void abort() {
        this.aborted = true;
    }

    public AccountTxPager pageSize(int i) {
        this.limit = i;
        return this;
    }

    public AccountTxPager minLedger(long i) {
        this.ledgerMin = i;
        return this;
    }

    public AccountTxPager maxLedger(long i) {
        this.ledgerMax = i;
        return this;
    }

    public AccountTxPager forward(boolean fwd) {
        this.forward = fwd;
        return this;
    }

    private void walkAccountTx(final Object marker) {
        this.client.makeManagedRequest(Command.account_tx, new Request.Manager<JSONArray>(){
            int retries = 0;

            @Override
            public boolean retryOnUnsuccessful(Response r) {
                return AccountTxPager.this.maxRetries == -1 || ++this.retries <= AccountTxPager.this.maxRetries;
            }

            @Override
            public void cb(Response response, JSONArray ignored) throws JSONException {
                if (AccountTxPager.this.aborted) {
                    return;
                }
                if (response.succeeded) {
                    AccountTxPager.this.onTransactions(response.result);
                } else if (AccountTxPager.this.onError != null) {
                    AccountTxPager.this.onError.called(response);
                }
            }
        }, new Request.Builder<JSONArray>(){

            @Override
            public void beforeRequest(Request request) {
                AccountTxPager.this.configureRequest(request, marker);
            }

            @Override
            public JSONArray buildTypedResponse(Response response) {
                return null;
            }
        });
    }

    private void onTransactions(JSONObject responseResult) {
        final JSONArray transactions = responseResult.getJSONArray("transactions");
        final int ledger_index_max = responseResult.optInt("ledger_index_max");
        final int ledger_index_min = responseResult.optInt("ledger_index_min");
        final Object newMarker = responseResult.opt("marker");
        this.onPage.onPage(new Page(){
            ArrayList<TransactionResult> txns = null;

            @Override
            public boolean hasNext() {
                return newMarker != null;
            }

            @Override
            public void requestNext() {
                if (this.hasNext()) {
                    AccountTxPager.this.walkAccountTx(newMarker);
                }
            }

            @Override
            public long ledgerMax() {
                return ledger_index_max;
            }

            @Override
            public long ledgerMin() {
                return ledger_index_min;
            }

            @Override
            public int size() {
                return transactions.length();
            }

            @Override
            public ArrayList<TransactionResult> transactionResults() {
                if (this.txns == null) {
                    this.txns = new ArrayList();
                    for (int i = 0; i < transactions.length(); ++i) {
                        JSONObject jsonObject = transactions.optJSONObject(i);
                        this.txns.add(new TransactionResult(jsonObject, TransactionResult.Source.request_account_tx_binary));
                    }
                }
                return this.txns;
            }

            @Override
            public JSONArray transactionsJSON() {
                return transactions;
            }
        });
    }

    private void configureRequest(Request request, Object marker) {
        request.json("binary", true);
        request.json("account", this.account);
        if (marker != null) {
            request.json("marker", marker);
        }
        request.json("ledger_index_max", this.ledgerMax);
        request.json("ledger_index_min", this.ledgerMin);
        request.json("limit", this.limit);
        if (this.forward) {
            request.json("forward", true);
        }
    }

    public static interface OnPage {
        public void onPage(Page var1);
    }

    public static interface Page {
        public boolean hasNext();

        public void requestNext();

        public long ledgerMax();

        public long ledgerMin();

        public int size();

        public ArrayList<TransactionResult> transactionResults();

        public JSONArray transactionsJSON();
    }
}

