/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.transport.impl;

import com.peersafe.base.client.transport.TransportEventHandler;
import com.peersafe.base.client.transport.WebSocketTransport;
import com.peersafe.base.client.transport.impl.WS;
import java.io.File;
import java.io.FileInputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.json.JSONObject;

public class JavaWebSocketTransportImpl
implements WebSocketTransport {
    WeakReference<TransportEventHandler> handler;
    WS client = null;

    @Override
    public void setHandler(TransportEventHandler events2) {
        this.handler = new WeakReference<TransportEventHandler>(events2);
        if (this.client != null) {
            this.client.setEventHandler(events2);
        }
    }

    @Override
    public void sendMessage(JSONObject msg) {
        this.client.send(msg.toString());
    }

    @Override
    public void connect(URI uri) {
        TransportEventHandler curHandler = (TransportEventHandler)this.handler.get();
        if (curHandler == null) {
            throw new RuntimeException("must call setEventHandler() before connect(...)");
        }
        this.disconnect();
        this.client = new WS(uri);
        this.client.setEventHandler(curHandler);
        curHandler.onConnecting(1);
        this.client.connect();
    }

    @Override
    public void connectSSL(URI uri, String serverCertPath, String storePass) throws Exception {
        TransportEventHandler curHandler = (TransportEventHandler)this.handler.get();
        if (curHandler == null) {
            throw new RuntimeException("must call setEventHandler() before connect(...)");
        }
        this.disconnect();
        this.client = new WS(uri);
        this.client.setEventHandler(curHandler);
        curHandler.onConnecting(1);
        String STORETYPE = "JKS";
        String KEYSTORE = serverCertPath;
        String STOREPASSWORD = storePass;
        KeyStore ks = KeyStore.getInstance(STORETYPE);
        File kf = new File(KEYSTORE);
        ks.load(new FileInputStream(kf), STOREPASSWORD.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(ks);
        SSLContext sslContext = null;
        sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, tmf.getTrustManagers(), null);
        SSLSocketFactory factory = sslContext.getSocketFactory();
        this.client.setSocket(factory.createSocket());
        this.client.connectBlocking();
    }

    @Override
    public void disconnect() {
        if (this.client != null) {
            TransportEventHandler handler = (TransportEventHandler)this.handler.get();
            if (handler != null) {
                handler.onDisconnected(false);
            }
            this.client.muteEventHandler();
            this.client.close();
            this.client = null;
        }
    }
}

