/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.transport.impl;

import com.peersafe.base.client.transport.TransportEventHandler;
import java.lang.ref.WeakReference;
import java.net.URI;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;
import org.json.JSONObject;

class WS
extends WebSocketClient {
    WeakReference<TransportEventHandler> h;
    String frameData = "";

    public WS(URI serverURI) {
        super(serverURI);
    }

    public void muteEventHandler() {
        this.h.clear();
    }

    public void setEventHandler(TransportEventHandler eventHandler) {
        this.h = new WeakReference<TransportEventHandler>(eventHandler);
    }

    public void onOpen(ServerHandshake handshakedata) {
        TransportEventHandler handler = (TransportEventHandler)this.h.get();
        if (handler != null) {
            handler.onConnected();
        }
    }

    public void onFragment(Framedata frame) {
        this.frameData = this.frameData + new String(frame.getPayloadData().array());
        if (frame.isFin()) {
            this.onMessage(this.frameData);
            this.frameData = "";
        }
    }

    public void onMessage(String message) {
        TransportEventHandler handler = (TransportEventHandler)this.h.get();
        if (handler != null) {
            handler.onMessage(new JSONObject(message));
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        TransportEventHandler handler = (TransportEventHandler)this.h.get();
        if (handler != null) {
            handler.onDisconnected(false);
        }
    }

    public void onError(Exception ex) {
        TransportEventHandler handler = (TransportEventHandler)this.h.get();
        if (handler != null) {
            handler.onError(ex);
        }
    }
}

