/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.coretypes;

import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.Currency;
import com.peersafe.base.core.coretypes.hash.Hash160;
import java.math.BigDecimal;
import org.json.JSONObject;

public class Issue
implements Comparable<Issue> {
    public static final Issue ZXC = Issue.fromString("ZXC");
    final Currency currency;
    final AccountID issuer;

    public Issue(Currency currency, AccountID issuer) {
        this.currency = currency;
        this.issuer = issuer;
    }

    public static Issue fromString(String pair) {
        String[] split = pair.split("/");
        return Issue.fromStringPair(split);
    }

    private static Issue fromStringPair(String[] split) {
        if (split.length == 2) {
            return new Issue(Currency.fromString(split[0]), AccountID.fromString(split[1]));
        }
        if (split[0].equals("ZXC")) {
            return new Issue(Currency.ZXC, AccountID.XRP_ISSUER);
        }
        throw new RuntimeException("Issue string must be ZXC or $currency/$issuer");
    }

    public static Issue from160s(Hash160 currency, Hash160 issuer) {
        return new Issue(new Currency(currency.bytes()), new AccountID(issuer.toBytes()));
    }

    public Currency currency() {
        return this.currency;
    }

    public AccountID issuer() {
        return this.issuer;
    }

    public String toString() {
        if (this.isNative()) {
            return "ZXC";
        }
        return String.format("%s/%s", this.currency, this.issuer);
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.put("currency", (Object)this.currency);
        if (!this.isNative()) {
            o.put("issuer", (Object)this.issuer);
        }
        return o;
    }

    public Amount amount(BigDecimal value) {
        return new Amount(value, this.currency, this.issuer, this.isNative());
    }

    public boolean isNative() {
        return this == ZXC || this.currency.equals(Currency.ZXC);
    }

    public Amount amount(Number value) {
        return new Amount(BigDecimal.valueOf(value.doubleValue()), this.currency, this.issuer, this.isNative());
    }

    @Override
    public int compareTo(Issue o) {
        int ret = this.issuer.compareTo(o.issuer);
        if (ret != 0) {
            return ret;
        }
        ret = this.currency.compareTo(o.currency);
        return ret;
    }

    public Amount roundedAmount(BigDecimal amount) {
        return this.amount(Amount.roundValue(amount, this.isNative()));
    }
}

