/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.formats;

import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.formats.Format;
import com.peersafe.base.core.serialized.enums.LedgerEntryType;
import java.util.EnumMap;

public class LEFormat
extends Format {
    public static EnumMap<LedgerEntryType, LEFormat> formats = new EnumMap(LedgerEntryType.class);
    public final LedgerEntryType ledgerEntryType;
    public static LEFormat AccountRoot = new LEFormat(LedgerEntryType.AccountRoot, new Object[]{Field.Account, Format.Requirement.REQUIRED, Field.Sequence, Format.Requirement.REQUIRED, Field.Balance, Format.Requirement.REQUIRED, Field.OwnerCount, Format.Requirement.REQUIRED, Field.PreviousTxnID, Format.Requirement.REQUIRED, Field.PreviousTxnLgrSeq, Format.Requirement.REQUIRED, Field.AccountTxnID, Format.Requirement.OPTIONAL, Field.RegularKey, Format.Requirement.OPTIONAL, Field.EmailHash, Format.Requirement.OPTIONAL, Field.WalletLocator, Format.Requirement.OPTIONAL, Field.WalletSize, Format.Requirement.OPTIONAL, Field.MessageKey, Format.Requirement.OPTIONAL, Field.TransferRate, Format.Requirement.OPTIONAL, Field.Domain, Format.Requirement.OPTIONAL, Field.TransferFeeMax, Format.Requirement.OPTIONAL, Field.TransferFeeMin, Format.Requirement.OPTIONAL, Field.StorageOverlay, Format.Requirement.OPTIONAL, Field.Nonce, Format.Requirement.OPTIONAL, Field.ContractCode, Format.Requirement.OPTIONAL});
    public static LEFormat DirectoryNode = new LEFormat(LedgerEntryType.DirectoryNode, new Object[]{Field.Owner, Format.Requirement.OPTIONAL, Field.TakerPaysCurrency, Format.Requirement.OPTIONAL, Field.TakerPaysIssuer, Format.Requirement.OPTIONAL, Field.TakerGetsCurrency, Format.Requirement.OPTIONAL, Field.TakerGetsIssuer, Format.Requirement.OPTIONAL, Field.ExchangeRate, Format.Requirement.OPTIONAL, Field.Indexes, Format.Requirement.REQUIRED, Field.RootIndex, Format.Requirement.REQUIRED, Field.IndexNext, Format.Requirement.OPTIONAL, Field.IndexPrevious, Format.Requirement.OPTIONAL});
    public static LEFormat Offer = new LEFormat(LedgerEntryType.Offer, new Object[]{Field.Account, Format.Requirement.REQUIRED, Field.Sequence, Format.Requirement.REQUIRED, Field.TakerPays, Format.Requirement.REQUIRED, Field.TakerGets, Format.Requirement.REQUIRED, Field.BookDirectory, Format.Requirement.REQUIRED, Field.BookNode, Format.Requirement.REQUIRED, Field.OwnerNode, Format.Requirement.REQUIRED, Field.PreviousTxnID, Format.Requirement.REQUIRED, Field.PreviousTxnLgrSeq, Format.Requirement.REQUIRED, Field.Expiration, Format.Requirement.OPTIONAL});
    public static LEFormat Ticket = new LEFormat(LedgerEntryType.Ticket, new Object[]{Field.PreviousTxnID, Format.Requirement.REQUIRED, Field.PreviousTxnLgrSeq, Format.Requirement.REQUIRED, Field.Account, Format.Requirement.REQUIRED, Field.Sequence, Format.Requirement.REQUIRED, Field.OwnerNode, Format.Requirement.REQUIRED, Field.Target, Format.Requirement.OPTIONAL, Field.Expiration, Format.Requirement.OPTIONAL});
    public static LEFormat RippleState = new LEFormat(LedgerEntryType.RippleState, new Object[]{Field.Balance, Format.Requirement.REQUIRED, Field.LowLimit, Format.Requirement.REQUIRED, Field.HighLimit, Format.Requirement.REQUIRED, Field.PreviousTxnID, Format.Requirement.REQUIRED, Field.PreviousTxnLgrSeq, Format.Requirement.REQUIRED, Field.LowNode, Format.Requirement.OPTIONAL, Field.LowQualityIn, Format.Requirement.OPTIONAL, Field.LowQualityOut, Format.Requirement.OPTIONAL, Field.HighNode, Format.Requirement.OPTIONAL, Field.HighQualityIn, Format.Requirement.OPTIONAL, Field.HighQualityOut, Format.Requirement.OPTIONAL});
    public static LEFormat SuspendedPayment = new LEFormat(LedgerEntryType.SuspendedPayment, new Object[]{Field.Account, Format.Requirement.REQUIRED, Field.Destination, Format.Requirement.REQUIRED, Field.Amount, Format.Requirement.REQUIRED, Field.PreviousTxnID, Format.Requirement.REQUIRED, Field.PreviousTxnLgrSeq, Format.Requirement.REQUIRED, Field.OwnerNode, Format.Requirement.REQUIRED, Field.Digest, Format.Requirement.OPTIONAL, Field.CancelAfter, Format.Requirement.OPTIONAL, Field.FinishAfter, Format.Requirement.OPTIONAL, Field.SourceTag, Format.Requirement.OPTIONAL, Field.DestinationTag, Format.Requirement.OPTIONAL});
    public static LEFormat LedgerHashes = new LEFormat(LedgerEntryType.LedgerHashes, new Object[]{Field.FirstLedgerSequence, Format.Requirement.OPTIONAL, Field.LastLedgerSequence, Format.Requirement.OPTIONAL, Field.Hashes, Format.Requirement.REQUIRED});
    public static LEFormat Amendments = new LEFormat(LedgerEntryType.Amendments, new Object[]{Field.Amendments, Format.Requirement.OPTIONAL, Field.Majorities, Format.Requirement.OPTIONAL});
    public static LEFormat SignerList = new LEFormat(LedgerEntryType.SignerList, new Object[]{Field.PreviousTxnID, Format.Requirement.REQUIRED, Field.PreviousTxnLgrSeq, Format.Requirement.REQUIRED, Field.OwnerNode, Format.Requirement.REQUIRED, Field.SignerQuorum, Format.Requirement.REQUIRED, Field.SignerEntries, Format.Requirement.REQUIRED, Field.SignerListID, Format.Requirement.REQUIRED});
    public static LEFormat FeeSettings = new LEFormat(LedgerEntryType.FeeSettings, new Object[]{Field.BaseFee, Format.Requirement.REQUIRED, Field.ReferenceFeeUnits, Format.Requirement.REQUIRED, Field.ReserveBase, Format.Requirement.REQUIRED, Field.ReserveIncrement, Format.Requirement.REQUIRED});
    public static LEFormat TableList = new LEFormat(LedgerEntryType.TableList, new Object[]{Field.OwnerNode, Format.Requirement.REQUIRED, Field.PreviousTxnID, Format.Requirement.REQUIRED, Field.PreviousTxnLgrSeq, Format.Requirement.REQUIRED, Field.TableEntries, Format.Requirement.REQUIRED});

    public static LEFormat fromString(String name) {
        return LEFormat.getLedgerFormat(LedgerEntryType.valueOf(name));
    }

    public static LEFormat fromNumber(Number ord) {
        return LEFormat.getLedgerFormat(LedgerEntryType.fromNumber(ord));
    }

    public static LEFormat fromValue(Object o) {
        if (o instanceof Number) {
            return LEFormat.fromNumber(((Number)o).intValue());
        }
        if (o instanceof String) {
            return LEFormat.fromString((String)o);
        }
        return null;
    }

    public static LEFormat getLedgerFormat(LedgerEntryType key) {
        if (key == null) {
            return null;
        }
        return formats.get(key);
    }

    public LEFormat(LedgerEntryType type, Object ... args) {
        super(args);
        this.ledgerEntryType = type;
        this.addCommonFields();
        formats.put(type, this);
    }

    @Override
    public void addCommonFields() {
        this.put(Field.LedgerIndex, Format.Requirement.OPTIONAL);
        this.put(Field.LedgerEntryType, Format.Requirement.REQUIRED);
        this.put(Field.Flags, Format.Requirement.REQUIRED);
    }

    @Override
    public String name() {
        return this.ledgerEntryType.toString();
    }
}

