/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.types.known.sle.entries;

import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Currency;
import com.peersafe.base.core.coretypes.Vector256;
import com.peersafe.base.core.coretypes.hash.Hash160;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.hash.Index;
import com.peersafe.base.core.coretypes.uint.UInt64;
import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.serialized.SerializedType;
import com.peersafe.base.core.serialized.enums.LedgerEntryType;
import com.peersafe.base.core.types.known.sle.LedgerEntry;

public class DirectoryNode
extends LedgerEntry {
    public DirectoryNode() {
        super(LedgerEntryType.DirectoryNode);
    }

    public UInt64 indexNext() {
        return this.get(UInt64.IndexNext);
    }

    public UInt64 indexPrevious() {
        return this.get(UInt64.IndexPrevious);
    }

    public UInt64 exchangeRate() {
        return this.get(UInt64.ExchangeRate);
    }

    public Hash256 rootIndex() {
        return this.get(Hash256.RootIndex);
    }

    public AccountID owner() {
        return this.get(AccountID.Owner);
    }

    public Hash160 takerPaysCurrency() {
        return this.get(Hash160.TakerPaysCurrency);
    }

    public Hash160 takerPaysIssuer() {
        return this.get(Hash160.TakerPaysIssuer);
    }

    public Hash160 takerGetsCurrency() {
        return this.get(Hash160.TakerGetsCurrency);
    }

    public Hash160 takerGetsIssuer() {
        return this.get(Hash160.TakerGetsIssuer);
    }

    public Vector256 indexes() {
        return this.get(Vector256.Indexes);
    }

    public void indexNext(UInt64 val) {
        this.put(Field.IndexNext, (SerializedType)val);
    }

    public void indexPrevious(UInt64 val) {
        this.put(Field.IndexPrevious, (SerializedType)val);
    }

    public void exchangeRate(UInt64 val) {
        this.put(Field.ExchangeRate, (SerializedType)val);
    }

    public void rootIndex(Hash256 val) {
        this.put(Field.RootIndex, (SerializedType)val);
    }

    public void owner(AccountID val) {
        this.put(Field.Owner, (SerializedType)val);
    }

    public void takerPaysCurrency(Hash160 val) {
        this.put(Field.TakerPaysCurrency, (SerializedType)val);
    }

    public void takerPaysIssuer(Hash160 val) {
        this.put(Field.TakerPaysIssuer, (SerializedType)val);
    }

    public void takerGetsCurrency(Hash160 val) {
        this.put(Field.TakerGetsCurrency, (SerializedType)val);
    }

    public void takerGetsIssuer(Hash160 val) {
        this.put(Field.TakerGetsIssuer, (SerializedType)val);
    }

    public void indexes(Vector256 val) {
        this.put(Field.Indexes, (SerializedType)val);
    }

    public Hash256 nextIndex() {
        return Index.directoryNode(this.rootIndex(), this.indexNext());
    }

    public Hash256 prevIndex() {
        return Index.directoryNode(this.rootIndex(), this.indexPrevious());
    }

    public boolean hasPreviousIndex() {
        return this.indexPrevious() != null && !this.indexPrevious().isZero();
    }

    public boolean hasNextIndex() {
        return this.indexNext() != null && !this.indexNext().isZero();
    }

    public boolean isRootIndex() {
        return this.rootIndex().equals(this.index());
    }

    public void setExchangeDefaults() {
        if (this.takerGetsCurrency() == null) {
            this.takerGetsCurrency(Currency.ZXC);
            this.takerGetsIssuer(AccountID.XRP_ISSUER);
        } else if (this.takerPaysCurrency() == null) {
            this.takerPaysCurrency(Currency.ZXC);
            this.takerPaysIssuer(AccountID.XRP_ISSUER);
        }
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        if (this.exchangeRate() != null) {
            this.setExchangeDefaults();
        }
        if (this.indexes() == null) {
            this.indexes(new Vector256());
        }
    }
}

