/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.types.known.sle.entries;

import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.Currency;
import com.peersafe.base.core.coretypes.Issue;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.hash.Index;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.coretypes.uint.UInt64;
import com.peersafe.base.core.enums.LedgerFlag;
import com.peersafe.base.core.fields.AmountField;
import com.peersafe.base.core.fields.Field;
import com.peersafe.base.core.serialized.SerializedType;
import com.peersafe.base.core.serialized.enums.LedgerEntryType;
import com.peersafe.base.core.types.known.sle.ThreadedLedgerEntry;
import java.util.Arrays;
import java.util.List;

public class RippleState
extends ThreadedLedgerEntry {
    public RippleState() {
        super(LedgerEntryType.RippleState);
    }

    public UInt32 highQualityIn() {
        return this.get(UInt32.HighQualityIn);
    }

    public UInt32 highQualityOut() {
        return this.get(UInt32.HighQualityOut);
    }

    public UInt32 lowQualityIn() {
        return this.get(UInt32.LowQualityIn);
    }

    public UInt32 lowQualityOut() {
        return this.get(UInt32.LowQualityOut);
    }

    public UInt64 lowNode() {
        return this.get(UInt64.LowNode);
    }

    public UInt64 highNode() {
        return this.get(UInt64.HighNode);
    }

    public Amount balance() {
        return this.get(Amount.Balance);
    }

    public Amount lowLimit() {
        return this.get(Amount.LowLimit);
    }

    public Amount highLimit() {
        return this.get(Amount.HighLimit);
    }

    public void highQualityIn(UInt32 val) {
        this.put(Field.HighQualityIn, (SerializedType)val);
    }

    public void highQualityOut(UInt32 val) {
        this.put(Field.HighQualityOut, (SerializedType)val);
    }

    public void lowQualityIn(UInt32 val) {
        this.put(Field.LowQualityIn, (SerializedType)val);
    }

    public void lowQualityOut(UInt32 val) {
        this.put(Field.LowQualityOut, (SerializedType)val);
    }

    public void lowNode(UInt64 val) {
        this.put(Field.LowNode, (SerializedType)val);
    }

    public void highNode(UInt64 val) {
        this.put(Field.HighNode, (SerializedType)val);
    }

    public void balance(Amount val) {
        this.put(Field.Balance, (SerializedType)val);
    }

    public void lowLimit(Amount val) {
        this.put(Field.LowLimit, (SerializedType)val);
    }

    public void highLimit(Amount val) {
        this.put(Field.HighLimit, (SerializedType)val);
    }

    public AccountID lowAccount() {
        return this.lowLimit().issuer();
    }

    public AccountID highAccount() {
        return this.highLimit().issuer();
    }

    public List<AccountID> sortedAccounts() {
        return Arrays.asList(this.lowAccount(), this.highAccount());
    }

    public AmountField limitFieldFor(AccountID source) {
        if (this.lowAccount().equals(source)) {
            return Amount.LowLimit;
        }
        if (this.highAccount().equals(source)) {
            return Amount.HighLimit;
        }
        return null;
    }

    public boolean isFor(AccountID source) {
        return this.lowAccount().equals(source) || this.highAccount().equals(source);
    }

    public boolean isFor(Issue issue) {
        return this.isFor(issue.issuer()) && this.balance().currency().equals(issue.currency());
    }

    public boolean isFor(AccountID s1, AccountID s2, Currency currency) {
        return currency.equals(this.balance().currency()) && this.isFor(s1) && this.isFor(s2);
    }

    public Currency currency() {
        return this.balance().currency();
    }

    private Amount issuedBy(boolean hi) {
        Amount balance = hi ? this.balance().newIssuer(this.highAccount()) : this.balance().negate().newIssuer(this.lowAccount());
        if (!balance.isPositive()) {
            balance = balance.issue().amount(0);
        }
        return balance;
    }

    public Amount issuedByHigh() {
        return this.issuedBy(true);
    }

    public Amount issuedByLow() {
        return this.issuedBy(false);
    }

    public Amount issuedTo(AccountID accountID) {
        return this.issuedBy(this.isLowAccount(accountID));
    }

    @Deprecated
    public boolean authorizedBy(AccountID account) {
        UInt32 flags = this.flags();
        return flags == null || flags.testBit(this.isHighAccount(account) ? LedgerFlag.HighAuth : LedgerFlag.LowAuth);
    }

    private boolean isBitSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    private boolean isHighAccount(AccountID account) {
        return this.highAccount().equals(account);
    }

    private boolean isLowAccount(AccountID account) {
        return this.lowAccount().equals(account);
    }

    public Hash256 lowNodeOwnerDirectory() {
        Hash256 ownerDir = Index.ownerDirectory(this.lowAccount());
        return Index.directoryNode(ownerDir, this.lowNode());
    }

    public Hash256 highNodeOwnerDirectory() {
        Hash256 ownerDir = Index.ownerDirectory(this.highAccount());
        return Index.directoryNode(ownerDir, this.highNode());
    }

    public Hash256[] directoryIndexes() {
        return new Hash256[]{this.lowNodeOwnerDirectory(), this.highNodeOwnerDirectory()};
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        if (this.lowNode() == null) {
            this.lowNode(UInt64.ZERO);
        }
        if (this.highNode() == null) {
            this.highNode(UInt64.ZERO);
        }
    }
}

