/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.types.known.tx.result;

import com.peersafe.base.core.coretypes.STArray;
import com.peersafe.base.core.coretypes.STObject;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.coretypes.uint.UInt8;
import com.peersafe.base.core.serialized.enums.EngineResult;
import com.peersafe.base.core.types.known.sle.LedgerEntry;
import com.peersafe.base.core.types.known.tx.result.AffectedNode;
import java.util.Iterator;

public class TransactionMeta
extends STObject {
    public static boolean isTransactionMeta(STObject source) {
        return source.has(UInt8.TransactionResult) && source.has(STArray.AffectedNodes);
    }

    public EngineResult engineResult() {
        return TransactionMeta.engineResult(this);
    }

    public Iterable<AffectedNode> affectedNodes() {
        STArray nodes = this.get(STArray.AffectedNodes);
        final Iterator iterator = nodes.iterator();
        return new Iterable<AffectedNode>(){

            @Override
            public Iterator<AffectedNode> iterator() {
                return TransactionMeta.iterateAffectedNodes(iterator);
            }
        };
    }

    public void walkPrevious(LedgerEntry.OnLedgerEntry cb) {
        for (AffectedNode affectedNode : this.affectedNodes()) {
            if (!affectedNode.wasPreviousNode()) continue;
            cb.onObject(affectedNode.nodeAsPrevious());
        }
    }

    public void walkFinal(LedgerEntry.OnLedgerEntry cb) {
        for (AffectedNode affectedNode : this.affectedNodes()) {
            if (!affectedNode.isFinalNode()) continue;
            cb.onObject(affectedNode.nodeAsFinal());
        }
    }

    public static Iterator<AffectedNode> iterateAffectedNodes(final Iterator<STObject> iterator) {
        return new Iterator<AffectedNode>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public AffectedNode next() {
                return (AffectedNode)iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public UInt32 transactionIndex() {
        return this.get(UInt32.TransactionIndex);
    }
}

