/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.core.types.known.tx.signed;

import com.peersafe.base.config.Config;
import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.Blob;
import com.peersafe.base.core.coretypes.STObject;
import com.peersafe.base.core.coretypes.hash.HalfSha512;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.hash.prefixes.HashPrefix;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.serialized.BytesList;
import com.peersafe.base.core.serialized.MultiSink;
import com.peersafe.base.core.serialized.enums.TransactionType;
import com.peersafe.base.core.types.known.tx.Transaction;
import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.crypto.ecdsa.Seed;
import java.util.Arrays;

public class SignedTransaction {
    public Transaction txn;
    public Hash256 hash;
    public byte[] signingData;
    public byte[] previousSigningData;
    public String tx_blob;

    private SignedTransaction(Transaction of) {
        this.txn = (Transaction)STObject.translate.fromBytes(of.toBytes());
    }

    public SignedTransaction(SignedTransaction st) {
        this.txn = st.txn;
        this.hash = st.hash;
        this.signingData = st.signingData;
        this.previousSigningData = st.previousSigningData;
        this.tx_blob = st.tx_blob;
    }

    @Deprecated
    public SignedTransaction() {
    }

    public void multiSign(String base58Secret) {
        this.multiSign(Seed.fromBase58(base58Secret).keyPair());
    }

    public void multiSign(IKeyPair keyPair) {
        this.multiSignPrepare(keyPair, null, null, null);
    }

    public void multiSignPrepare(IKeyPair keyPair, Amount fee, UInt32 Sequence, UInt32 lastLedgerSequence) {
        if (lastLedgerSequence != null) {
            this.txn.put(UInt32.LastLedgerSequence, lastLedgerSequence);
        }
        if (Sequence != null) {
            this.txn.put(UInt32.Sequence, Sequence);
        }
        if (fee != null) {
            this.txn.put(Amount.Fee, fee);
        }
        byte[] pub = new byte[]{};
        this.txn.signingPubKey(new Blob(pub));
        AccountID account = AccountID.fromKeyPair(keyPair);
        this.txn.checkFormat();
        this.signingData = this.txn.multiSigningData(account);
        try {
            this.txn.txnSignature(new Blob(keyPair.signMessage(this.signingData)));
            BytesList blob = new BytesList();
            HalfSha512 id = HalfSha512.prefixed256(HashPrefix.transactionID);
            this.txn.toBytesSink(new MultiSink(blob, id));
            this.tx_blob = blob.bytesHex();
            this.hash = Hash256.prefixedHalfSha512(HashPrefix.transactionID, blob.bytes());
        }
        catch (Exception e) {
            this.previousSigningData = null;
            throw new RuntimeException(e);
        }
    }

    public void sign(String base58Secret) {
        this.sign(Seed.fromBase58(base58Secret).keyPair());
    }

    public static SignedTransaction fromTx(Transaction tx) {
        return new SignedTransaction(tx);
    }

    public void sign(IKeyPair keyPair) {
        this.prepare(keyPair, null, null, null);
    }

    public void prepare(IKeyPair keyPair, Amount fee, UInt32 Sequence, UInt32 lastLedgerSequence) {
        Blob pubKey = new Blob(keyPair.canonicalPubBytes());
        if (lastLedgerSequence != null) {
            this.txn.put(UInt32.LastLedgerSequence, lastLedgerSequence);
        }
        if (Sequence != null) {
            this.txn.put(UInt32.Sequence, Sequence);
        }
        if (fee != null) {
            this.txn.put(Amount.Fee, fee);
        }
        this.txn.signingPubKey(pubKey);
        this.txn.setCanonicalSignatureFlag();
        this.txn.checkFormat();
        this.signingData = this.txn.signingData();
        if (this.previousSigningData != null && Arrays.equals(this.signingData, this.previousSigningData)) {
            return;
        }
        try {
            this.txn.txnSignature(new Blob(keyPair.signMessage(this.signingData)));
            BytesList blob = new BytesList();
            HalfSha512 id = HalfSha512.prefixed256(HashPrefix.transactionID);
            this.txn.toBytesSink(new MultiSink(blob, id));
            this.tx_blob = blob.bytesHex();
            if (!Config.isUseGM()) {
                this.hash = Hash256.prefixedHalfSha512(HashPrefix.transactionID, blob.bytes());
            }
        }
        catch (Exception e) {
            this.previousSigningData = null;
            throw new RuntimeException(e);
        }
        this.previousSigningData = this.signingData;
    }

    public TransactionType transactionType() {
        return this.txn.transactionType();
    }
}

