/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.crypto.ecdsa;

import com.peersafe.base.crypto.ecdsa.ECDSASignature;
import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.crypto.ecdsa.SECP256K1;
import com.peersafe.base.utils.HashUtils;
import com.peersafe.base.utils.Sha512;
import com.peersafe.base.utils.Utils;
import java.math.BigInteger;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECPoint;

public class K256KeyPair
implements IKeyPair {
    BigInteger priv;
    BigInteger pub;
    byte[] pubBytes;

    public static byte[] getPublic(BigInteger secretKey) {
        return SECP256K1.basePointMultipliedBy(secretKey);
    }

    public static byte[] computePublicGenerator(BigInteger privateGen) {
        return K256KeyPair.getPublic(privateGen);
    }

    public static BigInteger computePublicKey(BigInteger secret) {
        return Utils.uBigInt(K256KeyPair.getPublic(secret));
    }

    public static BigInteger computePrivateGen(byte[] seedBytes) {
        return K256KeyPair.generateKey(seedBytes, null);
    }

    public static byte[] computePublicKey(byte[] publicGenBytes, int accountNumber) {
        ECPoint rootPubPoint = SECP256K1.curve().decodePoint(publicGenBytes);
        BigInteger scalar = K256KeyPair.generateKey(publicGenBytes, accountNumber);
        ECPoint point = SECP256K1.basePoint().multiply(scalar);
        ECPoint offset = rootPubPoint.add(point);
        return offset.getEncoded(true);
    }

    public static BigInteger computeSecretKey(BigInteger privateGen, byte[] publicGenBytes, int accountNumber) {
        return K256KeyPair.generateKey(publicGenBytes, accountNumber).add(privateGen).mod(SECP256K1.order());
    }

    public static BigInteger generateKey(byte[] seedBytes, Integer discriminator) {
        BigInteger key = null;
        for (long i = 0L; i <= 0xFFFFFFFFL; ++i) {
            Sha512 sha512 = new Sha512().add(seedBytes);
            if (discriminator != null) {
                sha512.addU32(discriminator);
            }
            sha512.addU32((int)i);
            byte[] keyBytes = sha512.finish256();
            key = Utils.uBigInt(keyBytes);
            if (key.compareTo(BigInteger.ZERO) == 1 && key.compareTo(SECP256K1.order()) == -1) break;
        }
        return key;
    }

    @Override
    public BigInteger pub() {
        return this.pub;
    }

    @Override
    public byte[] canonicalPubBytes() {
        return this.pubBytes;
    }

    public K256KeyPair(BigInteger priv, BigInteger pub) {
        this.priv = priv;
        this.pub = pub;
        this.pubBytes = pub.toByteArray();
    }

    @Override
    public BigInteger priv() {
        return this.priv;
    }

    public boolean verifyHash(byte[] hash, byte[] sigBytes) {
        return K256KeyPair.verify(hash, sigBytes, this.pub);
    }

    public byte[] signHash(byte[] bytes) {
        return K256KeyPair.signHash(bytes, this.priv);
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] sigBytes) {
        byte[] hash = HashUtils.halfSha512(message);
        return this.verifyHash(hash, sigBytes);
    }

    @Override
    public byte[] signMessage(byte[] message) {
        byte[] hash = HashUtils.halfSha512(message);
        return this.signHash(hash);
    }

    @Override
    public byte[] pub160Hash() {
        return HashUtils.SHA256_RIPEMD160(this.pubBytes);
    }

    @Override
    public String canonicalPubHex() {
        return Utils.bigHex(this.pub);
    }

    @Override
    public String privHex() {
        return Utils.bigHex(this.priv);
    }

    public static boolean verify(byte[] data, byte[] sigBytes, BigInteger pub) {
        ECDSASignature signature = ECDSASignature.decodeFromDER(sigBytes);
        if (signature == null) {
            return false;
        }
        ECDSASigner signer = new ECDSASigner();
        ECPoint pubPoint = SECP256K1.curve().decodePoint(pub.toByteArray());
        ECPublicKeyParameters params = new ECPublicKeyParameters(pubPoint, SECP256K1.params());
        signer.init(false, (CipherParameters)params);
        return signer.verifySignature(data, signature.r, signature.s);
    }

    public static byte[] signHash(byte[] bytes, BigInteger secret) {
        ECDSASignature sig = K256KeyPair.createECDSASignature(bytes, secret);
        byte[] der = sig.encodeToDER();
        if (!ECDSASignature.isStrictlyCanonical(der)) {
            throw new IllegalStateException("Signature is not strictly canonical");
        }
        return der;
    }

    private static ECDSASignature createECDSASignature(byte[] hash, BigInteger secret) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(secret, SECP256K1.params());
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] sigs = signer.generateSignature(hash);
        BigInteger r = sigs[0];
        BigInteger s = sigs[1];
        BigInteger otherS = SECP256K1.order().subtract(s);
        if (s.compareTo(otherS) == 1) {
            s = otherS;
        }
        return new ECDSASignature(r, s);
    }
}

