/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.crypto.sjcljson;

import com.peersafe.base.crypto.sjcljson.JSEscape;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Base64;
import org.json.JSONObject;

public class JSONEncrypt {
    int ks = 256;
    int iter = 1000;
    int ts = 64;
    String mode = "ccm";

    public JSONEncrypt(int ks, int iter, int ts) {
        this.ks = ks;
        this.iter = iter;
        this.ts = ts;
    }

    public JSONEncrypt() {
    }

    public JSONObject encrypt(String key, JSONObject blob, String adata) {
        JSONObject result = new JSONObject();
        SecureRandom random = new SecureRandom();
        byte[] iv = new byte[32];
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        random.nextBytes(iv);
        try {
            byte[] plainBytes = blob.toString().getBytes("UTF-8");
            byte[] adataBytes = adata.getBytes("utf8");
            byte[] nonce = this.computeNonce(iv, plainBytes);
            KeyParameter keyParam = this.createKey(key, salt, this.iter, this.ks);
            AEADParameters ccm = new AEADParameters(keyParam, this.macSize(this.ts), nonce, adataBytes);
            CCMBlockCipher aes = new CCMBlockCipher((BlockCipher)new AESFastEngine());
            aes.init(true, (CipherParameters)ccm);
            byte[] enc = new byte[aes.getOutputSize(plainBytes.length)];
            int res = aes.processBytes(plainBytes, 0, plainBytes.length, enc, 0);
            aes.doFinal(enc, res);
            result.put("ct", (Object)Base64.toBase64String((byte[])enc));
            result.put("iv", (Object)Base64.toBase64String((byte[])iv));
            result.put("salt", (Object)Base64.toBase64String((byte[])salt));
            result.put("adata", (Object)this.encodeAdata(adata));
            result.put("mode", (Object)this.mode);
            result.put("ks", this.ks);
            result.put("iter", this.iter);
            result.put("ts", this.ts);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int macSize(int ms) {
        return this.ts;
    }

    public JSONObject decrypt(String key, String json) throws InvalidCipherTextException {
        return this.decrypt(key, new JSONObject(json));
    }

    public JSONObject decrypt(String key, JSONObject json) throws InvalidCipherTextException {
        try {
            byte[] iv = Base64.decode((String)json.getString("iv"));
            byte[] cipherText = Base64.decode((String)json.getString("ct"));
            byte[] adataBytes = this.decodeAdataBytes(json.getString("adata"));
            byte[] nonce = this.computeNonce(iv, cipherText);
            if (!json.getString("mode").equals("ccm")) {
                throw new RuntimeException("Can only decrypt ccm mode encrypted data");
            }
            KeyParameter keyParam = this.createKey(key, Base64.decode((String)json.getString("salt")), json.getInt("iter"), json.getInt("ks"));
            AEADParameters ccm = new AEADParameters(keyParam, this.macSize(json.getInt("ts")), nonce, adataBytes);
            CCMBlockCipher aes = new CCMBlockCipher((BlockCipher)new AESFastEngine());
            aes.init(false, (CipherParameters)ccm);
            byte[] plainBytes = new byte[aes.getOutputSize(cipherText.length)];
            int res = aes.processBytes(cipherText, 0, cipherText.length, plainBytes, 0);
            aes.doFinal(plainBytes, res);
            String text = new String(plainBytes, "UTF-8");
            return new JSONObject(text);
        }
        catch (InvalidCipherTextException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String encodeAdata(String adata) {
        return JSEscape.escape(adata);
    }

    private byte[] decodeAdataBytes(String adata) {
        try {
            return JSEscape.unescape(adata).getBytes("utf8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyParameter createKey(String password, byte[] salt, int iterations, int keySizeInBits) {
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
        generator.init(PBEParametersGenerator.PKCS5PasswordToUTF8Bytes((char[])password.toCharArray()), salt, iterations);
        return (KeyParameter)generator.generateDerivedMacParameters(keySizeInBits);
    }

    private byte[] computeNonce(byte[] iv, byte[] plainBytes) {
        int l;
        int ivl = iv.length;
        int ol = plainBytes.length - this.ts / 8;
        for (l = 2; l < 4 && ol >>> 8 * l != 0; ++l) {
        }
        if (l < 15 - ivl) {
            l = 15 - ivl;
        }
        int newLength = 15 - l;
        return Arrays.copyOf(iv, newLength);
    }
}

