/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.crypto;

import com.peersafe.chainsql.util.Util;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Aes128 {
    private static final String KEY_ALGORITHM = "AES";

    private static Key convertToKey(byte[] keyBytes) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        return secretKey;
    }

    private static AlgorithmParameters generateIV(byte[] pass) throws Exception {
        AlgorithmParameters params = AlgorithmParameters.getInstance(KEY_ALGORITHM);
        byte[] iv = new byte[16];
        for (int i = 0; i < 16; ++i) {
            iv[i] = pass[i];
        }
        params.init(new IvParameterSpec(iv));
        return params;
    }

    public static byte[] encrypt(byte[] byteContent, byte[] password) {
        if (password.length == 0 || byteContent.length == 0) {
            return null;
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            password = Util.paddingPass(password, 16);
            Key key = Aes128.convertToKey(password);
            AlgorithmParameters algo = Aes128.generateIV(password);
            cipher.init(1, key, algo);
            byte[] result = cipher.doFinal(byteContent);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] decrypt(byte[] content, byte[] password) {
        if (password.length == 0 || content.length == 0) {
            return null;
        }
        try {
            password = Util.paddingPass(password, 16);
            Key key = Aes128.convertToKey(password);
            AlgorithmParameters algo = Aes128.generateIV(password);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, key, algo);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

