/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.chainsql.util;

import com.peersafe.base.config.Config;
import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.serialized.enums.TransactionType;
import com.peersafe.base.crypto.ecdsa.IKeyPair;
import com.peersafe.base.crypto.ecdsa.K256KeyPair;
import com.peersafe.base.crypto.ecdsa.Seed;
import com.peersafe.base.utils.Utils;
import com.peersafe.chainsql.crypto.EncryptCommon;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.json.JSONArray;
import org.json.JSONObject;

public class Util {
    private static String hexString = "0123456789ABCDEF";

    public static String StrToJsonStr(String args) {
        JSONObject a = new JSONObject(args);
        return a.toString();
    }

    public static JSONObject StrToJson(String args) {
        JSONObject a = new JSONObject(args);
        return a;
    }

    public static List<JSONObject> ListToJsonList(List<String> list) {
        ArrayList<JSONObject> listJson = new ArrayList<JSONObject>();
        for (String s : list) {
            JSONObject json = Util.StrToJson(s);
            listJson.add(json);
        }
        return listJson;
    }

    public static JSONArray strToJSONArray(String str) {
        JSONArray array = new JSONArray();
        array.put((Object)new JSONObject(str));
        return array;
    }

    public static JSONArray listToJSONArray(List<String> accounts) {
        JSONArray arr = new JSONArray();
        for (String obj : accounts) {
            arr.put((Object)obj);
        }
        return arr;
    }

    public static byte[] getRandomBytes(int length) {
        byte[] bytes = new byte[length];
        Random r = new Random();
        r.nextBytes(bytes);
        return bytes;
    }

    public static String bytesToHex(byte[] bytes) {
        return Util.encode(bytes);
    }

    public static byte[] hexToBytes(String bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length() / 2);
        for (int i = 0; i < bytes.length(); i += 2) {
            baos.write(hexString.indexOf(bytes.charAt(i)) << 4 | hexString.indexOf(bytes.charAt(i + 1)));
        }
        return baos.toByteArray();
    }

    public static String toHexString(String s) {
        String str = Util.encode(s.getBytes());
        return str;
    }

    public static String fromHexString(String s) {
        return Util.decode(s);
    }

    private static String encode(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(hexString.charAt((bytes[i] & 0xF0) >> 4));
            sb.append(hexString.charAt((bytes[i] & 0xF) >> 0));
        }
        return sb.toString();
    }

    private static String decode(String bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length() / 2);
        for (int i = 0; i < bytes.length(); i += 2) {
            baos.write(hexString.indexOf(bytes.charAt(i)) << 4 | hexString.indexOf(bytes.charAt(i + 1)));
        }
        return new String(baos.toByteArray());
    }

    public static byte[] paddingPass(byte[] password, int keyLength) {
        if (password.length == keyLength) {
            return password;
        }
        byte[] retByte = new byte[keyLength];
        if (password.length < keyLength) {
            byte byteToPad = (byte)(keyLength - password.length);
            for (int i = 0; i < keyLength; ++i) {
                retByte[i] = i < password.length ? password[i] : byteToPad;
            }
        } else {
            System.arraycopy(password, 0, retByte, 0, keyLength);
        }
        return retByte;
    }

    public static List<String> array(String val0, String ... vals) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(val0);
        res.addAll(Arrays.asList(vals));
        return res;
    }

    public static void unHexData(JSONObject tx) {
        String sTableName = "";
        if (tx.has("Tables")) {
            JSONObject table = (JSONObject)tx.getJSONArray("Tables").get(0);
            table = table.getJSONObject("Table");
            sTableName = Util.fromHexString(table.getString("TableName"));
            table.put("TableName", (Object)sTableName);
            if (table.has("TableNewName")) {
                table.put("TableNewName", (Object)Util.fromHexString(table.getString("TableNewName")));
            }
        }
        if (tx.has("Raw")) {
            String sRaw = Util.fromHexString(tx.getString("Raw"));
            tx.put("Raw", (Object)sRaw);
        }
        if (tx.has("Statements")) {
            tx.put("Statements", (Object)Util.fromHexString(tx.getString("Statements")));
        }
        if (tx.has("OperationRule")) {
            tx.put("OperationRule", (Object)Util.fromHexString(tx.getString("OperationRule")));
        }
    }

    public static void decryptData(byte[] pass, JSONObject tx) {
        String sTableName = "";
        if (tx.has("Tables")) {
            JSONObject table = (JSONObject)tx.getJSONArray("Tables").get(0);
            table = table.getJSONObject("Table");
            sTableName = Util.fromHexString(table.getString("TableName"));
            table.put("TableName", (Object)sTableName);
            if (table.has("TableNewName")) {
                table.put("TableNewName", (Object)Util.fromHexString(table.getString("TableNewName")));
            }
        }
        if (tx.has("Raw")) {
            String sRaw = tx.getString("Raw");
            if (pass != null) {
                byte[] rawBytes = Util.hexToBytes(sRaw);
                rawBytes = EncryptCommon.symDecrypt(rawBytes, pass);
                sRaw = new String(rawBytes);
            } else {
                sRaw = Util.fromHexString(sRaw);
            }
            tx.put("Raw", (Object)sRaw);
        }
        if (tx.has("Statements")) {
            String sStatement = Util.fromHexString(tx.getString("Statements"));
            JSONArray statement = new JSONArray(sStatement);
            for (int i = 0; i < statement.length(); ++i) {
                JSONObject obj = statement.getJSONObject(i);
                Util.decryptData(pass, obj);
            }
            tx.put("Statements", (Object)statement);
        }
        if (tx.has("OperationRule")) {
            tx.put("OperationRule", (Object)Util.fromHexString(tx.getString("OperationRule")));
        }
    }

    public static void waiting() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static JSONObject successObject() {
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)"success");
        return obj;
    }

    public static JSONObject errorObject(String errMsg) {
        JSONObject obj = new JSONObject();
        obj.put("error", (Object)"internalError");
        obj.put("error_message", (Object)errMsg);
        return obj;
    }

    public static byte[] intToBytes(int value) {
        byte[] src = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return src;
    }

    public static int bytesToInt(byte[] src) {
        int value = src[3] & 0xFF | (src[2] & 0xFF) << 8 | (src[1] & 0xFF) << 16 | (src[0] & 0xFF) << 24;
        return value;
    }

    public static boolean isChainsqlType(TransactionType type) {
        return type == TransactionType.TableListSet || type == TransactionType.SQLStatement || type == TransactionType.SQLTransaction || type == TransactionType.Contract;
    }

    public static Amount getExtraFee(JSONObject json, TransactionType type) {
        if (Util.isChainsqlType(type)) {
            int zxcDrops = 1000000;
            double multiplier = 0.001;
            if (json.has("Raw")) {
                String rawHex = json.getString("Raw");
                int rawSize = rawHex.length() / 2;
                multiplier += (double)rawSize / 1024.0;
            } else if (json.has("Statements")) {
                String statementsHex = json.getString("Statements");
                int stateSize = statementsHex.length() / 2;
                multiplier += (double)stateSize / 1024.0;
            }
            return Amount.fromString(String.valueOf((int)(multiplier * (double)zxcDrops)));
        }
        return Amount.fromString("0");
    }

    public static String getNewAccountFromTx(JSONObject tx) {
        JSONArray nodes = tx.getJSONObject("meta").getJSONArray("AffectedNodes");
        ArrayList<String> listAddr = new ArrayList<String>();
        for (int i = 0; i < nodes.length(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            if (!node.has("CreatedNode") || !node.getJSONObject("CreatedNode").getJSONObject("NewFields").has("ContractCode")) continue;
            listAddr.add(node.getJSONObject("CreatedNode").getJSONObject("NewFields").getString("Account"));
        }
        if (listAddr.size() == 1) {
            return (String)listAddr.get(0);
        }
        AccountID account = AccountID.fromAddress(tx.getString("Account"));
        byte[] account_bytes = account.toBytes();
        byte[] accountBytes = new byte[account_bytes.length + 4];
        System.arraycopy(account_bytes, 0, accountBytes, 0, account_bytes.length);
        byte[] sequence = Util.intToBytes(tx.getInt("Sequence"));
        System.arraycopy(sequence, 0, accountBytes, account_bytes.length, 4);
        SHA256Digest sha = new SHA256Digest();
        sha.update(accountBytes, 0, accountBytes.length);
        byte[] result = new byte[sha.getDigestSize()];
        sha.doFinal(result, 0);
        RIPEMD160Digest d = new RIPEMD160Digest();
        d.update(result, 0, result.length);
        byte[] o = new byte[d.getDigestSize()];
        d.doFinal(o, 0);
        String address = Config.getB58IdentiferCodecs().encodeAddress(o);
        for (String addr : listAddr) {
            if (!addr.equals(address)) continue;
            return addr;
        }
        return null;
    }

    public static byte[] sign(byte[] message, String secret) {
        IKeyPair keyPair = Seed.getKeyPair(secret);
        return keyPair.signMessage(message);
    }

    public static boolean verify(byte[] message, byte[] signature, String publicKey) {
        byte[] pubBytes = null;
        pubBytes = publicKey.length() == 66 ? Util.hexToBytes(publicKey) : Config.getB58IdentiferCodecs().decode(publicKey, 35);
        K256KeyPair keyPair = new K256KeyPair(null, Utils.uBigInt(pubBytes));
        return keyPair.verifySignature(message, signature);
    }

    public static String getPublicHexFromSecret(String secret) {
        Seed seed = Seed.fromBase58(secret);
        IKeyPair keyPair = seed.keyPair();
        byte[] pubBytes = keyPair.canonicalPubBytes();
        return Util.bytesToHex(pubBytes);
    }
}

