/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.payments;

import com.peersafe.base.client.Account;
import com.peersafe.base.client.Client;
import com.peersafe.base.client.enums.Command;
import com.peersafe.base.client.payments.Alternative;
import com.peersafe.base.client.payments.Alternatives;
import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.client.requests.Request;
import com.peersafe.base.client.responses.Response;
import com.peersafe.base.client.transactions.ManagedTxn;
import com.peersafe.base.core.coretypes.AccountID;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.Currency;
import com.peersafe.base.core.coretypes.Issue;
import com.peersafe.base.core.coretypes.PathSet;
import com.peersafe.base.core.coretypes.STObject;
import com.peersafe.base.core.types.known.tx.txns.Payment;
import java.math.BigDecimal;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PaymentFlow
extends Publisher<events> {
    Client client;
    private final Client.OnPathFind onPathFind = new Client.OnPathFind(){

        @Override
        public void called(JSONObject jsonObject) {
            int id = jsonObject.getInt("id");
            if (PaymentFlow.this.pathFind != null && id == PaymentFlow.this.pathFind.id) {
                PaymentFlow.this.emit(OnAlternatives.class, PaymentFlow.this.constructAlternatives(jsonObject.getJSONArray("alternatives"), PaymentFlow.this.alternatives));
            }
        }
    };
    private final Client.OnConnected onConnected = new Client.OnConnected(){

        @Override
        public void called(Client client) {
            if (PaymentFlow.this.pathFind != null) {
                PaymentFlow.this.makePathFindRequestIfCan();
            }
        }
    };
    public Amount destinationAmount;
    Account srcAccount;
    AccountID dest;
    AccountID src;
    STObject srcInfo;
    STObject destInfo;
    Alternatives alternatives;
    Currency destAmountCurrency;
    BigDecimal destAmountValue;
    Request pathFind;
    public JSONObject json = null;

    public PaymentFlow(Client client) {
        this.client = client;
        client.on(Client.OnConnected.class, this.onConnected);
        client.on(Client.OnPathFind.class, this.onPathFind);
        this.on(OnAlternatives.class, new OnAlternatives(){

            @Override
            public void called(Alternatives alts) {
                PaymentFlow.this.alternatives = alts;
            }
        });
    }

    public void unsubscribeFromClientEvents() {
        this.client.removeListener(Client.OnConnected.class, this.onConnected);
        this.client.removeListener(Client.OnPathFind.class, this.onPathFind);
    }

    public Request requestAccountInfo(final AccountID id) {
        Request request = this.client.newRequest(Command.account_info);
        request.json("account", id);
        request.once(Request.OnResponse.class, new Request.OnResponse(){

            @Override
            public void called(Response response) {
                if (response.succeeded) {
                    JSONObject accountJSON = response.result.optJSONObject("account_data");
                    STObject accountData = STObject.translate.fromJSONObject(accountJSON);
                    PaymentFlow.this.json = accountJSON;
                    if (PaymentFlow.this.src == id) {
                        PaymentFlow.this.srcInfo = accountData;
                    } else if (PaymentFlow.this.dest == id) {
                        PaymentFlow.this.destInfo = accountData;
                        PaymentFlow.this.emit(OnDestInfo.class, PaymentFlow.this.destInfo);
                    }
                }
            }
        });
        request.request();
        return request;
    }

    public PaymentFlow source(Account account) {
        AccountID id = account.id();
        if (this.src == null || !this.src.equals(id)) {
            this.requestAccountInfo(id);
            this.srcAccount = account;
            this.src = this.srcAccount.id();
            this.makePathFindRequestIfCan();
        }
        return this;
    }

    public PaymentFlow destination(AccountID id) {
        if (this.dest == null || !this.dest.equals(id)) {
            this.requestAccountInfo(id);
            this.dest = id;
            this.makePathFindRequestIfCan();
        }
        return this;
    }

    public PaymentFlow destinationAmountValue(BigDecimal amt) {
        if (this.destAmountValue == null || amt == null || amt.compareTo(this.destAmountValue) != 0) {
            this.destAmountValue = amt;
            this.makePathFindRequestIfCan();
        }
        return this;
    }

    public void makePathFindRequestIfNoneAlready() {
        if (this.pathFind == null) {
            this.makePathFindRequestIfCan();
        }
    }

    public void makePathFindRequestIfCan() {
        Alternatives alts;
        this.ignoreCurrentRequestAndPublishStaleState();
        if (this.tooLittleInfoForPathFindRequest()) {
            return;
        }
        this.destinationAmount = this.destAmountCurrency.equals(Currency.ZXC) ? Issue.ZXC.amount(this.destAmountValue) : new Amount(this.destAmountValue, this.destAmountCurrency, this.dest);
        if (this.destinationAmount.isNative() && !(alts = this.constructInitialAlternatives()).isEmpty()) {
            this.emit(OnAlternatives.class, alts);
        }
        this.pathFind = this.client.newRequest(Command.path_find);
        this.pathFind.json("subcommand", "create");
        this.pathFind.json("source_account", this.src);
        this.pathFind.json("destination_account", this.dest);
        this.pathFind.json("destination_amount", this.destinationAmount.toJSON());
        this.pathFind.once(Request.OnResponse.class, new Request.OnResponse(){

            @Override
            public void called(Response response) {
                if (response.succeeded && response.request == PaymentFlow.this.pathFind) {
                    try {
                        JSONArray alternatives = response.result.getJSONArray("alternatives");
                        PaymentFlow.this.emit(OnAlternatives.class, PaymentFlow.this.constructAlternatives(alternatives, null));
                    }
                    catch (JSONException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        this.pathFind.request();
        this.emit(OnPathFind.class, this.pathFind);
    }

    private Alternatives constructInitialAlternatives() {
        return this.constructAlternatives(null, null);
    }

    private Alternatives constructAlternatives(JSONArray alternatives, Alternatives prior) {
        Alternatives alts = alternatives == null ? new Alternatives() : new Alternatives(alternatives, prior);
        if (this.destinationAmount.isNative() && !this.src.equals(this.dest) && this.srcCanSendNative(this.destinationAmount)) {
            this.injectNativeAlternative(alts, prior);
        }
        return alts;
    }

    private boolean srcCanSendNative(Amount destinationAmount) {
        return true;
    }

    private void injectNativeAlternative(Alternatives alts, Alternatives prior) {
        Alternative directXRP = new Alternative(new PathSet(), this.destinationAmount);
        alts.addRecyclingPrior(0, directXRP, prior);
    }

    private boolean tooLittleInfoForPathFindRequest() {
        return this.destAmountValue == null || this.destAmountValue.compareTo(BigDecimal.ZERO) == 0 || this.destAmountCurrency == null || this.src == null || this.dest == null;
    }

    private void ignoreCurrentRequestAndPublishStaleState() {
        this.pathFind = null;
        if (this.alternatives != null) {
            this.emit(OnAlternativesStale.class, this.alternatives);
        }
    }

    public PaymentFlow destinationAmountCurrency(Currency currency) {
        if (this.destAmountCurrency == null || !currency.equals(this.destAmountCurrency)) {
            this.destAmountCurrency = currency;
            this.makePathFindRequestIfCan();
        }
        return this;
    }

    public void abort() {
        this.requestPathFindClose();
        this.ignoreCurrentRequestAndPublishStaleState();
    }

    public ManagedTxn createPayment(Alternative alternative, BigDecimal sendMaxMultiplier) {
        Amount sourceAmount = alternative.sourceAmount;
        boolean hasPaths = alternative.hasPaths();
        this.ignoreCurrentRequestAndPublishStaleState();
        this.requestPathFindClose();
        Payment payment = new Payment();
        ManagedTxn managed = this.srcAccount.transactionManager().manage(payment);
        payment.destination(this.dest);
        if (hasPaths) {
            payment.paths(alternative.paths);
        }
        if (!alternative.directXRP()) {
            payment.sendMax(sourceAmount.multiply(sendMaxMultiplier));
        }
        payment.amount(this.destinationAmount);
        return managed;
    }

    private void requestPathFindClose() {
        Request request = this.client.newRequest(Command.path_find);
        request.json("subcommand", "close");
        request.request();
    }

    public PaymentFlow onAlternatives(OnAlternatives handler) {
        this.on(OnAlternatives.class, handler);
        return this;
    }

    public static interface OnPathFind
    extends events<Request> {
    }

    public static interface OnAlternativesStale
    extends events<Alternatives> {
    }

    public static interface OnAlternatives
    extends events<Alternatives> {
    }

    public static interface OnDestInfo
    extends events<STObject> {
    }

    public static interface events<T>
    extends Publisher.Callback<T> {
    }
}

