/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.subscriptions;

import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.core.coretypes.AccountID;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class SubscriptionManager
extends Publisher<events> {
    public boolean paused = false;
    Set<Stream> streams = new TreeSet<Stream>();
    Set<AccountID> accounts = new TreeSet<AccountID>();

    public void pauseEventEmissions() {
        this.paused = true;
    }

    public void unpauseEventEmissions() {
        this.paused = false;
    }

    <T> Set<T> single(T element) {
        TreeSet<T> set = new TreeSet<T>();
        set.add(element);
        return set;
    }

    public void addStream(Stream s) {
        this.streams.add(s);
        this.subscribeStream(s);
    }

    public void removeStream(Stream s) {
        this.streams.remove((Object)s);
        this.unsubscribeStream(s);
    }

    private void subscribeStream(Stream s) {
        this.emit(OnSubscribed.class, this.basicSubscriptionObject(this.single(s), null));
    }

    @Override
    public <A, T extends Publisher.Callback<A>> int emit(Class<T> key, A args) {
        if (this.paused) {
            return 0;
        }
        return super.emit(key, args);
    }

    private void unsubscribeStream(Stream s) {
        this.emit(OnUnSubscribed.class, this.basicSubscriptionObject(this.single(s), null));
    }

    public void addAccount(AccountID a) {
        this.accounts.add(a);
        this.emit(OnSubscribed.class, this.basicSubscriptionObject(null, this.single(a)));
    }

    public void addMessage(JSONObject json) {
        this.emit(OnSubscribed.class, json);
    }

    public void removeAccount(AccountID a) {
        this.accounts.remove(a);
        this.emit(OnUnSubscribed.class, this.basicSubscriptionObject(null, this.single(a)));
    }

    private JSONObject basicSubscriptionObject(Set<Stream> streams, Set<AccountID> accounts) {
        JSONObject subs = new JSONObject();
        if (streams != null && streams.size() > 0) {
            subs.put("streams", (Object)this.getJsonArray(streams));
        }
        if (accounts != null && accounts.size() > 0) {
            subs.put("accounts", (Object)this.getJsonArray(accounts));
        }
        return subs;
    }

    private JSONArray getJsonArray(Collection<?> streams) {
        JSONArray jsonArray = new JSONArray();
        for (Object obj : streams) {
            jsonArray.put(obj);
        }
        return jsonArray;
    }

    public JSONObject allSubscribed() {
        return this.basicSubscriptionObject(this.streams, this.accounts);
    }

    public static enum Stream {
        server,
        ledger,
        transactions,
        transactions_propose;

    }

    public static interface OnUnSubscribed
    extends events<JSONObject> {
    }

    public static interface OnSubscribed
    extends events<JSONObject> {
    }

    public static interface events<T>
    extends Publisher.Callback<T> {
    }
}

