/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.subscriptions.ledger;

import java.util.TreeSet;

public class ClearedLedgersSet {
    public static boolean DEBUG = true;
    long lastCleared = -1L;
    long firstCleared = -1L;
    TreeSet<Long> clearedLedgers = new TreeSet();
    TreeSet<Long> clearedLedgersNeverCleared = new TreeSet();

    public TreeSet<Long> cleared() {
        return this.clearedLedgers;
    }

    public int size() {
        return this.clearedLedgers.size();
    }

    public void clear(long ledger_index) {
        if (DEBUG) {
            this.clearedLedgersNeverCleared.add(ledger_index);
        }
        this.clearedLedgers.add(ledger_index);
    }

    public void clearIfNoGaps() {
        if (this.okToClear()) {
            if (DEBUG) {
                if (this.firstCleared == -1L) {
                    this.firstCleared = this.clearedLedgers.first();
                }
                this.lastCleared = Math.max(this.clearedLedgers.last(), this.lastCleared);
                for (long i = this.firstCleared; i <= this.lastCleared; ++i) {
                    if (!this.clearedLedgersNeverCleared.contains(i)) {
                        throw new AssertionError();
                    }
                }
            }
            this.clearedLedgers.clear();
        }
    }

    public TreeSet<Long> gaps() {
        TreeSet<Long> gaps = new TreeSet<Long>();
        int i = 0;
        long prev = 0L;
        for (Long clearedLedger : this.clearedLedgers) {
            if (i++ > 0) {
                for (long j = prev + 1L; j < clearedLedger; ++j) {
                    gaps.add(j);
                }
            }
            prev = clearedLedger;
        }
        return gaps;
    }

    public boolean okToClear() {
        return this.gaps().size() == 0;
    }

    public boolean contains(long ledger_index) {
        if (DEBUG) {
            boolean authoritativeHas = this.clearedLedgersNeverCleared.contains(ledger_index);
            if (authoritativeHas && !this.clearedLedgers.contains(ledger_index)) {
                throw new AssertionError();
            }
            return authoritativeHas;
        }
        return this.clearedLedgers.contains(ledger_index);
    }
}

