/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.client.transactions;

import com.peersafe.base.client.pubsub.CallbackContext;
import com.peersafe.base.client.pubsub.Publisher;
import com.peersafe.base.client.requests.Request;
import com.peersafe.base.client.responses.Response;
import com.peersafe.base.client.transactions.Submission;
import com.peersafe.base.core.coretypes.Amount;
import com.peersafe.base.core.coretypes.hash.Hash256;
import com.peersafe.base.core.coretypes.uint.UInt32;
import com.peersafe.base.core.types.known.tx.Transaction;
import com.peersafe.base.core.types.known.tx.result.TransactionResult;
import com.peersafe.base.core.types.known.tx.signed.SignedTransaction;
import java.util.ArrayList;
import java.util.TreeSet;

public class ManagedTxn
extends SignedTransaction {
    public TransactionResult result;
    private boolean isSequencePlug;
    private String description;
    private final Publisher<events> publisher = new Publisher();
    private boolean finalized = false;
    public ArrayList<Submission> submissions = new ArrayList();
    private TreeSet<Hash256> submittedIDs = new TreeSet();

    public ManagedTxn onValidated(final Publisher.Callback<ManagedTxn> handler) {
        this.on(OnTransactionValidated.class, new OnTransactionValidated(){

            @Override
            public void called(TransactionResult args) {
                ManagedTxn.this.result = args;
                handler.called(ManagedTxn.this);
            }
        });
        return this;
    }

    public ManagedTxn onSubmitSuccess(OnSubmitSuccess cb) {
        this.on(OnSubmitSuccess.class, cb);
        return this;
    }

    public ManagedTxn onError(final Publisher.Callback<Response> cb) {
        this.on(OnSubmitFailure.class, new OnSubmitFailure(){

            @Override
            public void called(Response args) {
                cb.called(args);
            }
        });
        this.on(OnSubmitError.class, new OnSubmitError(){

            @Override
            public void called(Response args) {
                cb.called(args);
            }
        });
        return this;
    }

    public <T extends events> boolean removeListener(Class<T> key, Publisher.Callback cb) {
        return this.publisher.removeListener(key, cb);
    }

    public <T extends events> int emit(Class<T> key, Object args) {
        return this.publisher.emit(key, args);
    }

    public <T extends events> void once(Class<T> key, CallbackContext executor, T cb) {
        this.publisher.once(key, executor, cb);
    }

    public <T extends events> void once(Class<T> key, T cb) {
        this.publisher.once(key, cb);
    }

    public <T extends events> void on(Class<T> key, CallbackContext executor, T cb) {
        this.publisher.on(key, executor, cb);
    }

    public <T extends events> void on(Class<T> key, T cb) {
        this.publisher.on(key, cb);
    }

    public Publisher<events> publisher() {
        return this.publisher;
    }

    public boolean isSequencePlug() {
        return this.isSequencePlug;
    }

    public void setSequencePlug(boolean isNoop) {
        this.isSequencePlug = isNoop;
        this.setDescription("SequencePlug");
    }

    public String description() {
        if (this.description == null) {
            return this.txn.transactionType().toString();
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ManagedTxn(Transaction txn) {
        this.txn = txn;
    }

    public ManagedTxn(SignedTransaction txn) {
        super(txn);
    }

    public boolean responseWasToLastSubmission(Response res) {
        Request req = this.lastSubmission().request;
        return res.request == req;
    }

    public boolean finalizedOrResponseIsToPriorSubmission(Response res) {
        return this.isFinalized() || !this.responseWasToLastSubmission(res);
    }

    public Submission lastSubmission() {
        if (this.submissions.isEmpty()) {
            return null;
        }
        return this.submissions.get(this.submissions.size() - 1);
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public void setFinalized() {
        this.finalized = true;
    }

    public void trackSubmitRequest(Request submitRequest, long ledger_index) {
        Submission submission = new Submission(submitRequest, this.sequence(), this.hash, ledger_index, this.txn.get(Amount.Fee), this.txn.get(UInt32.LastLedgerSequence));
        this.submissions.add(submission);
        this.trackSubmittedID();
    }

    public void trackSubmittedID() {
        this.submittedIDs.add(this.hash);
    }

    boolean wasSubmittedWith(Hash256 hash) {
        return this.submittedIDs.contains(hash);
    }

    public UInt32 sequence() {
        return this.txn.sequence();
    }

    public static interface OnTransactionValidated
    extends events<TransactionResult> {
    }

    public static interface OnSubmitError
    extends events<Response> {
    }

    public static interface OnSubmitFailure
    extends events<Response> {
    }

    public static interface OnSubmitSuccess
    extends events<Response> {
    }

    public static interface events<T>
    extends Publisher.Callback<T> {
    }
}

