/*
 * Decompiled with CFR 0.152.
 */
package com.peersafe.base.config;

import com.peersafe.base.encodings.B58IdentiferCodecs;
import com.peersafe.base.encodings.base58.B58;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Config {
    public static final String DEFAULT_ALPHABET = "zpxhncf39wBUDNEGHJKLM4PQRST7VWXYZ2badeCg65jkm8oFqi1tuvAsyr";
    private static B58IdentiferCodecs b58IdentiferCodecs;
    private static double feeCushion;
    private static B58 b58;
    private static boolean useSM_;
    private static boolean newKeyPair_;
    public static boolean bouncyInitiated;

    public static void setAlphabet(String alphabet) {
        b58 = new B58(alphabet);
        b58IdentiferCodecs = new B58IdentiferCodecs(b58);
    }

    public static B58IdentiferCodecs getB58IdentiferCodecs() {
        return b58IdentiferCodecs;
    }

    public static B58 getB58() {
        return b58;
    }

    public static void initBouncy() {
        if (!bouncyInitiated) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            bouncyInitiated = true;
        }
    }

    public static double getFeeCushion() {
        return feeCushion;
    }

    public static void setFeeCushion(double fee_cushion) {
        feeCushion = fee_cushion;
    }

    public static boolean isUseGM() {
        return useSM_;
    }

    public static boolean isNewKeyPair() {
        return newKeyPair_;
    }

    public static void setNewKeyPair(boolean newKeyPair_) {
        Config.newKeyPair_ = newKeyPair_;
    }

    public static boolean setUseGM(boolean useGM, boolean bNewKeyPair, String pin) {
        if (useGM) {
            newKeyPair_ = bNewKeyPair;
            return true;
        }
        useSM_ = useGM;
        return true;
    }

    static {
        useSM_ = false;
        newKeyPair_ = false;
        bouncyInitiated = false;
        Config.setAlphabet(DEFAULT_ALPHABET);
        Config.setFeeCushion(1.1);
        Config.initBouncy();
    }
}

